/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.listeners;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCustomDialogDelegate;
import com.fs.starfarer.api.campaign.CustomDialogDelegate;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.listeners.BaseIndustryOptionProvider;
import com.fs.starfarer.api.campaign.listeners.DialogCreatorUI;
import com.fs.starfarer.api.campaign.listeners.IndustryOptionProvider;
import com.fs.starfarer.api.impl.campaign.PlanetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestIndustryOptionProvider
extends BaseIndustryOptionProvider {
    public static Object INTERACTION_PLUGIN = new Object();
    public static Object INTERACTION_TRIGGER = new Object();
    public static Object CUSTOM_PLUGIN = new Object();
    public static Object STORY_ACTION = new Object();
    public static Object IMMEDIATE_ACTION = new Object();
    public static Object DISABLED_OPTION = new Object();

    @Override
    public List<IndustryOptionProvider.IndustryOptionData> getIndustryOptions(Industry ind) {
        if (this.isUnsuitable(ind, false)) {
            return null;
        }
        if (ind.getMarket().getId().equals("jangala") && ind.getId().equals("population")) {
            ArrayList<IndustryOptionProvider.IndustryOptionData> result = new ArrayList<IndustryOptionProvider.IndustryOptionData>();
            IndustryOptionProvider.IndustryOptionData opt = new IndustryOptionProvider.IndustryOptionData("Interaction dialog with plugin", INTERACTION_PLUGIN, ind, this);
            opt.color = Color.GREEN;
            result.add(opt);
            opt = new IndustryOptionProvider.IndustryOptionData("Interaction dialog with rule trigger", INTERACTION_TRIGGER, ind, this);
            opt.color = Color.MAGENTA;
            result.add(opt);
            opt = new IndustryOptionProvider.IndustryOptionData("Custom dialog plugin", CUSTOM_PLUGIN, ind, this);
            opt.color = Color.ORANGE;
            result.add(opt);
            opt = new IndustryOptionProvider.IndustryOptionData("Story point action dialog", STORY_ACTION, ind, this);
            opt.color = Misc.getStoryOptionColor();
            result.add(opt);
            opt = new IndustryOptionProvider.IndustryOptionData("Take an immediate action", IMMEDIATE_ACTION, ind, this);
            opt.color = Color.RED;
            result.add(opt);
            opt = new IndustryOptionProvider.IndustryOptionData("Disabled option", DISABLED_OPTION, ind, this);
            opt.enabled = false;
            result.add(opt);
            return result;
        }
        return null;
    }

    @Override
    public void createTooltip(IndustryOptionProvider.IndustryOptionData opt, TooltipMakerAPI tooltip, float width) {
        if (opt.id == INTERACTION_PLUGIN) {
            tooltip.addPara("This option shows a standard interaction dialog with a custom plugin. In this case, the dialog used is the PlanetInteractionDialogPluginImpl, with Corvus - the star - as the target.", 0.0f);
        } else if (opt.id == INTERACTION_TRIGGER) {
            tooltip.addPara("This option shows a rule-driven interaction dialog. In this case, the dialog targets the Asharu Terraforming Platform and fires the OpenInteractionDialog trigger to start the interaction.", 0.0f);
        } else if (opt.id == CUSTOM_PLUGIN) {
            tooltip.addPara("This option shows a custom dialog driven by a CustomDialogDelegate implementation.", 0.0f);
        } else if (opt.id == STORY_ACTION) {
            tooltip.addPara("This option brings up a dialog where the player may spend some number of story points to perform an action, and possibly receive bonus experience.", 0.0f);
        } else if (opt.id == IMMEDIATE_ACTION) {
            tooltip.addPara("This option will not show a dialog but instead prints some text to standard out.", 0.0f);
        } else if (opt.id == DISABLED_OPTION) {
            tooltip.addPara("This option is disabled.", 0.0f);
        }
    }

    @Override
    public void optionSelected(IndustryOptionProvider.IndustryOptionData opt, DialogCreatorUI ui) {
        if (opt.id == INTERACTION_PLUGIN) {
            PlanetAPI planet = Global.getSector().getStarSystem("corvus").getStar();
            PlanetInteractionDialogPluginImpl plugin = new PlanetInteractionDialogPluginImpl();
            plugin.setUnpauseOnExit(false);
            ui.showDialog((SectorEntityToken)planet, plugin);
        } else if (opt.id == INTERACTION_TRIGGER) {
            SectorEntityToken station = Global.getSector().getEntityById("corvus_abandoned_station");
            ui.showDialog(station, "OpenInteractionDialog");
        } else if (opt.id == CUSTOM_PLUGIN) {
            BaseCustomDialogDelegate delegate = new BaseCustomDialogDelegate(){

                public void createCustomDialog(CustomPanelAPI panel, CustomDialogDelegate.CustomDialogCallback callback) {
                    TooltipMakerAPI info = panel.createUIElement(800.0f, 500.0f, false);
                    info.addPara("Minimalistic custom dialog implementation.", 0.0f);
                    panel.addUIElement(info).inTL(0.0f, 0.0f);
                }

                public boolean hasCancelButton() {
                    return true;
                }

                public void customDialogConfirm() {
                    System.out.println("customDialogConfirm() called");
                }

                public void customDialogCancel() {
                    System.out.println("customDialogCancel() called");
                }
            };
            ui.showDialog(800.0f, 500.0f, delegate);
        } else if (opt.id == STORY_ACTION) {
            SetStoryOption.StoryOptionParams params = new SetStoryOption.StoryOptionParams(null, 1, "bonusXP_if_any_in_settings.json", Sounds.STORY_POINT_SPEND, "Performed a test action in TestIndustryOptionProvider");
            SetStoryOption.BaseOptionStoryPointActionDelegate delegate = new SetStoryOption.BaseOptionStoryPointActionDelegate(null, params){

                public void confirm() {
                }

                public String getTitle() {
                    return null;
                }

                public void createDescription(TooltipMakerAPI info) {
                    info.setParaInsigniaLarge();
                    info.addPara("Test action that costs one story point.", -10.0f);
                    info.addSpacer(20.0f);
                    super.createDescription(info);
                }
            };
            ui.showDialog(delegate);
        } else if (opt.id == IMMEDIATE_ACTION) {
            System.out.println("IMMEDIATE ACTION TAKEN");
        }
    }

    @Override
    public void addToIndustryTooltip(Industry ind, Industry.IndustryTooltipMode mode, TooltipMakerAPI tooltip, float width, boolean expanded) {
        if (this.getIndustryOptions(ind) == null) {
            return;
        }
        float opad = 10.0f;
        tooltip.addSectionHeading("TestIndustryOptionProvider", Alignment.MID, opad);
        tooltip.addPara("Information about changes made to the this industry by any of the custom options would go here.", opad);
    }
}

