/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.characters;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.BaseSkillsChangeEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.plog.OfficerSkillGainRecord;
import com.fs.starfarer.api.impl.campaign.plog.PlaythroughLog;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkillsChangeOfficerEffect
extends BaseSkillsChangeEffect {
    public void setMap(OfficerDataMap map, Map<String, Object> dataMap) {
        String key = this.getClass().getSimpleName();
        dataMap.put(key, map);
    }

    public OfficerDataMap getMap(Map<String, Object> dataMap) {
        String key = this.getClass().getSimpleName();
        OfficerDataMap map = (OfficerDataMap)dataMap.get(key);
        if (map == null) {
            map = new OfficerDataMap();
            dataMap.put(key, map);
        }
        return map;
    }

    public int getMaxLevel(MutableCharacterStatsAPI stats) {
        int bonus = (int)stats.getDynamic().getMod("officer_max_level_mod").computeEffective(0.0f);
        return (int)Global.getSettings().getFloat("officerMaxLevel") + bonus;
    }

    public int getMaxEliteSkills(MutableCharacterStatsAPI stats) {
        int bonus = (int)stats.getDynamic().getMod("officer_max_elite_skills_mod").computeEffective(0.0f);
        return (int)Global.getSettings().getFloat("officerMaxEliteSkills") + bonus;
    }

    public int getNumEliteSkills(PersonAPI person) {
        int num = 0;
        for (MutableCharacterStatsAPI.SkillLevelAPI sl : person.getStats().getSkillsCopy()) {
            if (!(sl.getLevel() >= 2.0f)) continue;
            ++num;
        }
        return num;
    }

    public OfficerDataMap getEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to) {
        OfficerDataMap result = new OfficerDataMap();
        int maxOfficersPre = (int)from.getOfficerNumber().getModifiedValue();
        int maxOfficersPost = (int)to.getOfficerNumber().getModifiedValue();
        LinkedHashMap<OfficerDataAPI, FleetMemberAPI> members = new LinkedHashMap<OfficerDataAPI, FleetMemberAPI>();
        LinkedHashSet<OfficerDataAPI> unusable = new LinkedHashSet<OfficerDataAPI>();
        if (maxOfficersPre > maxOfficersPost) {
            int count = 0;
            for (OfficerDataAPI officerDataAPI : Global.getSector().getPlayerFleet().getFleetData().getOfficersCopy()) {
                boolean merc = Misc.isMercenary(officerDataAPI.getPerson());
                if (!merc) {
                    ++count;
                }
                if (count <= maxOfficersPost || merc) continue;
                unusable.add(officerDataAPI);
            }
        }
        block1: for (OfficerDataAPI officer : Global.getSector().getPlayerFleet().getFleetData().getOfficersCopy()) {
            for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
                if (member.getCaptain() != officer.getPerson()) continue;
                members.put(officer, member);
                continue block1;
            }
        }
        int maxLevelPre = this.getMaxLevel(from);
        int n = this.getMaxLevel(to);
        int maxElitePre = this.getMaxEliteSkills(from);
        int maxElitePost = this.getMaxEliteSkills(to);
        for (OfficerDataAPI data : Global.getSector().getPlayerFleet().getFleetData().getOfficersCopy()) {
            int numElite;
            boolean pods;
            PersonAPI person = data.getPerson();
            MutableCharacterStatsAPI stats = person.getStats();
            if (Misc.isMercenary(person) || (pods = person.getMemoryWithoutUpdate().getBoolean("$exceptionalSleeperPodOfficer"))) continue;
            OfficerEffectData effect = new OfficerEffectData();
            effect.data = data;
            effect.newLevel = stats.getLevel();
            if (members.containsKey(data)) {
                effect.member = (FleetMemberAPI)members.get(data);
            }
            if (unusable.contains(data)) {
                effect.unusable = true;
            }
            if (stats.getLevel() > n && n < maxLevelPre) {
                ArrayList<String> skillsInOrderOfGain = new ArrayList<String>();
                for (OfficerSkillGainRecord rec : PlaythroughLog.getInstance().getOfficerSkillsLearned()) {
                    if (!rec.getPersonId().equals(person.getId()) || rec.isElite() || !(stats.getSkillLevel(rec.getSkillId()) > 0.0f)) continue;
                    skillsInOrderOfGain.add(rec.getSkillId());
                }
                Collections.reverse(skillsInOrderOfGain);
                int skillsToRemove = stats.getLevel() - n;
                int i = 0;
                while (i < skillsToRemove && !skillsInOrderOfGain.isEmpty()) {
                    effect.removeSkills.add((String)skillsInOrderOfGain.remove(0));
                    ++i;
                }
                if (!effect.removeSkills.isEmpty()) {
                    effect.newLevel = n;
                }
            }
            if ((numElite = this.getNumEliteSkills(person)) > maxElitePost && maxElitePost < maxElitePre) {
                ArrayList<String> eliteInOrderOfGain = new ArrayList<String>();
                for (OfficerSkillGainRecord rec : PlaythroughLog.getInstance().getOfficerSkillsLearned()) {
                    if (!rec.getPersonId().equals(person.getId()) || !rec.isElite() || !(stats.getSkillLevel(rec.getSkillId()) >= 2.0f) || effect.removeSkills.contains(rec.getSkillId())) continue;
                    eliteInOrderOfGain.add(rec.getSkillId());
                }
                Collections.reverse(eliteInOrderOfGain);
                int eliteToRemove = numElite - maxElitePost;
                int i = 0;
                while (i < eliteToRemove && !eliteInOrderOfGain.isEmpty()) {
                    effect.removeElite.add((String)eliteInOrderOfGain.remove(0));
                    ++i;
                }
            }
            if (!effect.hasChanges()) continue;
            result.map.put(person, effect);
        }
        return result;
    }

    @Override
    public boolean hasEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to) {
        return !this.getEffects((MutableCharacterStatsAPI)from, (MutableCharacterStatsAPI)to).map.isEmpty();
    }

    @Override
    public void printEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to, TooltipMakerAPI info, Map<String, Object> dataMap) {
        super.prepare();
        OfficerDataMap map = this.getEffects(from, to);
        this.setMap(map, dataMap);
        float bw = 470.0f;
        float bh = 25.0f;
        float pad = 3.0f;
        float opad = 10.0f;
        info.addSectionHeading("Officers", this.base, this.dark, Alignment.MID, 15.0f);
        info.addPara("Officers whose skills that exceed the new limits will have their excess skills removed, or become mercenaries on a temporary contract. Officers that already had those kinds of skills when acquired will not be affected.", opad, Misc.getNegativeHighlightColor(), "excess skills removed");
        float initPad = opad;
        for (final OfficerEffectData data : map.map.values()) {
            final PersonAPI person = data.data.getPerson();
            String str = String.valueOf(person.getRank()) + " " + person.getNameString();
            str = data.member == null ? String.valueOf(str) + ", unassigned, will..." : String.valueOf(str) + ", commanding the " + data.member.getShipName() + " (" + data.member.getHullSpec().getHullNameWithDashClass() + "), will...";
            String mercText = "Become a mercenary, drawing higher pay on a new contract";
            String otherText = "";
            if (data.unusable && data.removeElite.isEmpty() && data.removeSkills.isEmpty()) {
                otherText = data.member == null ? "Become unable to be assigned command of a ship" : "Be relieved of command, and unable to be assigned command of a ship";
            } else {
                String part1 = "";
                if (data.unusable) {
                    part1 = "Be relieved of command, and";
                }
                String part2 = "";
                part2 = !data.removeElite.isEmpty() && data.removeSkills.isEmpty() ? " lose excess elite skill effects" : (data.removeElite.isEmpty() && !data.removeSkills.isEmpty() ? " lose excess skills" : " lose excess skills and elite skill effects");
                if (part1.isEmpty()) {
                    part2 = part2.trim();
                    otherText = Misc.ucFirst(part2);
                } else {
                    otherText = String.valueOf(part1) + part2;
                }
            }
            info.addPara(str, opad + 5.0f);
            float indent = 40.0f;
            data.buttonOther = info.addAreaCheckbox(otherText, new Object(), this.base, this.dark, this.bright, bw, bh, opad, true);
            data.buttonOther.getPosition().setXAlignOffset(indent);
            info.addTooltipToPrevious(new TooltipMakerAPI.TooltipCreator(){

                public boolean isTooltipExpandable(Object tooltipParam) {
                    return false;
                }

                public float getTooltipWidth(Object tooltipParam) {
                    return 450.0f;
                }

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    PersonAPI fake;
                    float opad = 10.0f;
                    float pad = 3.0f;
                    tooltip.addPara("This officer has the following skills:", 0.0f);
                    tooltip.addSkillPanel(person, pad);
                    if (!data.removeSkills.isEmpty()) {
                        tooltip.addPara("They will lose the following skills:", opad);
                        fake = Global.getFactory().createPerson();
                        for (String skillId : data.removeSkills) {
                            fake.getStats().setSkillLevel(skillId, person.getStats().getSkillLevel(skillId));
                        }
                        tooltip.addSkillPanel(fake, pad);
                    }
                    if (!data.removeElite.isEmpty()) {
                        tooltip.addPara("They will lose the elite effects of the following skills:", opad);
                        fake = Global.getFactory().createPerson();
                        for (String skillId : data.removeElite) {
                            fake.getStats().setSkillLevel(skillId, person.getStats().getSkillLevel(skillId));
                        }
                        tooltip.addSkillPanel(fake, pad);
                    }
                }
            }, TooltipMakerAPI.TooltipLocation.RIGHT);
            data.buttonMerc = info.addAreaCheckbox(mercText, new Object(), this.sBase, this.sDark, this.sBright, bw, bh, pad, true);
            data.buttonOther.setChecked(true);
            data.buttonMerc.setChecked(false);
            info.addTooltipToPrevious(new TooltipMakerAPI.TooltipCreator(){

                public boolean isTooltipExpandable(Object tooltipParam) {
                    return false;
                }

                public float getTooltipWidth(Object tooltipParam) {
                    return 450.0f;
                }

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    int payPre = (int)Misc.getOfficerSalary(person, false);
                    int payPost = (int)Misc.getOfficerSalary(person, true);
                    int contractDur = (int)Global.getSettings().getFloat("officerMercContractDur");
                    tooltip.addPara("This officer's pay will be increased from %s to %s per month, and they will want to leave after %s days, when their contract expires.", 0.0f, Misc.getHighlightColor(), Misc.getDGSCredits(payPre), Misc.getDGSCredits(payPost), "" + contractDur);
                    tooltip.addPara("Extending the contract beyond that will require a %s.", 10.0f, Misc.getStoryOptionColor(), String.valueOf(Misc.STORY) + " point");
                }
            }, TooltipMakerAPI.TooltipLocation.RIGHT);
            info.addSpacer(0.0f).getPosition().setXAlignOffset(-indent);
        }
    }

    @Override
    public void infoButtonPressed(ButtonAPI button, Object param, Map<String, Object> dataMap) {
        OfficerDataMap map = this.getMap(dataMap);
        for (OfficerEffectData data : map.map.values()) {
            if (data.buttonMerc == button) {
                data.makeMercenary = true;
                data.buttonMerc.setChecked(true);
                data.buttonOther.setChecked(false);
                continue;
            }
            if (data.buttonOther != button) continue;
            data.makeMercenary = false;
            data.buttonMerc.setChecked(false);
            data.buttonOther.setChecked(true);
        }
    }

    @Override
    public void applyEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to, Map<String, Object> dataMap) {
        OfficerDataMap map = this.getMap(dataMap);
        for (OfficerEffectData data : map.map.values()) {
            if (data.makeMercenary) {
                Misc.setMercenary(data.data.getPerson(), true);
                Misc.setMercHiredNow(data.data.getPerson());
                continue;
            }
            if (data.unusable && data.member != null) {
                data.member.setCaptain(Global.getFactory().createPerson());
            }
            MutableCharacterStatsAPI stats = data.data.getPerson().getStats();
            for (String id : data.removeElite) {
                stats.setSkillLevel(id, 1.0f);
                PlaythroughLog.getInstance().removeOfficerSkillRecord(data.data.getPerson().getId(), id, true);
            }
            for (String id : data.removeSkills) {
                stats.setSkillLevel(id, 0.0f);
                PlaythroughLog.getInstance().removeOfficerSkillRecord(data.data.getPerson().getId(), id, false);
                PlaythroughLog.getInstance().removeOfficerSkillRecord(data.data.getPerson().getId(), id, true);
            }
            if (data.newLevel == stats.getLevel()) continue;
            stats.setLevel(data.newLevel);
        }
    }

    public static class OfficerDataMap {
        Map<PersonAPI, OfficerEffectData> map = new LinkedHashMap<PersonAPI, OfficerEffectData>();
    }

    public static class OfficerEffectData {
        OfficerDataAPI data;
        int newLevel;
        List<String> removeSkills = new ArrayList<String>();
        List<String> removeElite = new ArrayList<String>();
        FleetMemberAPI member;
        boolean unusable = false;
        boolean makeMercenary;
        ButtonAPI buttonMerc;
        ButtonAPI buttonOther;

        public boolean hasChanges() {
            return this.data.getPerson().getStats().getLevel() != this.newLevel || this.unusable || !this.removeSkills.isEmpty() || !this.removeElite.isEmpty() || this.makeMercenary;
        }
    }
}

