/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.combat;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.HullModEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class BaseHullMod
implements HullModEffect {
    protected HullModSpecAPI spec;

    public void init(HullModSpecAPI spec) {
        this.spec = spec;
    }

    public boolean isSMod(MutableShipStatsAPI stats) {
        if (stats == null || stats.getVariant() == null || this.spec == null) {
            return false;
        }
        return stats.getVariant().getSMods().contains(this.spec.getId()) || stats.getVariant().getSModdedBuiltIns().contains(this.spec.getId());
    }

    public boolean isSMod(ShipAPI ship) {
        if (ship == null || ship.getVariant() == null || this.spec == null) {
            return false;
        }
        return ship.getVariant().getSMods().contains(this.spec.getId()) || ship.getVariant().getSModdedBuiltIns().contains(this.spec.getId());
    }

    public boolean isBuiltIn(ShipAPI ship) {
        if (ship == null || ship.getVariant() == null || this.spec == null) {
            return false;
        }
        return ship.getHullSpec().getBuiltInMods().contains(this.spec.getId());
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        return this.getDescriptionParam(index, hullSize);
    }

    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        return this.getSModDescriptionParam(index, hullSize);
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return true;
    }

    public void advanceInCampaign(FleetMemberAPI member, float amount) {
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
    }

    public String getUnapplicableReason(ShipAPI ship) {
        return null;
    }

    public boolean affectsOPCosts() {
        return false;
    }

    public boolean canBeAddedOrRemovedNow(ShipAPI ship, MarketAPI marketOrNull, CampaignUIAPI.CoreUITradeMode mode) {
        if (this.spec == null) {
            return true;
        }
        boolean reqSpaceport = this.spec.hasTag("req_spaceport");
        if (!reqSpaceport) {
            return true;
        }
        if (marketOrNull == null) {
            return false;
        }
        if (mode == CampaignUIAPI.CoreUITradeMode.NONE || mode == null) {
            return false;
        }
        for (Industry ind : marketOrNull.getIndustries()) {
            if (ind.getSpec().hasTag("station")) {
                return true;
            }
            if (!ind.getSpec().hasTag("spaceport")) continue;
            return true;
        }
        return false;
    }

    public String getCanNotBeInstalledNowReason(ShipAPI ship, MarketAPI marketOrNull, CampaignUIAPI.CoreUITradeMode mode) {
        if (this.spec == null) {
            return null;
        }
        boolean reqSpaceport = this.spec.hasTag("req_spaceport");
        if (!reqSpaceport) {
            return null;
        }
        boolean has = ship.getVariant().hasHullMod(this.spec.getId());
        String verb = "installed";
        if (has) {
            verb = "removed";
        }
        return "Can only be " + verb + " at a colony with a spaceport or an orbital station";
    }

    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return true;
    }

    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
    }

    public boolean hasSModEffectSection(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        if (!this.hasSModEffect()) {
            return false;
        }
        GameState state = Global.getCurrentState();
        if (state == GameState.TITLE && !Global.getSettings().isDevMode()) {
            return false;
        }
        if (Misc.CAN_SMOD_BUILT_IN) {
            return !this.isBuiltIn(ship) || !this.isSModEffectAPenalty();
        }
        return !this.isBuiltIn(ship);
    }

    public boolean isSModEffectAPenalty() {
        return false;
    }

    public boolean hasSModEffect() {
        return this.spec != null && this.spec.getSModEffectFormat() != null && !this.spec.getSModEffectFormat().trim().isEmpty() && !this.spec.getSModEffectFormat().startsWith("#");
    }

    public void addSModEffectSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec, boolean isForBuildInList) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        String[] params = new String[]{this.getSModDescriptionParam(0, hullSize, null), this.getSModDescriptionParam(1, hullSize, null), this.getSModDescriptionParam(2, hullSize, null), this.getSModDescriptionParam(3, hullSize, null), this.getSModDescriptionParam(4, hullSize, null), this.getSModDescriptionParam(5, hullSize, null), this.getSModDescriptionParam(6, hullSize, null), this.getSModDescriptionParam(7, hullSize, null), this.getSModDescriptionParam(8, hullSize, null), this.getSModDescriptionParam(9, hullSize, null)};
        tooltip.addPara(this.spec.getSModDescription(hullSize).replaceAll("\\%", "%%"), opad, h, params);
    }

    public void addSModSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec, boolean isForBuildInList) {
        float opad = 10.0f;
        boolean sMod = this.isSMod(ship);
        Color s = Misc.getStoryOptionColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color darkBad = Misc.setAlpha(Misc.scaleColorOnly(bad, 0.4f), 175);
        if (!sMod || this.hasSModEffect()) {
            if (!this.isSModEffectAPenalty()) {
                if (isForBuildInList) {
                    tooltip.addSectionHeading(String.valueOf(this.spec.getDisplayName()) + " bonus", Misc.getStoryOptionColor(), Misc.getStoryDarkColor(), Alignment.MID, opad);
                } else {
                    tooltip.addSectionHeading("S-mod bonus", Misc.getStoryOptionColor(), Misc.getStoryDarkColor(), Alignment.MID, opad);
                }
            } else if (isForBuildInList) {
                tooltip.addSectionHeading(String.valueOf(this.spec.getDisplayName()) + " penalty", bad, darkBad, Alignment.MID, opad);
            } else {
                tooltip.addSectionHeading("S-mod penalty", bad, darkBad, Alignment.MID, opad);
            }
        }
        if (this.hasSModEffect()) {
            if (isForBuildInList) {
                tooltip.addSpacer(-5.0f);
            }
            this.addSModEffectSection(tooltip, hullSize, ship, width, isForModSpec, false);
            if (!sMod && !isForBuildInList) {
                boolean builtIn = this.isBuiltIn(ship);
                if (builtIn) {
                    tooltip.addPara("This effect only applies if this built-in hullmod is enhanced using a %s. Doing this does not count against the maximum number of s-mods a ship can have.", opad, s, "story point");
                } else {
                    tooltip.addPara("This effect only applies if this hullmod is built into the hull using a story point. Cheap hullmods have stronger effects.", opad, s, "story point");
                }
            }
        } else if (!sMod) {
            tooltip.addPara("Aside from removing its ordnance point cost, this hullmod gains no extra effect from being built into the hull using a story point.", opad, s, "story point");
        }
        if ((!sMod || this.hasSModEffect()) && isForModSpec) {
            tooltip.addSpacer(opad);
        }
    }

    public void applyEffectsToFighterSpawnedByShip(ShipAPI fighter, ShipAPI ship, String id) {
    }

    public boolean shipHasOtherModInCategory(ShipAPI ship, String currMod, String category) {
        for (String id : ship.getVariant().getHullMods()) {
            HullModSpecAPI mod = Global.getSettings().getHullModSpec(id);
            if (!mod.hasTag(category) || id.equals(currMod)) continue;
            return true;
        }
        return false;
    }

    public boolean isInPlayerFleet(MutableShipStatsAPI stats) {
        if (stats == null) {
            return false;
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        PersonAPI fc = member.getFleetCommanderForStats();
        if (fc == null) {
            fc = member.getFleetCommander();
        }
        if (fc == null) {
            return false;
        }
        return fc.isPlayer();
    }

    public boolean isInPlayerFleet(ShipAPI ship) {
        if (ship == null) {
            return false;
        }
        FleetMemberAPI member = ship.getFleetMember();
        if (member == null) {
            return false;
        }
        PersonAPI fc = member.getFleetCommanderForStats();
        if (fc == null) {
            fc = member.getFleetCommander();
        }
        if (fc == null) {
            return false;
        }
        return fc.isPlayer();
    }

    public Color getBorderColor() {
        return null;
    }

    public Color getNameColor() {
        return null;
    }

    public int getDisplaySortOrder() {
        return 100;
    }

    public int getDisplayCategoryIndex() {
        return -1;
    }

    public float getTooltipWidth() {
        return 369.0f;
    }

    public boolean showInRefitScreenModPickerFor(ShipAPI ship) {
        return true;
    }
}

