/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.combat;

import com.fs.starfarer.api.combat.MutableStat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableStatWithTempMods
extends MutableStat {
    private LinkedHashMap<String, TemporaryStatMod> tempMods = new LinkedHashMap();

    public MutableStatWithTempMods(float base) {
        super(base);
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        return this;
    }

    @Override
    protected Object writeReplace() {
        if (this.tempMods != null && this.getMods().isEmpty()) {
            this.tempMods = null;
        }
        return this;
    }

    public void removeTemporaryMod(String source) {
        TemporaryStatMod mod = this.getMods().remove(source);
        if (mod == null) {
            return;
        }
        this.unmodify(mod.source);
    }

    private TemporaryStatMod getMod(String source, float durInDays) {
        TemporaryStatMod mod = this.getMods().get(source);
        if (mod == null) {
            mod = new TemporaryStatMod(durInDays, source);
            this.getMods().put(source, mod);
        }
        mod.timeRemaining = durInDays;
        return mod;
    }

    public void addTemporaryModFlat(float durInDays, String source, String desc, float value) {
        this.getMod(source, durInDays);
        this.modifyFlat(source, value, desc);
    }

    public void addTemporaryModMult(float durInDays, String source, String desc, float value) {
        this.getMod(source, durInDays);
        this.modifyMult(source, value, desc);
    }

    public void addTemporaryModFlat(float durInDays, String source, float value) {
        this.getMod(source, durInDays);
        this.modifyFlat(source, value);
    }

    public void addTemporaryModPercent(float durInDays, String source, String desc, float value) {
        this.getMod(source, durInDays);
        this.modifyPercent(source, value, desc);
    }

    public void addTemporaryModPercent(float durInDays, String source, float value) {
        this.getMod(source, durInDays);
        this.modifyPercent(source, value);
    }

    public Map<String, TemporaryStatMod> getMods() {
        if (this.tempMods == null) {
            this.tempMods = new LinkedHashMap();
        }
        return this.tempMods;
    }

    public boolean hasMod(String source) {
        return this.getMods().containsKey(source);
    }

    public void advance(float days) {
        if (this.tempMods == null || this.getMods().isEmpty()) {
            return;
        }
        Iterator<TemporaryStatMod> iter = this.getMods().values().iterator();
        while (iter.hasNext()) {
            TemporaryStatMod mod = iter.next();
            mod.timeRemaining -= days;
            if (!(mod.timeRemaining <= 0.0f)) continue;
            iter.remove();
            this.unmodify(mod.source);
        }
    }

    public static class TemporaryStatMod {
        float timeRemaining;
        String source;

        public TemporaryStatMod(float timeRemaining, String source) {
            this.timeRemaining = timeRemaining;
            this.source = source;
        }
    }
}

