/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.combat;

import com.fs.starfarer.api.combat.MutableStat;
import java.util.HashMap;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatBonus {
    public float flatBonus = 0.0f;
    public float mult = 1.0f;
    public float percentMod = 0.0f;
    private LinkedHashMap<String, MutableStat.StatMod> flatBonuses;
    private LinkedHashMap<String, MutableStat.StatMod> percentBonuses;
    private LinkedHashMap<String, MutableStat.StatMod> multBonuses;
    private boolean needsRecompute = false;

    public boolean equals(Object obj) {
        MutableStat.StatMod otherMod;
        MutableStat.StatMod mod;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatBonus other = (StatBonus)obj;
        if (Float.floatToIntBits(this.flatBonus) != Float.floatToIntBits(other.flatBonus)) {
            return false;
        }
        if (this.needsRecompute != other.needsRecompute) {
            return false;
        }
        if (Float.floatToIntBits(this.percentMod) != Float.floatToIntBits(other.percentMod)) {
            return false;
        }
        if (Float.floatToIntBits(this.mult) != Float.floatToIntBits(other.mult)) {
            return false;
        }
        if (this.flatBonuses == null) {
            if (other.flatBonuses != null) {
                return false;
            }
        } else {
            if (this.flatBonuses.size() != other.flatBonuses.size()) {
                return false;
            }
            for (String key : this.flatBonuses.keySet()) {
                if (!other.flatBonuses.containsKey(key)) {
                    return false;
                }
                mod = this.flatBonuses.get(key);
                otherMod = other.flatBonuses.get(key);
                if (!mod.source.equals(otherMod.source)) {
                    return false;
                }
                if (Float.floatToIntBits(mod.value) == Float.floatToIntBits(otherMod.value)) continue;
                return false;
            }
        }
        if (this.multBonuses == null) {
            if (other.multBonuses != null) {
                return false;
            }
        } else if (!this.multBonuses.equals(other.multBonuses)) {
            if (this.multBonuses.size() != other.multBonuses.size()) {
                return false;
            }
            for (String key : this.multBonuses.keySet()) {
                if (!other.multBonuses.containsKey(key)) {
                    return false;
                }
                mod = this.multBonuses.get(key);
                otherMod = other.multBonuses.get(key);
                if (!mod.source.equals(otherMod.source)) {
                    return false;
                }
                if (Float.floatToIntBits(mod.value) == Float.floatToIntBits(otherMod.value)) continue;
                return false;
            }
        }
        if (this.percentBonuses == null) {
            if (other.percentBonuses != null) {
                return false;
            }
        } else if (!this.percentBonuses.equals(other.percentBonuses)) {
            if (this.percentBonuses.size() != other.percentBonuses.size()) {
                return false;
            }
            for (String key : this.percentBonuses.keySet()) {
                if (!other.percentBonuses.containsKey(key)) {
                    return false;
                }
                mod = this.percentBonuses.get(key);
                otherMod = other.percentBonuses.get(key);
                if (!mod.source.equals(otherMod.source)) {
                    return false;
                }
                if (Float.floatToIntBits(mod.value) == Float.floatToIntBits(otherMod.value)) continue;
                return false;
            }
        }
        return true;
    }

    public StatBonus createCopy() {
        StatBonus copy = new StatBonus();
        copy.applyMods(this);
        return copy;
    }

    Object readResolve() {
        if (this.flatBonuses == null) {
            this.flatBonuses = new LinkedHashMap();
        }
        if (this.percentBonuses == null) {
            this.percentBonuses = new LinkedHashMap();
        }
        if (this.multBonuses == null) {
            this.multBonuses = new LinkedHashMap();
        }
        return this;
    }

    public boolean isUnmodified() {
        return !(this.flatBonuses != null && !this.getFlatBonuses().isEmpty() || this.multBonuses != null && !this.getMultBonuses().isEmpty() || this.percentBonuses != null && !this.getPercentBonuses().isEmpty());
    }

    public MutableStat.StatMod getFlatBonus(String source) {
        return this.getFlatBonuses().get(source);
    }

    public MutableStat.StatMod getPercentBonus(String source) {
        return this.getPercentBonuses().get(source);
    }

    public MutableStat.StatMod getMultBonus(String source) {
        return this.getMultBonuses().get(source);
    }

    public void modifyFlat(String source, float value) {
        this.modifyFlat(source, value, null);
    }

    public void modifyFlat(String source, float value, String desc) {
        MutableStat.StatMod mod = this.getFlatBonuses().get(source);
        if (mod == null && value == 0.0f) {
            return;
        }
        if (mod != null && mod.value == value) {
            return;
        }
        mod = new MutableStat.StatMod(source, MutableStat.StatModType.FLAT, value, desc);
        this.getFlatBonuses().put(source, mod);
        this.needsRecompute = true;
    }

    public void modifyPercent(String source, float value) {
        this.modifyPercent(source, value, null);
    }

    public void modifyPercent(String source, float value, String desc) {
        MutableStat.StatMod mod = this.getPercentBonuses().get(source);
        if (mod == null && value == 0.0f) {
            return;
        }
        if (mod != null && mod.value == value) {
            return;
        }
        mod = new MutableStat.StatMod(source, MutableStat.StatModType.PERCENT, value, desc);
        this.getPercentBonuses().put(source, mod);
        this.needsRecompute = true;
    }

    public void modifyPercentAlways(String source, float value, String desc) {
        MutableStat.StatMod mod = new MutableStat.StatMod(source, MutableStat.StatModType.PERCENT, value, desc);
        this.getPercentBonuses().put(source, mod);
        this.needsRecompute = true;
    }

    public void modifyMult(String source, float value) {
        this.modifyMult(source, value, null);
    }

    public void modifyMult(String source, float value, String desc) {
        MutableStat.StatMod mod = this.getMultBonuses().get(source);
        if (mod == null && value == 1.0f) {
            return;
        }
        if (mod != null && mod.value == value) {
            return;
        }
        mod = new MutableStat.StatMod(source, MutableStat.StatModType.MULT, value, desc);
        this.getMultBonuses().put(source, mod);
        this.needsRecompute = true;
    }

    public void modifyMultAlways(String source, float value, String desc) {
        MutableStat.StatMod mod = new MutableStat.StatMod(source, MutableStat.StatModType.MULT, value, desc);
        this.getMultBonuses().put(source, mod);
        this.needsRecompute = true;
    }

    public void modifyFlatAlways(String source, float value, String desc) {
        MutableStat.StatMod mod = new MutableStat.StatMod(source, MutableStat.StatModType.FLAT, value, desc);
        this.getFlatBonuses().put(source, mod);
        this.needsRecompute = true;
    }

    public void unmodify() {
        if (this.flatBonuses != null) {
            this.flatBonuses.clear();
        }
        if (this.percentBonuses != null) {
            this.percentBonuses.clear();
        }
        if (this.multBonuses != null) {
            this.multBonuses.clear();
        }
        this.needsRecompute = true;
    }

    public void unmodify(String source) {
        MutableStat.StatMod mod;
        if (this.flatBonuses != null && (mod = (MutableStat.StatMod)this.flatBonuses.remove(source)) != null && mod.value != 0.0f) {
            this.needsRecompute = true;
        }
        if (this.percentBonuses != null && (mod = (MutableStat.StatMod)this.percentBonuses.remove(source)) != null && mod.value != 0.0f) {
            this.needsRecompute = true;
        }
        if (this.multBonuses != null && (mod = (MutableStat.StatMod)this.multBonuses.remove(source)) != null && mod.value != 1.0f) {
            this.needsRecompute = true;
        }
    }

    public void unmodifyFlat(String source) {
        if (this.flatBonuses == null) {
            return;
        }
        MutableStat.StatMod mod = (MutableStat.StatMod)this.flatBonuses.remove(source);
        if (mod != null && mod.value != 0.0f) {
            this.needsRecompute = true;
        }
    }

    public void unmodifyPercent(String source) {
        if (this.percentBonuses == null) {
            return;
        }
        MutableStat.StatMod mod = (MutableStat.StatMod)this.percentBonuses.remove(source);
        if (mod != null && mod.value != 0.0f) {
            this.needsRecompute = true;
        }
    }

    public void unmodifyMult(String source) {
        if (this.multBonuses == null) {
            return;
        }
        MutableStat.StatMod mod = (MutableStat.StatMod)this.multBonuses.remove(source);
        if (mod != null && mod.value != 1.0f) {
            this.needsRecompute = true;
        }
    }

    private void recompute() {
        float flatMod = 0.0f;
        float multBonus = 1.0f;
        this.percentMod = 0.0f;
        if (this.percentBonuses != null) {
            for (MutableStat.StatMod mod : this.percentBonuses.values()) {
                this.percentMod += mod.value;
            }
        }
        if (this.flatBonuses != null) {
            for (MutableStat.StatMod mod : this.flatBonuses.values()) {
                flatMod += mod.value;
            }
        }
        if (this.multBonuses != null) {
            for (MutableStat.StatMod mod : this.multBonuses.values()) {
                multBonus *= mod.value;
            }
        }
        this.mult = multBonus;
        this.flatBonus = flatMod;
        this.needsRecompute = false;
    }

    public float computeEffective(float baseValue) {
        if (this.needsRecompute) {
            this.recompute();
        }
        return (baseValue + baseValue * this.percentMod / 100.0f + this.flatBonus) * this.mult;
    }

    public float getFlatBonus() {
        if (this.needsRecompute) {
            this.recompute();
        }
        return this.flatBonus;
    }

    public float getBonusMult() {
        if (this.needsRecompute) {
            this.recompute();
        }
        return this.mult * (1.0f + this.percentMod / 100.0f);
    }

    public float getMult() {
        if (this.needsRecompute) {
            this.recompute();
        }
        return this.mult;
    }

    public float getPercentMod() {
        if (this.needsRecompute) {
            this.recompute();
        }
        return this.percentMod;
    }

    public boolean isPositive(float baseValue) {
        return this.computeEffective(baseValue) > baseValue;
    }

    public boolean isNegative(float baseValue) {
        return this.computeEffective(baseValue) < baseValue;
    }

    public HashMap<String, MutableStat.StatMod> getFlatBonuses() {
        if (this.flatBonuses == null) {
            this.flatBonuses = new LinkedHashMap();
        }
        return this.flatBonuses;
    }

    public HashMap<String, MutableStat.StatMod> getPercentBonuses() {
        if (this.percentBonuses == null) {
            this.percentBonuses = new LinkedHashMap();
        }
        return this.percentBonuses;
    }

    public HashMap<String, MutableStat.StatMod> getMultBonuses() {
        if (this.multBonuses == null) {
            this.multBonuses = new LinkedHashMap();
        }
        return this.multBonuses;
    }

    public void applyMods(MutableStat other) {
        this.getFlatBonuses().putAll(other.getFlatMods());
        this.getPercentBonuses().putAll(other.getPercentMods());
        this.getMultBonuses().putAll(other.getMultMods());
        this.needsRecompute = true;
    }

    public void applyMods(StatBonus other) {
        this.getFlatBonuses().putAll(other.getFlatBonuses());
        this.getPercentBonuses().putAll(other.getPercentBonuses());
        this.getMultBonuses().putAll(other.getMultBonuses());
        this.needsRecompute = true;
    }
}

