/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.MusicPlayerPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.HashMap;
import java.util.Map;

public class MusicPlayerPluginImpl
implements MusicPlayerPlugin {
    public static String KEEP_PLAYING_LOCATION_MUSIC_DURING_ENCOUNTER_MEM_KEY = "$playLocationMusicDuringEnc";
    public static String MUSIC_SET_MEM_KEY = "$musicSetId";
    public static Object CAMPAIGN_SYSTEM = new Object();
    public static Object CAMPAIGN_HYPERSPACE = new Object();
    public static Object COMBAT = new Object();
    public static Object TITLE = new Object();
    public static Object MARKET = new Object();
    public static Object ENCOUNTER = new Object();
    public static Object PLANET_SURVEY = new Object();
    public static Object CUSTOM = new Object();
    public static Map<String, String> stringTokens = new HashMap<String, String>();
    public static String SYSTEM_MUSIC_PREFIX = "core_sys_music_";

    public static Object getToken(String str) {
        if (!stringTokens.containsKey(str)) {
            stringTokens.put(str, str);
        }
        return stringTokens.get(str);
    }

    public Object getStateTokenForCampaignLocation() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (playerFleet.getContainingLocation() instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)playerFleet.getContainingLocation();
            String musicSetId = system.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY);
            if (musicSetId != null) {
                return MusicPlayerPluginImpl.getToken(String.valueOf(SYSTEM_MUSIC_PREFIX) + musicSetId);
            }
            return CAMPAIGN_SYSTEM;
        }
        return CAMPAIGN_HYPERSPACE;
    }

    public String getMusicSetIdForCombat(CombatEngineAPI engine) {
        return "music_combat";
    }

    public String getMusicSetIdForTitle() {
        return "music_title";
    }

    public String getMusicSetIdForCampaignStateToken(Object token, Object param) {
        if (token == MARKET) {
            return this.getMarketMusicSetId(param);
        }
        if (token == ENCOUNTER) {
            return this.getEncounterMusicSetId(param);
        }
        if (token == CAMPAIGN_SYSTEM || token instanceof String && ((String)token).startsWith(SYSTEM_MUSIC_PREFIX)) {
            return this.getStarSystemMusicSetId();
        }
        if (token == CAMPAIGN_HYPERSPACE) {
            return this.getHyperspaceMusicSetId();
        }
        if (token == PLANET_SURVEY) {
            return this.getPlanetSurveyMusicSetId(param);
        }
        return null;
    }

    protected String getPlanetSurveyMusicSetId(Object param) {
        return "music_survey_and_scavenge";
    }

    protected String getHyperspaceMusicSetId() {
        return "music_campaign_hyperspace";
    }

    protected String getStarSystemMusicSetId() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (playerFleet.getContainingLocation() instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)playerFleet.getContainingLocation();
            String musicSetId = system.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY);
            if (musicSetId != null) {
                return musicSetId;
            }
            if (system.hasTag("theme_core") || !Misc.getMarketsInLocation(system, "player").isEmpty()) {
                return "music_campaign";
            }
        }
        return "music_campaign_non_core";
    }

    protected String getEncounterMusicSetId(Object param) {
        if (param instanceof SectorEntityToken) {
            SectorEntityToken token = (SectorEntityToken)param;
            String musicSetId = token.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY);
            if (musicSetId != null) {
                return musicSetId;
            }
            if ("debris_field_shared".equals(token.getCustomEntityType())) {
                return "music_survey_and_scavenge";
            }
            if (token.hasTag("salvageable")) {
                return "music_survey_and_scavenge";
            }
            if (token.hasTag("salvage_music")) {
                return "music_survey_and_scavenge";
            }
            if (token.getFaction() != null) {
                FactionAPI faction = token.getFaction();
                String type = null;
                boolean hostile = false;
                boolean knowsWhoPlayerIs = false;
                if (token instanceof CampaignFleetAPI) {
                    CampaignFleetAPI fleet = (CampaignFleetAPI)token;
                    if (fleet.getAI() instanceof ModularFleetAIAPI) {
                        hostile = ((ModularFleetAIAPI)fleet.getAI()).isHostileTo(Global.getSector().getPlayerFleet());
                    }
                    knowsWhoPlayerIs = fleet.knowsWhoPlayerIs();
                }
                if ((type = faction.isAtWorst("player", RepLevel.FAVORABLE) && knowsWhoPlayerIs && !hostile ? "encounter_friendly" : (faction.isAtBest("player", RepLevel.SUSPICIOUS) && knowsWhoPlayerIs || hostile ? "encounter_hostile" : "encounter_neutral")) != null && (musicSetId = faction.getMusicMap().get(type)) != null) {
                    return musicSetId;
                }
                musicSetId = null;
                musicSetId = faction.isAtWorst("player", RepLevel.FAVORABLE) ? "music_default_encounter_friendly" : (faction.isAtBest("player", RepLevel.SUSPICIOUS) ? "music_default_encounter_hostile" : "music_default_encounter_neutral");
                return musicSetId;
            }
        }
        return null;
    }

    protected String getMarketMusicSetId(Object param) {
        if (param instanceof MarketAPI) {
            MarketAPI market = (MarketAPI)param;
            String musicSetId = market.getMemoryWithoutUpdate().getString(MUSIC_SET_MEM_KEY);
            if (musicSetId != null) {
                return musicSetId;
            }
            if (market.getPrimaryEntity() != null && market.getPrimaryEntity().getMemoryWithoutUpdate().getBoolean("$abandonedStation")) {
                return this.getPlanetSurveyMusicSetId(param);
            }
            FactionAPI faction = market.getFaction();
            if (faction != null) {
                String type = null;
                type = faction.isAtWorst("player", RepLevel.FAVORABLE) ? "market_friendly" : (faction.isAtBest("player", RepLevel.SUSPICIOUS) ? "market_hostile" : "market_neutral");
                if (type != null && (musicSetId = faction.getMusicMap().get(type)) != null) {
                    return musicSetId;
                }
                musicSetId = null;
                musicSetId = faction.isAtWorst("player", RepLevel.FAVORABLE) ? "music_default_market_friendly" : (faction.isAtBest("player", RepLevel.SUSPICIOUS) ? "music_default_market_hostile" : "music_default_market_neutral");
                return musicSetId;
            }
        }
        return null;
    }
}

