/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.GenericPluginManagerAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.listeners.CargoScreenListener;
import com.fs.starfarer.api.campaign.listeners.ColonyInteractionListener;
import com.fs.starfarer.api.campaign.listeners.CommodityIconProvider;
import com.fs.starfarer.api.campaign.listeners.CommodityTooltipModifier;
import com.fs.starfarer.api.campaign.listeners.GroundRaidObjectivesListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.CargoPodsEntityPlugin;
import com.fs.starfarer.api.impl.campaign.graid.GroundRaidObjectivePlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerFleetPersonnelTracker
implements ColonyInteractionListener,
GroundRaidObjectivesListener,
CommodityTooltipModifier,
CommodityIconProvider,
CargoScreenListener {
    public static float XP_PER_RAID_MULT = 0.2f;
    public static float MAX_EFFECTIVENESS_PERCENT = 100.0f;
    public static float MAX_LOSS_REDUCTION_PERCENT = 50.0f;
    public static boolean KEEP_XP_DURING_TRANSFERS = true;
    public static final String KEY = "$core_personnelTracker";
    protected PersonnelData marineData = new PersonnelData("marines");
    protected List<PersonnelAtEntity> droppedOff = new ArrayList<PersonnelAtEntity>();
    protected transient SectorEntityToken pods = null;
    protected transient SubmarketAPI currSubmarket = null;
    protected transient PersonnelData savedMarineData;
    protected transient List<PersonnelAtEntity> savedPersonnelData = new ArrayList<PersonnelAtEntity>();

    public static PlayerFleetPersonnelTracker getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        if (test == null) {
            test = new PlayerFleetPersonnelTracker();
            Global.getSector().getMemoryWithoutUpdate().set(KEY, test);
        }
        return (PlayerFleetPersonnelTracker)test;
    }

    public PlayerFleetPersonnelTracker() {
        GenericPluginManagerAPI plugins = Global.getSector().getGenericPlugins();
        plugins.addPlugin(this, false);
        Global.getSector().getListenerManager().addListener(this);
        this.update();
    }

    @Override
    public void reportCargoScreenOpened() {
        this.doCleanup(true);
        this.update();
        this.currSubmarket = null;
    }

    @Override
    public void reportSubmarketOpened(SubmarketAPI submarket) {
        this.doCleanup(false);
        this.currSubmarket = submarket;
    }

    @Override
    public void reportPlayerLeftCargoPods(SectorEntityToken entity) {
        this.pods = entity;
    }

    @Override
    public void reportPlayerNonMarketTransaction(PlayerMarketTransaction transaction, InteractionDialogAPI dialog) {
        SectorEntityToken target;
        if (this.pods == null && dialog != null && (target = dialog.getInteractionTarget()) != null && target.getCustomPlugin() instanceof CargoPodsEntityPlugin) {
            this.pods = target;
        }
        this.processTransaction(transaction, this.pods);
    }

    @Override
    public void reportPlayerMarketTransaction(PlayerMarketTransaction transaction) {
        if (transaction.getMarket() == null || transaction.getMarket().getPrimaryEntity() == null || transaction.getSubmarket() == null) {
            return;
        }
        if (!transaction.getSubmarket().getSpecId().equals("storage")) {
            this.doCleanup(true);
            this.update(false, true, null);
            return;
        }
        this.processTransaction(transaction, transaction.getMarket().getPrimaryEntity());
    }

    public void processTransaction(PlayerMarketTransaction transaction, SectorEntityToken entity) {
        int num;
        PersonnelAtEntity at;
        if (entity == null) {
            return;
        }
        SubmarketAPI sub = transaction.getSubmarket();
        for (CargoStackAPI stack : transaction.getSold().getStacksCopy()) {
            if (!stack.isPersonnelStack() || !stack.isMarineStack()) continue;
            at = this.getDroppedOffAt(stack.getCommodityId(), entity, sub, true);
            num = (int)stack.getSize();
            PlayerFleetPersonnelTracker.transferPersonnel(this.marineData, at.data, num, this.marineData);
        }
        for (CargoStackAPI stack : transaction.getBought().getStacksCopy()) {
            if (!stack.isPersonnelStack() || !stack.isMarineStack()) continue;
            at = this.getDroppedOffAt(stack.getCommodityId(), entity, sub, true);
            num = (int)stack.getSize();
            PlayerFleetPersonnelTracker.transferPersonnel(at.data, this.marineData, num, this.marineData);
        }
        this.doCleanup(true);
        this.update();
    }

    public static void transferPersonnel(PersonnelData from, PersonnelData to, int num, PersonnelData keepsXP) {
        if ((float)num > from.num) {
            num = (int)from.num;
        }
        if (num <= 0) {
            return;
        }
        if (KEEP_XP_DURING_TRANSFERS && keepsXP != null) {
            to.add(num);
            from.remove(num, false);
            float totalXP = to.xp + from.xp;
            if (keepsXP == from) {
                from.xp = Math.min(totalXP, from.num);
                to.xp = Math.max(0.0f, totalXP - from.num);
            } else if (keepsXP == to) {
                to.xp = Math.min(totalXP, to.num);
                from.xp = Math.max(0.0f, totalXP - to.num);
            }
        } else {
            float xp = from.xp * (float)num / from.num;
            to.add(num);
            to.addXP(xp);
            from.remove(num, true);
        }
    }

    @Override
    public void reportRaidObjectivesAchieved(GroundRaidObjectivesListener.RaidResultData data, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = fleet.getCargo();
        float marines = cargo.getMarines();
        this.marineData.remove(data.marinesLost, true);
        float total = marines + (float)data.marinesLost;
        float xpGain = 1.0f - data.raidEffectiveness;
        xpGain *= total;
        xpGain *= XP_PER_RAID_MULT;
        if (xpGain < 0.0f) {
            xpGain = 0.0f;
        }
        this.marineData.addXP(xpGain);
        this.update();
    }

    public void update() {
        this.update(false, false, null);
    }

    public void update(boolean withIntegrationFromCurrentLocation, boolean keepXP, CargoStackAPI stack) {
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        if (fleet == null) {
            return;
        }
        CargoAPI cargo = fleet.getCargo();
        float marines = cargo.getMarines();
        this.marineData.numMayHaveChanged(marines, keepXP);
        if (withIntegrationFromCurrentLocation) {
            PersonnelAtEntity atLocation = this.getPersonnelAtLocation("marines", this.currSubmarket);
            this.marineData.integrateWithCurrentLocation(atLocation);
        }
        MutableFleetStatsAPI stats = fleet.getStats();
        String id = "marineXP";
        PersonnelRank rank = this.marineData.getRank();
        float effectBonus = this.getMarineEffectBonus(this.marineData);
        float casualtyReduction = this.getMarineLossesReductionPercent(this.marineData);
        if (effectBonus > 0.0f) {
            stats.getDynamic().getMod("ground_attack_mod").modifyPercent(id, effectBonus, String.valueOf(rank.name) + " marines");
        } else {
            stats.getDynamic().getMod("ground_attack_mod").unmodifyPercent(id);
        }
        if (casualtyReduction > 0.0f) {
            stats.getDynamic().getStat("ground_attack_casualties_mult").modifyMult(id, 1.0f - casualtyReduction * 0.01f, String.valueOf(rank.name) + " marines");
        } else {
            stats.getDynamic().getStat("ground_attack_casualties_mult").unmodifyMult(id);
        }
    }

    public float getMarineEffectBonus(PersonnelData data) {
        float f = data.getXPLevel();
        return Math.round(f * MAX_EFFECTIVENESS_PERCENT);
    }

    public float getMarineLossesReductionPercent(PersonnelData data) {
        float f = data.getXPLevel();
        return Math.round(f * MAX_LOSS_REDUCTION_PERCENT);
    }

    @Override
    public void addSectionAfterPrice(TooltipMakerAPI info, float width, boolean expanded, CargoStackAPI stack) {
        if ("marines".equals(stack.getCommodityId()) && !expanded) {
            this.saveData();
            this.update(true, true, stack);
            PersonnelData data = this.marineData;
            boolean nonPlayer = false;
            if (!stack.isInPlayerCargo()) {
                nonPlayer = true;
                PersonnelAtEntity atLoc = this.getPersonnelAtLocation(stack.getCommodityId(), this.getSubmarketFor(stack));
                data = atLoc != null ? atLoc.data : null;
            }
            if (data != null) {
                if (data.num <= 0.0f) {
                    this.restoreData();
                    return;
                }
                float opad = 10.0f;
                float pad = 3.0f;
                Color h = Misc.getHighlightColor();
                PersonnelRank rank = data.getRank();
                LabelAPI heading = info.addSectionHeading(String.valueOf(rank.name) + " Marines", Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Alignment.MID, opad);
                heading.autoSizeToWidth(info.getTextWidthOverride());
                PositionAPI p = heading.getPosition();
                p.setSize(p.getWidth(), p.getHeight() + 3.0f);
                switch (rank) {
                    case REGULAR: {
                        if (nonPlayer) {
                            info.addPara("Regular marines - tough, competent, and disciplined.", opad);
                            break;
                        }
                        info.addPara("These marines are mostly regulars and have seen some combat, but are not, overall, accustomed to your style of command.", opad);
                        break;
                    }
                    case EXPERIENCED: {
                        if (nonPlayer) {
                            info.addPara("Experienced marines with substantial training and a number of operations under their belts.", opad);
                            break;
                        }
                        info.addPara("You've led these marines on several operations, and the experience gained by both parties is beginning to show concrete benefits.", opad);
                        break;
                    }
                    case VETERAN: {
                        if (nonPlayer) {
                            info.addPara("These marines are veterans of many ground operations. Well-motivated and highly effective.", opad);
                            break;
                        }
                        info.addPara("These marines are veterans of many ground operations under your leadership; the command structure is well established and highly effective.", opad);
                        break;
                    }
                    case ELITE: {
                        if (nonPlayer) {
                            info.addPara("These marines are an elite force, equipped, led, and motivated well above the standards of even the professional militaries in the Sector.", opad);
                            break;
                        }
                        info.addPara("These marines are an elite force, equipped, led, and motivated well above the standards of even the professional militaries in the Sector.", opad);
                    }
                }
                float effectBonus = this.getMarineEffectBonus(data);
                float casualtyReduction = this.getMarineLossesReductionPercent(data);
                MutableStat fake = new MutableStat(1.0f);
                fake.modifyPercentAlways("1", effectBonus, "increased effectiveness of ground operations");
                fake.modifyPercentAlways("2", -casualtyReduction, "reduction to marine casualties suffered during ground operations");
                info.addStatModGrid(width, 50.0f, 10.0f, opad, fake, true, null);
            }
            this.restoreData();
        }
    }

    @Override
    public void reportPlayerClosedMarket(MarketAPI market) {
        this.update();
    }

    @Override
    public void reportPlayerOpenedMarket(MarketAPI market) {
        this.update();
    }

    public String getIconName() {
        return null;
    }

    @Override
    public int getHandlingPriority(Object params) {
        CargoStackAPI stack;
        if (params instanceof CommodityIconProviderWrapper && "marines".equals((stack = ((CommodityIconProviderWrapper)params).stack).getCommodityId())) {
            if (stack.isInPlayerCargo()) {
                return 0;
            }
            SubmarketAPI sub = this.getSubmarketFor(stack);
            PersonnelAtEntity atLocation = this.getPersonnelAtLocation(stack.getCommodityId(), sub);
            if (atLocation != null) {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public String getRankIconName(CargoStackAPI stack) {
        if (stack.isPickedUp()) {
            return null;
        }
        this.saveData();
        this.update(true, true, stack);
        PersonnelData data = null;
        if (stack.isMarineStack()) {
            data = this.marineData;
            if (!stack.isInPlayerCargo()) {
                SubmarketAPI sub = this.getSubmarketFor(stack);
                PersonnelAtEntity atLocation = this.getPersonnelAtLocation(stack.getCommodityId(), sub);
                if (atLocation != null) {
                    data = atLocation.data;
                } else {
                    this.restoreData();
                    return null;
                }
            }
        }
        if (data == null || data.num <= 0.0f) {
            this.restoreData();
            return null;
        }
        PersonnelRank rank = data.getRank();
        this.restoreData();
        return Global.getSettings().getSpriteName("ui", rank.iconKey);
    }

    @Override
    public String getIconName(CargoStackAPI stack) {
        return null;
    }

    public void saveData() {
        this.savedMarineData = this.marineData;
        this.marineData = this.marineData.clone();
        this.savedPersonnelData = new ArrayList<PersonnelAtEntity>();
        for (PersonnelAtEntity curr : this.droppedOff) {
            this.savedPersonnelData.add(curr.clone());
        }
    }

    public void restoreData() {
        this.marineData = this.savedMarineData;
        this.savedMarineData = null;
        this.droppedOff.clear();
        this.droppedOff.addAll(this.savedPersonnelData);
        this.savedPersonnelData.clear();
    }

    @Override
    public void reportPlayerOpenedMarketAndCargoUpdated(MarketAPI market) {
    }

    @Override
    public void modifyRaidObjectives(MarketAPI market, SectorEntityToken entity, List<GroundRaidObjectivePlugin> objectives, MarketCMD.RaidType type, int marineTokens, int priority) {
    }

    protected void doCleanup(boolean withDroppedOff) {
        this.marineData.savedNum = this.marineData.num;
        this.marineData.savedXP = this.marineData.xp;
        this.pods = null;
        if (withDroppedOff) {
            Iterator<PersonnelAtEntity> iter = this.droppedOff.iterator();
            while (iter.hasNext()) {
                PersonnelAtEntity pae = iter.next();
                if (pae.entity.isAlive() && !(pae.data.num <= 0.0f) && !(pae.data.xp <= 0.0f)) continue;
                iter.remove();
            }
        }
    }

    public SectorEntityToken getInteractionEntity() {
        InteractionDialogAPI dialog = Global.getSector().getCampaignUI().getCurrentInteractionDialog();
        SectorEntityToken entity = null;
        if (dialog != null && (entity = dialog.getInteractionTarget()) != null && entity.getMarket() != null && entity.getMarket().getPrimaryEntity() != null) {
            entity = entity.getMarket().getPrimaryEntity();
        }
        return entity;
    }

    public SubmarketAPI getSubmarketFor(CargoStackAPI stack) {
        if (stack.getCargo() == null) {
            return null;
        }
        SectorEntityToken entity = this.getInteractionEntity();
        if (entity == null || entity.getMarket() == null || entity.getMarket().getSubmarketsCopy() == null) {
            return this.currSubmarket;
        }
        for (SubmarketAPI sub : entity.getMarket().getSubmarketsCopy()) {
            if (sub.getCargo() != stack.getCargo()) continue;
            return sub;
        }
        return this.currSubmarket;
    }

    public PersonnelAtEntity getDroppedOffAt(String commodityId, SectorEntityToken entity, SubmarketAPI sub, boolean createIfNull) {
        String submarketId = sub == null ? "" : sub.getSpecId();
        for (PersonnelAtEntity pae : this.droppedOff) {
            String otherSubmarketId;
            String string = otherSubmarketId = pae.submarketId == null ? "" : pae.submarketId;
            if (entity != pae.entity || !commodityId.equals(pae.data.id) || !submarketId.equals(otherSubmarketId)) continue;
            return pae;
        }
        if (createIfNull) {
            PersonnelAtEntity pae;
            if (submarketId.isEmpty()) {
                submarketId = null;
            }
            pae = new PersonnelAtEntity(entity, commodityId, submarketId);
            this.droppedOff.add(pae);
            return pae;
        }
        return null;
    }

    public PersonnelAtEntity getPersonnelAtLocation(String commodityId, SubmarketAPI sub) {
        SectorEntityToken entity = this.getInteractionEntity();
        PersonnelAtEntity atLocation = entity == null ? null : this.getDroppedOffAt(commodityId, entity, sub, false);
        return atLocation;
    }

    public PersonnelData getMarineData() {
        return this.marineData;
    }

    public List<PersonnelAtEntity> getDroppedOff() {
        return this.droppedOff;
    }

    public static class CommodityDescriptionProviderWrapper {
        public CargoStackAPI stack;

        public CommodityDescriptionProviderWrapper(CargoStackAPI stack) {
            this.stack = stack;
        }
    }

    public static class CommodityIconProviderWrapper {
        public CargoStackAPI stack;

        public CommodityIconProviderWrapper(CargoStackAPI stack) {
            this.stack = stack;
        }
    }

    public static class PersonnelAtEntity
    implements Cloneable {
        public PersonnelData data;
        public SectorEntityToken entity;
        public String submarketId;

        public PersonnelAtEntity(SectorEntityToken entity, String commodityId, String submarketId) {
            this.entity = entity;
            this.data = new PersonnelData(commodityId);
            this.submarketId = submarketId;
        }

        protected PersonnelAtEntity clone() {
            try {
                PersonnelAtEntity copy = (PersonnelAtEntity)super.clone();
                copy.data = this.data.clone();
                return copy;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class PersonnelData
    implements Cloneable {
        public String id;
        public float xp;
        public float num;
        public transient float savedNum;
        public transient float savedXP;

        public PersonnelData(String id) {
            this.id = id;
        }

        protected PersonnelData clone() {
            try {
                PersonnelData copy = (PersonnelData)super.clone();
                copy.savedNum = this.savedNum;
                copy.savedXP = this.savedXP;
                return copy;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public void add(int add) {
            this.num += (float)add;
        }

        public void remove(int remove, boolean removeXP) {
            if (!KEEP_XP_DURING_TRANSFERS) {
                removeXP = true;
            }
            if ((float)remove > this.num) {
                remove = (int)this.num;
            }
            if (removeXP) {
                this.xp *= (this.num - (float)remove) / Math.max(1.0f, this.num);
            }
            this.num -= (float)remove;
            if (removeXP) {
                float maxXP = this.num;
                this.xp = Math.min(this.xp, maxXP);
            }
        }

        public void addXP(float xp) {
            this.xp += xp;
            float maxXP = this.num;
            this.xp = Math.min(this.xp, maxXP);
        }

        public void removeXP(float xp) {
            this.xp -= xp;
            if (xp < 0.0f) {
                xp = 0.0f;
            }
        }

        public float clampXP() {
            float maxXP = this.num;
            float prevXP = this.xp;
            this.xp = Math.min(this.xp, maxXP);
            return Math.max(0.0f, prevXP - maxXP);
        }

        public void numMayHaveChanged(float newNum, boolean keepXP) {
            if (this.num > newNum) {
                if (keepXP) {
                    this.clampXP();
                } else {
                    this.xp *= newNum / Math.max(1.0f, this.num);
                }
            }
            this.num = newNum;
        }

        public float getXPLevel() {
            float f = this.xp / Math.max(1.0f, this.num);
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            return f;
        }

        public PersonnelRank getRank() {
            PersonnelRank rank = PersonnelRank.getRankForXP(this.getXPLevel());
            return rank;
        }

        public void integrateWithCurrentLocation(PersonnelAtEntity atLocation) {
            int numTaken = Math.round(this.num - this.savedNum);
            if (atLocation != null) {
                this.num = this.savedNum;
                this.xp = this.savedXP;
                PersonnelData copy = atLocation.data;
                if (numTaken > 0) {
                    PlayerFleetPersonnelTracker.transferPersonnel(copy, this, numTaken, this);
                } else if (numTaken < 0) {
                    PlayerFleetPersonnelTracker.transferPersonnel(this, copy, -numTaken, this);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PersonnelRank {
        REGULAR("Regular", "icon_crew_green", 0.25f),
        EXPERIENCED("Experienced", "icon_crew_regular", 0.5f),
        VETERAN("Veteran", "icon_crew_veteran", 0.75f),
        ELITE("Elite", "icon_crew_elite", 1.0f);

        public String name;
        public String iconKey;
        public float threshold;

        private PersonnelRank(String name, String iconKey, float threshold) {
            this.name = name;
            this.iconKey = iconKey;
            this.threshold = threshold;
        }

        public static PersonnelRank getRankForXP(float xp) {
            float f = xp;
            PersonnelRank[] personnelRankArray = PersonnelRank.values();
            int n = personnelRankArray.length;
            int n2 = 0;
            while (n2 < n) {
                PersonnelRank rank = personnelRankArray[n2];
                if (f < rank.threshold) {
                    return rank;
                }
                ++n2;
            }
            return ELITE;
        }
    }
}

