/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.impl.campaign.CampaignObjective;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class BaseCampaignObjectivePlugin
extends BaseCustomEntityPlugin
implements CampaignObjective {
    public static final String HACKED = "$cob_hacked";
    public static final String RESET = "$cob_reset";
    public static final float HACK_DURATION_DAYS = 90.0f;
    public static final float RESET_DURATION_DAYS = 30.0f;

    public void printEffect(TooltipMakerAPI text, float pad) {
    }

    public void addHackStatusToTooltip(TooltipMakerAPI text, float pad) {
        if (this.isHacked().booleanValue()) {
            text.addPara("Hacked", Misc.getTextColor(), pad);
        }
        if (this.isReset().booleanValue()) {
            text.addPara("Disrupted by factory reset", Misc.getTextColor(), pad);
        }
    }

    public void printNonFunctionalAndHackDescription(TextPanelAPI text) {
    }

    public Boolean isHacked() {
        if (this.entity != null && this.entity.getMemoryWithoutUpdate().getBoolean(HACKED)) {
            return true;
        }
        return false;
    }

    public void setHacked(boolean hacked) {
        this.setHacked(hacked, 90.0f + (float)Math.random() * 0.5f * 90.0f);
    }

    public void setHacked(boolean hacked, float days) {
        if (hacked) {
            this.entity.getMemoryWithoutUpdate().set(HACKED, hacked, days);
        } else {
            this.entity.getMemoryWithoutUpdate().unset(HACKED);
        }
    }

    public Boolean isReset() {
        if (this.entity != null && this.entity.getMemoryWithoutUpdate().getBoolean(RESET)) {
            return true;
        }
        return false;
    }

    public void setReset(boolean reset) {
        this.setReset(reset, 30.0f + (float)Math.random() * 0.5f * 30.0f);
    }

    public void setReset(boolean reset, float days) {
        if (reset) {
            this.entity.getMemoryWithoutUpdate().set(RESET, reset, days);
        } else {
            this.entity.getMemoryWithoutUpdate().unset(RESET);
        }
    }
}

