/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCustomUIPanelPlugin;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import java.awt.Color;
import java.util.List;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleCustomUIPanel
extends BaseCustomUIPanelPlugin {
    private PositionAPI p;
    private SpriteAPI sprite = Global.getSettings().getSprite("graphics/ships/wolf/wolf_base.png");
    private float mouseX;
    private float mouseY;

    @Override
    public void positionChanged(PositionAPI position) {
        this.p = position;
        this.mouseX = this.p.getX() + this.p.getWidth() / 2.0f;
        this.mouseY = this.p.getY() + this.p.getHeight() / 2.0f;
    }

    @Override
    public void advance(float amount) {
        if (this.p == null) {
            return;
        }
    }

    @Override
    public void processInput(List<InputEventAPI> events) {
        if (this.p == null) {
            return;
        }
        for (InputEventAPI event : events) {
            if (event.isConsumed() || !event.isMouseMoveEvent()) continue;
            if (this.p.containsEvent(event)) {
                this.mouseX = event.getX();
                this.mouseY = event.getY();
                continue;
            }
            this.mouseX = this.p.getX() + this.p.getWidth() / 2.0f;
            this.mouseY = this.p.getY() + this.p.getHeight() / 2.0f;
        }
    }

    @Override
    public void render(float alphaMult) {
        if (this.p == null) {
            return;
        }
        float x = this.p.getX();
        float y = this.p.getY();
        float w = this.p.getWidth();
        float h = this.p.getHeight();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Color color = Color.cyan;
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult * 0.25f)));
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)x, (float)(y + h));
        GL11.glVertex2f((float)(x + w), (float)(y + h));
        GL11.glVertex2f((float)(x + w), (float)y);
        GL11.glEnd();
        this.sprite.setAlphaMult(alphaMult);
        this.sprite.renderAtCenter(this.mouseX, this.mouseY);
    }

    @Override
    public void renderBelow(float alphaMult) {
    }

    @Override
    public void buttonPressed(Object buttonId) {
        super.buttonPressed(buttonId);
    }
}

