/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.BaseCampaignObjectivePlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class NavBuoyEntityPlugin
extends BaseCampaignObjectivePlugin {
    public static float NAV_BONUS = 3.0f;
    public static float NAV_BONUS_MAKESHIFT = 2.0f;

    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.readResolve();
    }

    Object readResolve() {
        return this;
    }

    public void advance(float amount) {
        if (this.entity.getContainingLocation() == null || this.entity.isInHyperspace()) {
            return;
        }
        if (this.isReset().booleanValue()) {
            return;
        }
        String id = this.getModId();
        for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
            MutableStat.StatMod curr;
            if (fleet.isInHyperspaceTransition() || fleet.getFaction() != this.entity.getFaction() && (!this.isHacked().booleanValue() || !fleet.getFaction().isPlayerFaction())) continue;
            String desc = "Nav buoy";
            float bonus = NAV_BONUS;
            if (this.isMakeshift()) {
                desc = "Makeshift nav buoy";
                bonus = NAV_BONUS_MAKESHIFT;
            }
            if ((curr = fleet.getStats().getFleetwideMaxBurnMod().getFlatBonus(id)) != null && !(curr.value <= bonus)) continue;
            fleet.getStats().addTemporaryModFlat(0.1f, id, desc, bonus, fleet.getStats().getFleetwideMaxBurnMod());
        }
    }

    protected boolean isMakeshift() {
        return this.entity.hasTag("makeshift");
    }

    public void printEffect(TooltipMakerAPI text, float pad) {
        int bonus = (int)NAV_BONUS;
        if (this.isMakeshift()) {
            bonus = (int)NAV_BONUS_MAKESHIFT;
        }
        text.addPara("      %s burn level for all same-faction fleets in system", pad, Misc.getHighlightColor(), "+" + bonus);
        if (this.isReset().booleanValue()) {
            text.addPara("      Auto-calibrating after factory reset; non-functional", 3.0f);
        }
    }

    public void printNonFunctionalAndHackDescription(TextPanelAPI text) {
        if (this.entity.getMemoryWithoutUpdate().getBoolean("$objectiveNonFunctional")) {
            text.addPara("This one, however, does not appear to be transmitting a navigation telemetry broadcast. The cause of its lack of function is unknown.");
        }
        if (this.isHacked().booleanValue()) {
            text.addPara("You have a hack running on this nav buoy.");
        }
    }

    public void addHackStatusToTooltip(TooltipMakerAPI text, float pad) {
        int bonus = (int)NAV_BONUS;
        if (this.isMakeshift()) {
            bonus = (int)NAV_BONUS_MAKESHIFT;
        }
        text.addPara("%s burn level for in-system fleets", pad, Misc.getHighlightColor(), "+" + bonus);
        super.addHackStatusToTooltip(text, pad);
    }

    protected String getModId() {
        return "nav_buoy";
    }
}

