/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.DumpMemory;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanetInteractionDialogPluginImpl
implements InteractionDialogPlugin {
    public static int STABLE_FUEL_REQ = 500;
    public static int STABLE_MACHINERY_REQ = 200;
    public static String ADDED_KEY = "$core_starAddedStable";
    private InteractionDialogAPI dialog;
    private TextPanelAPI textPanel;
    private OptionPanelAPI options;
    private VisualPanelAPI visual;
    private CampaignFleetAPI playerFleet;
    private PlanetAPI planet;
    private boolean unpauseOnExit = true;
    private static final Color HIGHLIGHT_COLOR = Global.getSettings().getColor("buttonShortcut");
    private OptionId lastOptionMousedOver = null;

    public boolean isUnpauseOnExit() {
        return this.unpauseOnExit;
    }

    public void setUnpauseOnExit(boolean unpauseOnExit) {
        this.unpauseOnExit = unpauseOnExit;
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.planet = (PlanetAPI)dialog.getInteractionTarget();
        this.visual.setVisualFade(0.25f, 0.25f);
        if (this.planet.getCustomInteractionDialogImageVisual() != null) {
            this.visual.showImageVisual(this.planet.getCustomInteractionDialogImageVisual());
        } else if (!Global.getSettings().getBoolean("3dPlanetBGInInteractionDialog")) {
            this.visual.showPlanetInfo(this.planet);
        }
        dialog.setOptionOnEscape("Leave", (Object)OptionId.LEAVE);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        if (optionData == "DumpMemory.option_dump_memory") {
            HashMap<String, MemoryAPI> memoryMap = new HashMap<String, MemoryAPI>();
            MemoryAPI memory = this.dialog.getInteractionTarget().getMemory();
            memoryMap.put("local", memory);
            if (this.dialog.getInteractionTarget().getFaction() != null) {
                memoryMap.put("faction", this.dialog.getInteractionTarget().getFaction().getMemory());
            } else {
                memoryMap.put("faction", Global.getFactory().createMemory());
            }
            memoryMap.put("global", Global.getSector().getMemory());
            memoryMap.put("player", Global.getSector().getCharacterData().getMemory());
            if (this.dialog.getInteractionTarget().getMarket() != null) {
                memoryMap.put("market", this.dialog.getInteractionTarget().getMarket().getMemory());
            }
            new DumpMemory().execute(null, this.dialog, null, memoryMap);
            return;
        }
        if (DevMenuOptions.isDevOption(optionData)) {
            DevMenuOptions.execute(this.dialog, (String)optionData);
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        String type = "star";
        String corona = "star's corona";
        String corona2 = "in the star's corona";
        if (this.planet.getSpec().isBlackHole()) {
            type = "black hole";
            corona = "event horizon";
            corona2 = "near the event horizon";
        }
        switch (option) {
            case INIT: {
                Description desc;
                boolean didAlready = this.planet.getMemoryWithoutUpdate().getBoolean(ADDED_KEY);
                this.addText(this.getString("approach"));
                if (didAlready) {
                    this.addText("The " + corona + " exhibits fluctuations indicative of recent antimatter application.");
                }
                if ((desc = Global.getSettings().getDescription(this.planet.getCustomDescriptionId(), Description.Type.CUSTOM)) != null && desc.hasText3()) {
                    this.addText(desc.getText3());
                }
                this.createInitialOptions();
                break;
            }
            case DUMP_PLANETKILLER: {
                this.addText("Your officers respond promptly to the order, and move to the task with all alacrity. There is an edge to their call-and-response, however, as if they cannot help but acknowledge the deep sense of the gravity in this act.\n\"Package ready to drop, captain,\" your ops chief says. \"On your order.\"");
                this.options.clearOptions();
                this.options.addOption("\"Destroy it!\"", (Object)OptionId.DUMP_PLANETKILLER_CONT_1, null);
                this.options.addOption("\"No... I will keep it.\"", (Object)OptionId.DUMP_PLANETKILLER_ON_SECOND_THOUGHT, null);
                break;
            }
            case DUMP_PLANETKILLER_ON_SECOND_THOUGHT: {
                this.createInitialOptions();
                break;
            }
            case DUMP_PLANETKILLER_CONT_1: {
                this.addText("At your command the planetkiller, locked in its cradle, is boosted toward the very center of the black hole, up and over the plane of the accretion disc.\n\nWith a flash only a little more than noise in the sensor telemetry, it is gone.");
                AddRemoveCommodity.addItemLossText(new SpecialItemData("planetkiller", null), 1, this.dialog.getTextPanel());
                Global.getSector().getPlayerStats().addStoryPoints(1, this.dialog.getTextPanel(), false);
                this.removePK();
                this.options.clearOptions();
                this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
                this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
                break;
            }
            case ADD_STABLE_CONFIRM: {
                StarSystemAPI system = this.planet.getStarSystem();
                if (system != null) {
                    CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
                    cargo.removeFuel(STABLE_FUEL_REQ);
                    AddRemoveCommodity.addCommodityLossText("fuel", STABLE_FUEL_REQ, this.dialog.getTextPanel());
                    StarSystemGenerator.addStableLocations(system, 1);
                    this.planet.getMemoryWithoutUpdate().set(ADDED_KEY, true);
                    this.addText("Preparations are made, and you give the go-ahead. A few tense minutes later, the chief engineer reports success. The resulting stable location won't last for millennia, like naturally-occurring ones - but it'll do for your purposes.");
                }
                this.createInitialOptions();
                break;
            }
            case ADD_STABLE_DESCRIBE: {
                String reason;
                this.addText("The procedure requires spreading prodigious amounts of antimatter " + corona2 + ", " + "according to calculations far beyond the ability of anything on the right side of the " + "treaty that ended the Second AI War.");
                boolean canAfford = this.dialog.getTextPanel().addCostPanel("Resources required (available)", "alpha_core", 1, false, "heavy_machinery", STABLE_MACHINERY_REQ, false, "fuel", STABLE_FUEL_REQ, true);
                this.options.clearOptions();
                int num = Misc.getNumStableLocations(this.planet.getStarSystem());
                boolean alreadyCant = false;
                if (num <= 0) {
                    this.options.addOption("Proceed with the operation", (Object)OptionId.ADD_STABLE_CONFIRM, null);
                } else if (num < 2) {
                    this.addText("Normally, this procedure can only be performed in a star system without any stable locations. However, your chief engineer suggests an unorthodox workaround.");
                    this.options.addOption("Proceed with the operation", (Object)OptionId.ADD_STABLE_CONFIRM, null);
                    SetStoryOption.set(this.dialog, Global.getSettings().getInt("createStableLocation"), (Object)OptionId.ADD_STABLE_CONFIRM, "createStableLocation", Sounds.STORY_POINT_SPEND_TECHNOLOGY, "Created additional stable location in " + this.planet.getStarSystem().getNameWithLowercaseType());
                } else {
                    alreadyCant = true;
                    reason = "This procedure can not performed in a star system that already has numerous stable locations.";
                    this.options.addOption("Proceed with the operation", (Object)OptionId.ADD_STABLE_CONFIRM, null);
                    this.options.setEnabled((Object)OptionId.ADD_STABLE_CONFIRM, false);
                    this.addText(reason);
                    this.options.setTooltip((Object)OptionId.ADD_STABLE_CONFIRM, reason);
                }
                if (!canAfford && !alreadyCant) {
                    reason = "You do not have the necessary resources to carry out this procedure.";
                    this.options.setEnabled((Object)OptionId.ADD_STABLE_CONFIRM, false);
                    this.addText(reason);
                    this.options.setTooltip((Object)OptionId.ADD_STABLE_CONFIRM, reason);
                }
                this.options.addOption("Never mind", (Object)OptionId.ADD_STABLE_NEVER_MIND, null);
                break;
            }
            case ADD_STABLE_NEVER_MIND: {
                this.createInitialOptions();
                break;
            }
            case LEAVE: {
                if (this.unpauseOnExit) {
                    Global.getSector().setPaused(false);
                }
                this.dialog.dismiss();
            }
        }
    }

    protected void createInitialOptions() {
        this.options.clearOptions();
        MemoryAPI memory = this.dialog.getInteractionTarget().getMemory();
        String type = "star";
        String corona = "star's corona";
        String corona2 = "in the star's corona";
        boolean blackHole = false;
        if (this.planet.getSpec().isBlackHole()) {
            blackHole = true;
            type = "black hole";
            corona = "event horizon";
            corona2 = "near the event horizon";
        }
        StarSystemAPI system = this.planet.getStarSystem();
        boolean didAlready = this.planet.getMemoryWithoutUpdate().getBoolean(ADDED_KEY);
        if (system != null && this.planet == system.getStar() && !didAlready) {
            this.options.addOption("Consider inducing a resonance cascade in the " + type + "'s hyperfield, creating a stable location", (Object)OptionId.ADD_STABLE_DESCRIBE, null);
        }
        if (this.hasPK() && blackHole) {
            this.options.addOption("Dump the planetkiller weapon into the black hole", (Object)OptionId.DUMP_PLANETKILLER, null);
        }
        this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
        this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
        if (Global.getSettings().isDevMode()) {
            DevMenuOptions.addOptions(this.dialog);
        }
    }

    public void removePK() {
        Global.getSector().getPlayerFleet().getCargo().removeItems(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("planetkiller", null), 1.0f);
    }

    public boolean hasPK() {
        return Global.getSector().getPlayerFleet().getCargo().getQuantity(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("planetkiller", null)) > 0.0f;
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    private void addText(String text) {
        this.textPanel.addParagraph(text);
    }

    private void appendText(String text) {
        this.textPanel.appendToLastParagraph(" " + text);
    }

    private String getString(String id) {
        String str = Global.getSettings().getString("planetInteractionDialog", id);
        String fleetOrShip = "fleet";
        if (this.playerFleet.getFleetData().getMembersListCopy().size() == 1) {
            fleetOrShip = "ship";
            if (this.playerFleet.getFleetData().getMembersListCopy().get(0).isFighterWing()) {
                fleetOrShip = "fighter wing";
            }
        }
        str = str.replaceAll("\\$fleetOrShip", fleetOrShip);
        str = str.replaceAll("\\$planetName", this.planet.getName());
        return str;
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OptionId {
        INIT,
        ADD_STABLE_CONFIRM,
        ADD_STABLE_DESCRIBE,
        DUMP_PLANETKILLER,
        DUMP_PLANETKILLER_ON_SECOND_THOUGHT,
        DUMP_PLANETKILLER_CONT_1,
        ADD_STABLE_NEVER_MIND,
        LEAVE;

    }
}

