/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.RuleBasedDialog;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.campaign.rules.RulesAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.rulecmd.DismissDialog;
import com.fs.starfarer.api.impl.campaign.rulecmd.DumpMemory;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBasedInteractionDialogPluginImpl
implements InteractionDialogPlugin,
RuleBasedDialog {
    public static final String FAILSAFE_LEAVE = "rbid_failsafe_leave";
    private InteractionDialogAPI dialog;
    private TextPanelAPI textPanel;
    private OptionPanelAPI options;
    private VisualPanelAPI visual;
    private RulesAPI rules;
    private MemoryAPI memory;
    private CampaignFleetAPI playerFleet;
    private static final Color HIGHLIGHT_COLOR = Global.getSettings().getColor("buttonShortcut");
    private boolean embeddedMode = false;
    private final String initialTrigger;
    private String lastOptionMousedOver = null;
    private Map<String, MemoryAPI> memoryMap;

    public void setEmbeddedMode(boolean embeddedMode) {
        this.embeddedMode = embeddedMode;
    }

    public RuleBasedInteractionDialogPluginImpl() {
        this("OpenInteractionDialog");
    }

    public RuleBasedInteractionDialogPluginImpl(String initialTrigger) {
        this.initialTrigger = initialTrigger;
    }

    @Override
    public void reinit(boolean withContinueOnRuleFound) {
        this.init(this.dialog);
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        if (!this.embeddedMode) {
            this.visual.setVisualFade(0.25f, 0.25f);
        }
        this.rules = Global.getSector().getRules();
        this.updateMemory();
        if (!this.embeddedMode) {
            this.fireBest(this.initialTrigger);
            if (!this.options.hasOptions()) {
                this.options.clearOptions();
                this.options.addOption("Leave", FAILSAFE_LEAVE);
                if (Global.getSettings().isDevMode()) {
                    DevMenuOptions.addOptions(dialog);
                }
            }
        }
    }

    @Override
    public void updateMemory() {
        if (this.memoryMap == null) {
            this.memoryMap = new HashMap<String, MemoryAPI>();
        } else {
            this.memoryMap.clear();
        }
        this.memory = this.dialog.getInteractionTarget().getMemory();
        this.memoryMap.put("local", this.memory);
        if (this.dialog.getInteractionTarget().getFaction() != null) {
            this.memoryMap.put("faction", this.dialog.getInteractionTarget().getFaction().getMemory());
        } else {
            this.memoryMap.put("faction", Global.getFactory().createMemory());
        }
        this.memoryMap.put("global", Global.getSector().getMemory());
        this.memoryMap.put("player", Global.getSector().getCharacterData().getMemory());
        if (this.dialog.getInteractionTarget().getMarket() != null) {
            this.memoryMap.put("market", this.dialog.getInteractionTarget().getMarket().getMemory());
        }
        if (this.memory.contains("$sourceMarket")) {
            String marketId = this.memory.getString("$sourceMarket");
            MarketAPI market = Global.getSector().getEconomy().getMarket(marketId);
            if (market != null) {
                this.memoryMap.put("sourceMarket", market.getMemory());
            }
        }
        this.updatePersonMemory();
    }

    private void updatePersonMemory() {
        PersonAPI person = this.dialog.getInteractionTarget().getActivePerson();
        if (person != null) {
            this.memory = person.getMemory();
            this.memoryMap.put("local", this.memory);
            this.memoryMap.put("personFaction", person.getFaction().getMemory());
            this.memoryMap.put("entity", this.dialog.getInteractionTarget().getMemory());
        } else {
            this.memory = this.dialog.getInteractionTarget().getMemory();
            this.memoryMap.put("local", this.memory);
            this.memoryMap.remove("entity");
            this.memoryMap.remove("personFaction");
        }
    }

    @Override
    public void notifyActivePersonChanged() {
        this.updatePersonMemory();
    }

    @Override
    public void setActiveMission(CampaignEventPlugin mission) {
        if (mission == null) {
            this.memoryMap.remove("mission");
        } else {
            MemoryAPI memory = mission.getMemory();
            if (memory != null) {
                this.memoryMap.put("mission", memory);
            } else {
                this.memoryMap.remove("mission");
            }
        }
    }

    public boolean fireAll(String trigger) {
        return FireAll.fire(null, this.dialog, this.memoryMap, trigger);
    }

    public boolean fireBest(String trigger) {
        return FireBest.fire(null, this.dialog, this.memoryMap, trigger);
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null || !(optionData instanceof String)) {
            return;
        }
        String optionId = (String)optionData;
        if (text != null) {
            this.dialog.addOptionSelectedText(optionData);
        }
        if (optionId == FAILSAFE_LEAVE) {
            new DismissDialog().execute(null, this.dialog, null, this.memoryMap);
            return;
        }
        if (optionId == "DumpMemory.option_dump_memory") {
            new DumpMemory().execute(null, this.dialog, null, this.memoryMap);
            return;
        }
        if (DevMenuOptions.isDevOption(optionData)) {
            DevMenuOptions.execute(this.dialog, (String)optionData);
            return;
        }
        this.memory.set("$option", optionId);
        this.memory.expire("$option", 0.0f);
        boolean foundRule = this.fireBest("DialogOptionSelected");
        if (!foundRule && !this.dialog.isCurrentOptionHadAConfirm()) {
            this.textPanel.addPara("ERROR: no rule found for option " + optionId + ", adding a failsafe option to exit dialog.", Misc.getNegativeHighlightColor());
            this.textPanel.addPara("Note: this may break any mission interaction in the current dialog, it's recommended that you reload an earlier save if you use this option.");
            this.textPanel.highlightInLastPara(Misc.getNegativeHighlightColor(), "recommended that you reload an earlier save");
            this.options.addOption("Exit dialog", FAILSAFE_LEAVE);
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    private void addText(String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        this.textPanel.addParagraph(text);
    }

    private void appendText(String text) {
        this.textPanel.appendToLastParagraph(" " + text);
    }

    @Override
    public Object getContext() {
        return null;
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return this.memoryMap;
    }
}

