/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.List;

public class TOffAlarm
implements EveryFrameScript {
    private IntervalUtil tracker = new IntervalUtil(0.05f, 0.1f);
    private final CampaignFleetAPI fleet;

    public TOffAlarm(CampaignFleetAPI fleet) {
        this.fleet = fleet;
        this.notifyNearby();
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.tracker.advance(days);
        if (this.tracker.intervalElapsed()) {
            this.notifyNearby();
        }
    }

    public void notifyNearby() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (playerFleet == null) {
            return;
        }
        if (this.fleet.getContainingLocation() == null) {
            return;
        }
        if (this.fleet.getMemoryWithoutUpdate().getBoolean("$lowRepImpact")) {
            return;
        }
        List<CampaignFleetAPI> fleets = this.fleet.getContainingLocation().getFleets();
        for (CampaignFleetAPI other : fleets) {
            SectorEntityToken.VisibilityLevel level = other.getVisibilityLevelTo(this.fleet);
            if (level == SectorEntityToken.VisibilityLevel.NONE || level != SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS || other.getFaction() != this.fleet.getFaction()) continue;
            MemoryAPI mem = other.getMemoryWithoutUpdate();
            Misc.setFlagWithReason(mem, "$cfai_makeHostileWhileTOff", "tOffAlarm", true, 1.0f);
        }
    }

    public boolean isDone() {
        MemoryAPI mem = this.fleet.getMemoryWithoutUpdate();
        if (mem.getBoolean("$lowRepImpact")) {
            return true;
        }
        return !mem.is("$sawPlayerTransponderOff", true) || !mem.is("$cfai_makeHostileWhileTOff", true);
    }

    public boolean runWhilePaused() {
        return false;
    }
}

