/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.util.Misc;

public class DistressCallResponsePirateAssignmentAI
extends BaseAssignmentAI {
    protected StarSystemAPI system;
    protected float elapsed = 0.0f;
    protected float dur = 30.0f + (float)Math.random() * 20.0f;
    protected boolean contactedPlayer = false;
    protected final JumpPointAPI inner;
    protected final JumpPointAPI outer;

    public DistressCallResponsePirateAssignmentAI(CampaignFleetAPI fleet, StarSystemAPI system, JumpPointAPI inner, JumpPointAPI outer) {
        this.fleet = fleet;
        this.system = system;
        this.inner = inner;
        this.outer = outer;
        this.giveInitialAssignments();
    }

    protected void giveInitialAssignments() {
        if (this.fleet.isInHyperspace()) {
            this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.outer, 20.0f);
        }
        this.fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.inner, 10.0f + 5.0f * (float)Math.random());
    }

    protected void pickNext() {
        Misc.giveStandardReturnToSourceAssignments(this.fleet);
    }

    public void advance(float amount) {
        SectorEntityToken.VisibilityLevel level;
        super.advance(amount);
        if (this.fleet.isInCurrentLocation() && !this.contactedPlayer && (level = this.fleet.getVisibilityLevelOfPlayerFleet()) != SectorEntityToken.VisibilityLevel.NONE && level != SectorEntityToken.VisibilityLevel.SENSOR_CONTACT) {
            this.contactedPlayer = true;
            this.fleet.addAssignmentAtStart(FleetAssignment.INTERCEPT, Global.getSector().getPlayerFleet(), 3.0f, "approaching your fleet", null);
        }
    }
}

