/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseToggleAbility;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class GoDarkAbility
extends BaseToggleAbility {
    public static final float DETECTABILITY_MULT = 0.5f;

    protected String getActivationText() {
        return "Going dark";
    }

    protected String getDeactivationText() {
        return null;
    }

    protected void activateImpl() {
    }

    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (level < 1.0f) {
            level = 0.0f;
        }
        float d = fleet.getStats().getDynamic().getValue("go_dark_effectiveness");
        fleet.getStats().getDetectedRangeMod().modifyMult(this.getModId(), 1.0f + (0.5f * d - 1.0f) * level, "Going dark");
        fleet.goSlowOneFrame();
        for (FleetMemberViewAPI view : fleet.getViews()) {
            view.getContrailColor().shift(this.getModId(), new Color(0, 0, 0, 0), 1.0f, 1.0f, 1.0f);
            view.getContrailDurMult().shift(this.getModId(), 0.0f, 1.0f, 1.0f, 1.0f);
            view.getEngineGlowSizeMult().shift(this.getModId(), 0.5f, 1.0f, 1.0f, 1.0f);
            view.getEngineHeightMult().shift(this.getModId(), 0.5f, 1.0f, 1.0f, 1.0f);
        }
    }

    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
    }

    public boolean showProgressIndicator() {
        return false;
    }

    public boolean showActiveIndicator() {
        return this.isActive();
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        String status = " (off)";
        if (this.turnedOn) {
            status = " (on)";
        }
        LabelAPI title = tooltip.addTitle(String.valueOf(this.spec.getName()) + status);
        title.highlightLast(status);
        title.setHighlightColor(gray);
        float pad = 10.0f;
        tooltip.addPara("Turns off all non-essential systems, reducing the range at which the fleet can be detected by %s and forcing the fleet to %s*.", pad, highlight, "50%", "move slowly");
        tooltip.addPara("*A fleet is considered slow-moving at a burn level of half that of its slowest ship.", gray, pad);
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    public boolean hasTooltip() {
        return true;
    }
}

