/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteSurveyAbility
extends BaseDurationAbility {
    public static final float SURVEY_RANGE = 10000.0f;
    public static final float DETECTABILITY_RANGE_BONUS = 5000.0f;
    public static final float ACCELERATION_MULT = 4.0f;
    protected boolean performed = false;

    @Override
    protected void activateImpl() {
        if (this.entity.isInCurrentLocation()) {
            SectorEntityToken.VisibilityLevel level = this.entity.getVisibilityLevelToPlayerFleet();
            if (level != SectorEntityToken.VisibilityLevel.NONE) {
                Global.getSector().addPing(this.entity, "remote_survey");
            }
            this.performed = false;
        }
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getFleetwideMaxBurnMod().modifyMult(this.getModId(), 0.0f, "Remote survey");
        fleet.getStats().getDetectedRangeMod().modifyFlat(this.getModId(), 5000.0f * level, "Remote survey");
        fleet.getStats().getAccelerationMult().modifyMult(this.getModId(), 1.0f + 3.0f * level);
        if (!this.performed && level >= 1.0f) {
            for (PlanetAPI planet : this.getSurveyableInRange()) {
                MarketAPI market = planet.getMarket();
                MarketAPI.SurveyLevel surveyLevel = market.getSurveyLevel();
                if (market == null || surveyLevel != MarketAPI.SurveyLevel.SEEN && surveyLevel != MarketAPI.SurveyLevel.NONE) continue;
                Misc.setPreliminarySurveyed(market, null, true);
            }
            this.performed = true;
        }
    }

    @Override
    public boolean isUsable() {
        if (!super.isUsable()) {
            return false;
        }
        if (this.getFleet() == null) {
            return false;
        }
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet.isInHyperspace() || fleet.isInHyperspaceTransition()) {
            return false;
        }
        return !this.getSurveyableInRange().isEmpty();
    }

    protected List<PlanetAPI> getAllPlanetsInRange() {
        ArrayList<PlanetAPI> result = new ArrayList<PlanetAPI>();
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return result;
        }
        if (fleet.isInHyperspace()) {
            return result;
        }
        for (PlanetAPI planet : fleet.getContainingLocation().getPlanets()) {
            float dist;
            if (planet.isStar() || planet.getMarket() == null || !((dist = Misc.getDistance(fleet.getLocation(), planet.getLocation())) <= 10000.0f)) continue;
            result.add(planet);
        }
        return result;
    }

    protected List<PlanetAPI> getSurveyableInRange() {
        List<PlanetAPI> result = this.getAllPlanetsInRange();
        Iterator<PlanetAPI> iter = result.iterator();
        while (iter.hasNext()) {
            PlanetAPI curr = iter.next();
            MarketAPI.SurveyLevel level = curr.getMarket().getSurveyLevel();
            if (level == MarketAPI.SurveyLevel.SEEN || level == MarketAPI.SurveyLevel.NONE) continue;
            iter.remove();
        }
        return result;
    }

    @Override
    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    @Override
    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
        fleet.getStats().getFleetwideMaxBurnMod().unmodify(this.getModId());
        fleet.getStats().getAccelerationMult().unmodify(this.getModId());
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        LabelAPI title = tooltip.addTitle(this.spec.getName());
        float pad = 10.0f;
        tooltip.addPara("Coordinate the fleet's active sensor network to perform a preliminary survey of all unsurveyed planets within %s* units.", pad, highlight, "10000");
        tooltip.addPara("Increases the range at which the fleet can be detected by %s* units and brings the fleet to a near-stop as drives are powered down to reduce interference.", pad, highlight, "5000");
        List<PlanetAPI> planets = this.getSurveyableInRange();
        if (planets.isEmpty()) {
            if (this.getAllPlanetsInRange().isEmpty()) {
                tooltip.addPara("No planets in range.", bad, pad);
            } else {
                tooltip.addPara("You have either full or preliminary survey data for all planets in range.", bad, pad);
            }
        } else {
            tooltip.addPara("The following unsurveyed planets are in range:", pad);
            float currPad = 3.0f;
            String indent = "    ";
            for (PlanetAPI planet : planets) {
                LabelAPI label = tooltip.addPara(String.valueOf(indent) + planet.getName() + ", %s", currPad, planet.getSpec().getIconColor(), planet.getTypeNameWithWorld().toLowerCase());
                currPad = 0.0f;
            }
        }
        tooltip.addPara("*2000 units = 1 map grid cell", gray, pad);
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }
}

