/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.abilities.ai.BaseAbilityAI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class SustainedBurnAbilityAI
extends BaseAbilityAI {
    public static final float AI_FREQUENCY_MULT = 1.0f;
    private IntervalUtil interval = new IntervalUtil(0.05f, 0.15f);

    public void advance(float days) {
        Vector2f travelDest;
        ModularFleetAIAPI ai;
        boolean smuggler;
        this.interval.advance(days * 1.0f);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        MemoryAPI mem = this.fleet.getMemoryWithoutUpdate();
        if (this.ability.isActiveOrInProgress()) {
            mem.set("$ai_hasSpeedBonus", true, 0.2f);
            mem.set("$ai_hasHigherDetectability", true, 0.2f);
        }
        if (smuggler = mem.getBoolean("$isSmuggler")) {
            if (this.ability.isActive()) {
                this.ability.deactivate();
            }
            return;
        }
        if (this.fleet.getAI() instanceof ModularFleetAIAPI && (ai = (ModularFleetAIAPI)this.fleet.getAI()).getTacticalModule().isMaintainingContact()) {
            if (this.ability.isActive()) {
                this.ability.deactivate();
            }
            return;
        }
        if (mem.getBoolean("$ai_hasLowerDetectability") && !this.ability.isActive()) {
            return;
        }
        CampaignFleetAPI pursueTarget = mem.getFleet("$ai_pursuitTarget");
        CampaignFleetAPI fleeingFrom = mem.getFleet("$ai_fleeingFrom");
        float burn = Misc.getBurnLevelForSpeed(this.fleet.getVelocity().length());
        float activationTime = this.ability.getSpec().getActivationDays() * Global.getSector().getClock().getSecondsPerDay();
        if (fleeingFrom != null) {
            float dist = Misc.getDistance(this.fleet.getLocation(), fleeingFrom.getLocation());
            float speed = Math.max(1.0f, fleeingFrom.getTravelSpeed());
            float time = dist / speed;
            if (!this.ability.isActive()) {
                if (time >= activationTime + 5.0f) {
                    this.ability.activate();
                }
            } else if (burn <= 3.0f && time < 5.0f) {
                this.ability.deactivate();
            }
            return;
        }
        if (pursueTarget != null) {
            float velDir;
            float toTarget;
            float diff;
            if (this.ability.isActive() && (diff = Misc.getAngleDiff(toTarget = Misc.getAngleInDegrees(this.fleet.getLocation(), pursueTarget.getLocation()), velDir = Misc.getAngleInDegrees(this.fleet.getVelocity()))) > 60.0f) {
                this.ability.deactivate();
            }
            return;
        }
        if (this.fleet.getAI() != null && this.fleet.getAI().getCurrentAssignment() != null) {
            boolean close;
            FleetAssignment curr = this.fleet.getAI().getCurrentAssignmentType();
            SectorEntityToken target = this.fleet.getAI().getCurrentAssignment().getTarget();
            boolean inSameLocation = target != null && target.getContainingLocation() == this.fleet.getContainingLocation();
            float distToTarget = 100000.0f;
            if (inSameLocation) {
                distToTarget = Misc.getDistance(target.getLocation(), this.fleet.getLocation());
            }
            boolean bl = close = distToTarget < 2000.0f;
            if (close && (curr == FleetAssignment.ORBIT_PASSIVE || curr == FleetAssignment.ORBIT_AGGRESSIVE || curr == FleetAssignment.DELIVER_CREW || curr == FleetAssignment.DELIVER_FUEL || curr == FleetAssignment.DELIVER_MARINES || curr == FleetAssignment.DELIVER_PERSONNEL || curr == FleetAssignment.DELIVER_RESOURCES || curr == FleetAssignment.DELIVER_SUPPLIES || curr == FleetAssignment.RESUPPLY || curr == FleetAssignment.GO_TO_LOCATION || curr == FleetAssignment.GO_TO_LOCATION_AND_DESPAWN)) {
                if (this.ability.isActive()) {
                    this.ability.deactivate();
                }
                return;
            }
            if (inSameLocation && (curr == FleetAssignment.RAID_SYSTEM || curr == FleetAssignment.PATROL_SYSTEM)) {
                if (this.ability.isActive()) {
                    this.ability.deactivate();
                }
                return;
            }
        }
        if ((travelDest = mem.getVector2f("$ai_travelDest")) != null) {
            float dist = Misc.getDistance(this.fleet.getLocation(), travelDest);
            float speed = Math.max(1.0f, this.fleet.getTravelSpeed());
            float time = dist / speed;
            if (!this.ability.isActive() && time > activationTime * 2.0f) {
                this.ability.activate();
            }
            return;
        }
    }
}

