/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.InstallableIndustryItemPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.campaign.econ.MutableCommodityQuantity;
import com.fs.starfarer.api.campaign.impl.items.GenericSpecialItemPlugin;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.econ.impl.ConstructionQueue;
import com.fs.starfarer.api.impl.campaign.econ.impl.GenericInstallableItemPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.InstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.ItemEffectsRepo;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.loading.IndustrySpecAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.IconRenderMode;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseIndustry
implements Industry,
Cloneable {
    public static int SIZE_FOR_SMALL_IMAGE = 3;
    public static int SIZE_FOR_LARGE_IMAGE = 6;
    public static float UPKEEP_MULT = 0.75f;
    public static int DEMAND_REDUCTION = 1;
    public static int SUPPLY_BONUS = 1;
    public static int DEFAULT_IMPROVE_SUPPLY_BONUS = 1;
    public static final String BASE_VALUE_TEXT = "Base value for colony size";
    protected Map<String, MutableCommodityQuantity> supply = new LinkedHashMap<String, MutableCommodityQuantity>();
    protected Map<String, MutableCommodityQuantity> demand = new LinkedHashMap<String, MutableCommodityQuantity>();
    protected MutableStat income = new MutableStat(0.0f);
    protected MutableStat upkeep = new MutableStat(0.0f);
    protected MarketAPI market;
    protected String id;
    protected float buildProgress = 0.0f;
    protected float buildTime = 1.0f;
    protected boolean building = false;
    protected Boolean improved = null;
    protected String upgradeId = null;
    protected transient IndustrySpecAPI spec = null;
    protected String aiCoreId = null;
    protected MutableStat demandReduction = new MutableStat(0.0f);
    protected MutableStat supplyBonus = new MutableStat(0.0f);
    protected transient MutableStat demandReductionFromOther = new MutableStat(0.0f);
    protected transient MutableStat supplyBonusFromOther = new MutableStat(0.0f);
    private transient String modId;
    private transient String[] modIds;
    protected Float buildCostOverride = null;
    protected boolean wasDisrupted = false;
    protected transient Industry.IndustryTooltipMode currTooltipMode = null;
    protected Boolean hiddenOverride = null;
    protected transient String dKey = null;
    protected SpecialItemData special = null;
    protected transient Boolean hasInstallableItems = null;

    protected BaseIndustry clone() {
        BaseIndustry copy = null;
        try {
            copy = (BaseIndustry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return copy;
    }

    public static String getDeficitText(String commodityId) {
        if (commodityId == null) {
            return "Various shortages";
        }
        CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(commodityId);
        return Misc.ucFirst(String.valueOf(spec.getName().toLowerCase()) + " shortage");
    }

    @Override
    public MutableStat getDemandReduction() {
        return this.demandReduction;
    }

    @Override
    public MutableStat getSupplyBonus() {
        return this.supplyBonus;
    }

    @Override
    public MutableStat getDemandReductionFromOther() {
        if (this.demandReductionFromOther == null) {
            this.demandReductionFromOther = new MutableStat(0.0f);
        }
        return this.demandReductionFromOther;
    }

    @Override
    public MutableStat getSupplyBonusFromOther() {
        if (this.supplyBonusFromOther == null) {
            this.supplyBonusFromOther = new MutableStat(0.0f);
        }
        return this.supplyBonusFromOther;
    }

    @Override
    public void init(String id, MarketAPI market) {
        this.id = id;
        this.market = market;
        this.readResolve();
    }

    protected Object readResolve() {
        MutableCommodityQuantity stat;
        this.spec = Global.getSettings().getIndustrySpec(this.id);
        if (this.buildTime < 1.0f) {
            this.buildTime = 1.0f;
        }
        this.modId = "ind_" + this.id;
        this.modIds = new String[10];
        int i = 0;
        while (i < this.modIds.length) {
            this.modIds[i] = String.valueOf(this.modId) + "_" + i;
            ++i;
        }
        if (this.demandReduction == null) {
            this.demandReduction = new MutableStat(0.0f);
        }
        if (this.supplyBonus == null) {
            this.supplyBonus = new MutableStat(0.0f);
        }
        if (this.supply != null) {
            for (String id : new ArrayList<String>(this.supply.keySet())) {
                stat = this.supply.get(id);
                stat.getQuantity().unmodifyFlat("ind_sb");
            }
        }
        if (this.demand != null) {
            for (String id : new ArrayList<String>(this.demand.keySet())) {
                stat = this.demand.get(id);
                stat.getQuantity().unmodifyFlat("ind_dr");
            }
        }
        return this;
    }

    protected Object writeReplace() {
        this.clearUnmodified();
        return this;
    }

    public void apply(boolean withIncomeUpdate) {
        InstallableItemEffect effect;
        this.updateSupplyAndDemandModifiers();
        if (withIncomeUpdate) {
            this.updateIncomeAndUpkeep();
        }
        this.applyAICoreModifiers();
        this.applyImproveModifiers();
        if (this instanceof MarketImmigrationModifier) {
            this.market.addTransientImmigrationModifier((MarketImmigrationModifier)((Object)this));
        }
        if (this.special != null && (effect = ItemEffectsRepo.ITEM_EFFECTS.get(this.special.getId())) != null) {
            List<String> unmet = effect.getUnmetRequirements(this);
            if (unmet == null || unmet.isEmpty()) {
                effect.apply(this);
            } else {
                effect.unapply(this);
            }
        }
    }

    @Override
    public void unapply() {
        InstallableItemEffect effect;
        this.applyNoAICoreModifiers();
        Boolean wasImproved = this.improved;
        this.improved = null;
        this.applyImproveModifiers();
        this.improved = wasImproved;
        if (this instanceof MarketImmigrationModifier) {
            this.market.removeTransientImmigrationModifier((MarketImmigrationModifier)((Object)this));
        }
        if (this.special != null && (effect = ItemEffectsRepo.ITEM_EFFECTS.get(this.special.getId())) != null) {
            effect.unapply(this);
        }
    }

    protected void applyAICoreModifiers() {
        if (this.aiCoreId == null) {
            this.applyNoAICoreModifiers();
            return;
        }
        boolean alpha = this.aiCoreId.equals("alpha_core");
        boolean beta = this.aiCoreId.equals("beta_core");
        boolean gamma = this.aiCoreId.equals("gamma_core");
        if (alpha) {
            this.applyAlphaCoreModifiers();
        } else if (beta) {
            this.applyBetaCoreModifiers();
        } else if (gamma) {
            this.applyGammaCoreModifiers();
        }
    }

    protected void applyAlphaCoreModifiers() {
    }

    protected void applyBetaCoreModifiers() {
    }

    protected void applyGammaCoreModifiers() {
    }

    protected void applyNoAICoreModifiers() {
    }

    protected String getModId() {
        return this.modId;
    }

    protected String getModId(int index) {
        return this.modIds[index];
    }

    public void demand(String commodityId, int quantity) {
        this.demand(0, commodityId, quantity, BASE_VALUE_TEXT);
    }

    public void demand(String commodityId, int quantity, String desc) {
        this.demand(0, commodityId, quantity, desc);
    }

    public void demand(int index, String commodityId, int quantity, String desc) {
        this.demand(this.getModId(index), commodityId, quantity, desc);
    }

    public void demand(String modId, String commodityId, int quantity, String desc) {
        if (quantity == 0) {
            this.getDemand(commodityId).getQuantity().unmodifyFlat(modId);
        } else {
            this.getDemand(commodityId).getQuantity().modifyFlat(modId, quantity, desc);
        }
        if (quantity > 0) {
            if (!this.demandReduction.isUnmodified()) {
                this.getDemand(commodityId).getQuantity().modifyFlat("ind_dr", -this.demandReduction.getModifiedInt());
            } else {
                this.getDemand(commodityId).getQuantity().unmodifyFlat("ind_dr");
            }
        }
    }

    public void supply(String commodityId, int quantity) {
        this.supply(0, commodityId, quantity, BASE_VALUE_TEXT);
    }

    public void supply(String commodityId, int quantity, String desc) {
        this.supply(0, commodityId, quantity, desc);
    }

    public void supply(int index, String commodityId, int quantity, String desc) {
        this.supply(this.getModId(index), commodityId, quantity, desc);
    }

    @Override
    public void supply(String modId, String commodityId, int quantity, String desc) {
        if (quantity == 0) {
            this.getSupply(commodityId).getQuantity().unmodifyFlat(modId);
        } else {
            this.getSupply(commodityId).getQuantity().modifyFlat(modId, quantity, desc);
        }
        if (quantity > 0) {
            if (!this.supplyBonus.isUnmodified()) {
                this.getSupply(commodityId).getQuantity().modifyFlat("ind_sb", this.supplyBonus.getModifiedInt());
            } else {
                this.getSupply(commodityId).getQuantity().unmodifyFlat("ind_sb");
            }
        }
    }

    protected void applyDeficitToProduction(int index, Pair<String, Integer> deficit, String ... commodities) {
        String[] stringArray = commodities;
        int n = commodities.length;
        int n2 = 0;
        while (n2 < n) {
            String commodity = stringArray[n2];
            if (!this.getSupply(commodity).getQuantity().isUnmodified()) {
                this.supply(index, commodity, -((Integer)deficit.two).intValue(), BaseIndustry.getDeficitText((String)deficit.one));
            }
            ++n2;
        }
    }

    @Override
    public void updateIncomeAndUpkeep() {
        this.applyIncomeAndUpkeep(-1.0f);
    }

    protected void applyIncomeAndUpkeep(float sizeOverride) {
        float size = this.market.getSize();
        if (sizeOverride >= 0.0f) {
            size = sizeOverride;
        }
        float sizeMult = BaseIndustry.getSizeMult(size);
        sizeMult = Math.max(1.0f, sizeMult - 2.0f);
        float stabilityMult = this.market.getIncomeMult().getModifiedValue();
        float upkeepMult = this.market.getUpkeepMult().getModifiedValue();
        int income = (int)(this.getSpec().getIncome() * sizeMult);
        if (income != 0) {
            this.getIncome().modifyFlatAlways("ind_base", income, "Base value");
            this.getIncome().modifyMultAlways("ind_stability", stabilityMult, "Market income multiplier");
        } else {
            this.getIncome().unmodifyFlat("ind_base");
            this.getIncome().unmodifyMult("ind_stability");
        }
        int upkeep = (int)(this.getSpec().getUpkeep() * sizeMult);
        if (upkeep != 0) {
            this.getUpkeep().modifyFlatAlways("ind_base", upkeep, "Base value");
            this.getUpkeep().modifyMultAlways("ind_hazard", upkeepMult, "Market upkeep multiplier");
        } else {
            this.getUpkeep().unmodifyFlat("ind_base");
            this.getUpkeep().unmodifyMult("ind_hazard");
        }
        this.applyAICoreToIncomeAndUpkeep();
        if (!this.isFunctional()) {
            this.getIncome().unmodifyFlat("ind_base");
            this.getIncome().unmodifyMult("ind_stability");
        }
    }

    @Override
    public float getBuildTime() {
        return this.getSpec().getBuildTime();
    }

    public Float getBuildCostOverride() {
        return this.buildCostOverride;
    }

    public void setBuildCostOverride(float buildCostOverride) {
        this.buildCostOverride = Float.valueOf(buildCostOverride);
    }

    @Override
    public float getBuildCost() {
        if (this.buildCostOverride != null) {
            return this.buildCostOverride.floatValue();
        }
        return this.getSpec().getCost();
    }

    @Override
    public float getBaseUpkeep() {
        float size = this.market.getSize();
        float sizeMult = BaseIndustry.getSizeMult(size);
        sizeMult = Math.max(1.0f, sizeMult - 2.0f);
        return this.getSpec().getUpkeep() * sizeMult;
    }

    @Override
    public void advance(float amount) {
        boolean disrupted = this.isDisrupted();
        if (!disrupted && this.wasDisrupted) {
            this.disruptionFinished();
        }
        this.wasDisrupted = disrupted;
        if (this.building && !disrupted) {
            float days = Global.getSector().getClock().convertToDays(amount);
            if (DebugFlags.COLONY_DEBUG) {
                days *= 100.0f;
            }
            this.buildProgress += days;
            if (this.buildProgress >= this.buildTime) {
                this.finishBuildingOrUpgrading();
            }
        }
    }

    protected void notifyDisrupted() {
    }

    protected void disruptionFinished() {
    }

    @Override
    public boolean isBuilding() {
        return this.building;
    }

    @Override
    public boolean isFunctional() {
        if (this.isDisrupted()) {
            return false;
        }
        return !this.isBuilding() || this.isUpgrading();
    }

    @Override
    public boolean isUpgrading() {
        return this.building && this.upgradeId != null;
    }

    @Override
    public float getBuildOrUpgradeProgress() {
        if (this.isDisrupted()) {
            return 0.0f;
        }
        if (!this.isBuilding()) {
            return 0.0f;
        }
        return Math.min(1.0f, this.buildProgress / this.buildTime);
    }

    @Override
    public String getBuildOrUpgradeDaysText() {
        if (this.isDisrupted()) {
            int left = (int)this.getDisruptedDays();
            if (left < 1) {
                left = 1;
            }
            String days = "days";
            if (left == 1) {
                days = "day";
            }
            return left + " " + days;
        }
        int left = (int)(this.buildTime - this.buildProgress);
        if (left < 1) {
            left = 1;
        }
        String days = "days";
        if (left == 1) {
            days = "day";
        }
        return String.valueOf(left) + " " + days;
    }

    @Override
    public String getBuildOrUpgradeProgressText() {
        if (this.isDisrupted()) {
            int left = (int)this.getDisruptedDays();
            if (left < 1) {
                left = 1;
            }
            String days = "days";
            if (left == 1) {
                days = "day";
            }
            return "Disrupted: " + left + " " + days + " left";
        }
        int left = (int)(this.buildTime - this.buildProgress);
        if (left < 1) {
            left = 1;
        }
        String days = "days";
        if (left == 1) {
            days = "day";
        }
        if (this.isUpgrading()) {
            return "Upgrading: " + left + " " + days + " left";
        }
        return "Building: " + left + " " + days + " left";
    }

    @Override
    public void startBuilding() {
        this.building = true;
        this.buildProgress = 0.0f;
        this.upgradeId = null;
        this.buildTime = this.spec.getBuildTime();
        this.unapply();
    }

    @Override
    public void finishBuildingOrUpgrading() {
        this.building = false;
        this.buildProgress = 0.0f;
        this.buildTime = 1.0f;
        if (this.upgradeId != null) {
            this.market.removeIndustry(this.getId(), null, true);
            this.market.addIndustry(this.upgradeId);
            BaseIndustry industry = (BaseIndustry)this.market.getIndustry(this.upgradeId);
            industry.setAICoreId(this.getAICoreId());
            industry.setImproved(this.isImproved());
            industry.upgradeFinished(this);
            industry.reapply();
        } else {
            this.buildingFinished();
            this.reapply();
        }
    }

    @Override
    public void startUpgrading() {
        this.building = true;
        this.buildProgress = 0.0f;
        this.upgradeId = this.getSpec().getUpgrade();
        IndustrySpecAPI upgrade = Global.getSettings().getIndustrySpec(this.upgradeId);
        this.buildTime = upgrade.getBuildTime();
    }

    @Override
    public void cancelUpgrade() {
        this.building = false;
        this.buildProgress = 0.0f;
        this.upgradeId = null;
    }

    @Override
    public void downgrade() {
        this.building = true;
        this.buildProgress = 0.0f;
        this.upgradeId = this.getSpec().getDowngrade();
        this.finishBuildingOrUpgrading();
    }

    @Override
    public void reapply() {
        this.unapply();
        this.apply();
    }

    protected void buildingFinished() {
        this.sendBuildOrUpgradeMessage();
        BaseIndustry.buildNextInQueue(this.market);
    }

    public static void buildNextInQueue(MarketAPI market) {
        Industry ind;
        ConstructionQueue.ConstructionQueueItem next = null;
        Iterator<ConstructionQueue.ConstructionQueueItem> iter = market.getConstructionQueue().getItems().iterator();
        while (iter.hasNext()) {
            next = iter.next();
            iter.remove();
            ind = market.instantiateIndustry(next.id);
            int num = Misc.getNumIndustries(market);
            int max = Misc.getMaxIndustries(market);
            if (ind.isAvailableToBuild() && (num <= max || !ind.isIndustry())) break;
            if (market.isPlayerOwned()) {
                MessageIntel intel = new MessageIntel(String.valueOf(ind.getCurrentName()) + " at " + market.getName(), Misc.getBasePlayerColor());
                intel.addLine("    - Construction aborted");
                int refund = next.cost;
                Global.getSector().getPlayerFleet().getCargo().getCredits().add(refund);
                intel.addLine("    - %s refunded", Misc.getTextColor(), new String[]{Misc.getDGSCredits(refund)}, Misc.getHighlightColor());
                intel.setIcon(Global.getSector().getPlayerFaction().getCrest());
                intel.setSound(BaseIntelPlugin.getSoundStandardUpdate());
                Global.getSector().getCampaignUI().addMessage(intel, CommMessageAPI.MessageClickAction.COLONY_INFO, market);
            }
            next = null;
        }
        if (next != null) {
            market.addIndustry(next.id);
            ind = market.getIndustry(next.id);
            ind.startBuilding();
            if (ind instanceof BaseIndustry) {
                ((BaseIndustry)ind).setBuildCostOverride(next.cost);
            }
            if (market.isPlayerOwned()) {
                MessageIntel intel = new MessageIntel(String.valueOf(ind.getCurrentName()) + " at " + market.getName(), Misc.getBasePlayerColor());
                intel.addLine("    - Construction started");
                intel.setIcon(Global.getSector().getPlayerFaction().getCrest());
                intel.setSound(BaseIntelPlugin.getSoundStandardUpdate());
                Global.getSector().getCampaignUI().addMessage(intel, CommMessageAPI.MessageClickAction.COLONY_INFO, market);
            }
        }
    }

    protected void upgradeFinished(Industry previous) {
        this.sendBuildOrUpgradeMessage();
        this.setSpecialItem(previous.getSpecialItem());
    }

    protected void sendBuildOrUpgradeMessage() {
        if (this.market.isPlayerOwned()) {
            MessageIntel intel = new MessageIntel(String.valueOf(this.getCurrentName()) + " at " + this.market.getName(), Misc.getBasePlayerColor());
            intel.addLine("    - Construction completed");
            intel.setIcon(Global.getSector().getPlayerFaction().getCrest());
            intel.setSound(BaseIntelPlugin.getSoundStandardUpdate());
            Global.getSector().getCampaignUI().addMessage(intel, CommMessageAPI.MessageClickAction.COLONY_INFO, this.market);
        }
    }

    @Override
    public void notifyBeingRemoved(MarketAPI.MarketInteractionMode mode, boolean forUpgrade) {
        CargoAPI cargo;
        if (this.aiCoreId != null && !forUpgrade && (cargo = this.getCargoForInteractionMode(mode)) != null) {
            cargo.addCommodity(this.aiCoreId, 1.0f);
        }
        if (this.special != null && !forUpgrade && (cargo = this.getCargoForInteractionMode(mode)) != null) {
            cargo.addSpecial(this.special, 1.0f);
        }
    }

    protected CargoAPI getCargoForInteractionMode(MarketAPI.MarketInteractionMode mode) {
        CargoAPI cargo = null;
        if (mode == null) {
            return null;
        }
        cargo = mode == MarketAPI.MarketInteractionMode.REMOTE ? Misc.getStorageCargo(this.market) : Global.getSector().getPlayerFleet().getCargo();
        return cargo;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IndustrySpecAPI getSpec() {
        if (this.spec == null) {
            this.spec = Global.getSettings().getIndustrySpec(this.id);
        }
        return this.spec;
    }

    public void clearUnmodified() {
        MutableCommodityQuantity stat;
        if (this.supply != null) {
            for (String id : new ArrayList<String>(this.supply.keySet())) {
                stat = this.supply.get(id);
                if (stat == null || !stat.getQuantity().isUnmodified() && !(stat.getQuantity().getModifiedValue() <= 0.0f)) continue;
                this.supply.remove(id);
            }
        }
        if (this.demand != null) {
            for (String id : new ArrayList<String>(this.demand.keySet())) {
                stat = this.demand.get(id);
                if (stat == null || !stat.getQuantity().isUnmodified() && !(stat.getQuantity().getModifiedValue() <= 0.0f)) continue;
                this.demand.remove(id);
            }
        }
    }

    @Override
    public List<MutableCommodityQuantity> getAllDemand() {
        ArrayList<MutableCommodityQuantity> result = new ArrayList<MutableCommodityQuantity>();
        for (MutableCommodityQuantity q : this.demand.values()) {
            if (!(q.getQuantity().getModifiedValue() > 0.0f)) continue;
            result.add(q);
        }
        return result;
    }

    @Override
    public List<MutableCommodityQuantity> getAllSupply() {
        ArrayList<MutableCommodityQuantity> result = new ArrayList<MutableCommodityQuantity>();
        for (MutableCommodityQuantity q : this.supply.values()) {
            if (!(q.getQuantity().getModifiedValue() > 0.0f)) continue;
            result.add(q);
        }
        return result;
    }

    @Override
    public MutableCommodityQuantity getSupply(String id) {
        MutableCommodityQuantity stat = this.supply.get(id);
        if (stat == null) {
            stat = new MutableCommodityQuantity(id);
            this.supply.put(id, stat);
        }
        return stat;
    }

    @Override
    public MutableCommodityQuantity getDemand(String id) {
        MutableCommodityQuantity stat = this.demand.get(id);
        if (stat == null) {
            stat = new MutableCommodityQuantity(id);
            this.demand.put(id, stat);
        }
        return stat;
    }

    @Override
    public MutableStat getIncome() {
        return this.income;
    }

    @Override
    public MutableStat getUpkeep() {
        return this.upkeep;
    }

    @Override
    public MarketAPI getMarket() {
        return this.market;
    }

    @Override
    public Pair<String, Integer> getMaxDeficit(String ... commodityIds) {
        Pair<String, Integer> result = new Pair<String, Integer>();
        result.two = 0;
        String[] stringArray = commodityIds;
        int n = commodityIds.length;
        int n2 = 0;
        while (n2 < n) {
            CommodityOnMarketAPI com;
            int available;
            String id = stringArray[n2];
            int demand = (int)this.getDemand(id).getQuantity().getModifiedValue();
            int deficit = Math.max(demand - (available = (com = this.market.getCommodityData(id)).getAvailable()), 0);
            if (deficit > (Integer)result.two) {
                result.one = id;
                result.two = deficit;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public List<Pair<String, Integer>> getAllDeficit() {
        ArrayList<String> commodities = new ArrayList<String>();
        for (MutableCommodityQuantity curr : this.demand.values()) {
            commodities.add(curr.getCommodityId());
        }
        return this.getAllDeficit(commodities.toArray(new String[0]));
    }

    @Override
    public List<Pair<String, Integer>> getAllDeficit(String ... commodityIds) {
        ArrayList<Pair<String, Integer>> result = new ArrayList<Pair<String, Integer>>();
        String[] stringArray = commodityIds;
        int n = commodityIds.length;
        int n2 = 0;
        while (n2 < n) {
            CommodityOnMarketAPI com;
            int available;
            String id = stringArray[n2];
            int demand = (int)this.getDemand(id).getQuantity().getModifiedValue();
            int deficit = Math.max(demand - (available = (com = this.market.getCommodityData(id)).getAvailable()), 0);
            if (deficit > 0) {
                Pair curr = new Pair();
                curr.one = id;
                curr.two = deficit;
                result.add(curr);
            }
            ++n2;
        }
        return result;
    }

    public float getSizeMult() {
        return BaseIndustry.getSizeMult(this.market.getSize());
    }

    public static float getCommodityEconUnitMult(float size) {
        if (size <= 0.0f) {
            return 0.0f;
        }
        return 1.0f;
    }

    public static float getSizeMult(float size) {
        if (size <= 0.0f) {
            return 0.0f;
        }
        return size;
    }

    @Override
    public void doPreSaveCleanup() {
        this.supply = null;
        this.demand = null;
        this.income = null;
        this.upkeep = null;
    }

    @Override
    public void doPostSaveRestore() {
        this.supply = new LinkedHashMap<String, MutableCommodityQuantity>();
        this.demand = new LinkedHashMap<String, MutableCommodityQuantity>();
        this.income = new MutableStat(0.0f);
        this.upkeep = new MutableStat(0.0f);
    }

    @Override
    public String getCurrentImage() {
        return this.getSpec().getImageName();
    }

    @Override
    public String getCurrentName() {
        return this.getSpec().getName();
    }

    @Override
    public boolean isAvailableToBuild() {
        if (this.market.hasTag("market_no_industries_allowed")) {
            return false;
        }
        return this.market.hasIndustry("population") && !this.getId().equals("population");
    }

    @Override
    public boolean showWhenUnavailable() {
        return !this.market.hasTag("market_no_industries_allowed");
    }

    @Override
    public String getUnavailableReason() {
        return "Can not be built";
    }

    @Override
    public boolean isTooltipExpandable() {
        return false;
    }

    @Override
    public float getTooltipWidth() {
        return 400.0f;
    }

    @Override
    public void createTooltip(Industry.IndustryTooltipMode mode, TooltipMakerAPI tooltip, boolean expanded) {
        boolean category;
        String reason;
        int left;
        boolean needToAddIndustry;
        this.currTooltipMode = mode;
        float pad = 3.0f;
        float opad = 10.0f;
        FactionAPI faction = this.market.getFaction();
        Color color = faction.getBaseUIColor();
        Color dark = faction.getDarkUIColor();
        Color grid = faction.getGridUIColor();
        Color bright = faction.getBrightUIColor();
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        MarketAPI copy = this.market.clone();
        copy.setSuppressedConditions(this.market.getSuppressedConditions());
        copy.setRetainSuppressedConditionsSetWhenEmpty(true);
        this.market.setRetainSuppressedConditionsSetWhenEmpty(true);
        MarketAPI orig = this.market;
        this.market = copy;
        boolean bl = needToAddIndustry = !this.market.hasIndustry(this.getId());
        if (needToAddIndustry) {
            this.market.getIndustries().add(this);
        }
        if (mode != Industry.IndustryTooltipMode.NORMAL) {
            this.market.clearCommodities();
            for (CommodityOnMarketAPI curr : this.market.getAllCommodities()) {
                curr.getAvailableStat().setBaseValue(100.0f);
            }
        }
        this.market.reapplyConditions();
        this.reapply();
        String type = "";
        if (this.isIndustry()) {
            type = " - Industry";
        }
        if (this.isStructure()) {
            type = " - Structure";
        }
        tooltip.addTitle(String.valueOf(this.getCurrentName()) + type, color);
        String desc = this.spec.getDesc();
        String override = this.getDescriptionOverride();
        if (override != null) {
            desc = override;
        }
        desc = Global.getSector().getRules().performTokenReplacement(null, desc, this.market.getPrimaryEntity(), null);
        tooltip.addPara(desc, opad);
        if (this.isIndustry() && (mode == Industry.IndustryTooltipMode.ADD_INDUSTRY || mode == Industry.IndustryTooltipMode.UPGRADE || mode == Industry.IndustryTooltipMode.DOWNGRADE)) {
            int num = Misc.getNumIndustries(this.market);
            int max = Misc.getMaxIndustries(this.market);
            if (this.isIndustry()) {
                if (mode == Industry.IndustryTooltipMode.UPGRADE) {
                    for (Industry curr : this.market.getIndustries()) {
                        if (!this.getSpec().getId().equals(curr.getSpec().getUpgrade())) continue;
                        if (!curr.isIndustry()) break;
                        --num;
                        break;
                    }
                } else if (mode == Industry.IndustryTooltipMode.DOWNGRADE) {
                    for (Industry curr : this.market.getIndustries()) {
                        if (!this.getSpec().getId().equals(curr.getSpec().getDowngrade())) continue;
                        if (!curr.isIndustry()) break;
                        --num;
                        break;
                    }
                }
            }
            Color c = gray;
            c = Misc.getTextColor();
            Color h1 = highlight;
            Color h2 = highlight;
            if (num > max) {
                h1 = bad;
                --num;
                tooltip.addPara("Maximum number of industries reached", bad, opad);
            }
        }
        this.addRightAfterDescriptionSection(tooltip, mode);
        if (this.isDisrupted()) {
            left = (int)this.getDisruptedDays();
            if (left < 1) {
                left = 1;
            }
            String days = "days";
            if (left == 1) {
                days = "day";
            }
            tooltip.addPara("Operations disrupted! %s " + days + " until return to normal function.", opad, Misc.getNegativeHighlightColor(), highlight, "" + left);
        }
        if ((DebugFlags.COLONY_DEBUG || this.market.isPlayerOwned()) && mode == Industry.IndustryTooltipMode.NORMAL) {
            if (this.getSpec().getUpgrade() != null && !this.isBuilding()) {
                tooltip.addPara("Click to manage or upgrade", Misc.getPositiveHighlightColor(), opad);
            } else {
                tooltip.addPara("Click to manage", Misc.getPositiveHighlightColor(), opad);
            }
        }
        if (mode == Industry.IndustryTooltipMode.QUEUED) {
            tooltip.addPara("Click to remove or adjust position in queue", Misc.getPositiveHighlightColor(), opad);
            tooltip.addPara("Currently queued for construction. Does not have any impact on the colony.", opad);
            left = (int)this.getSpec().getBuildTime();
            if (left < 1) {
                left = 1;
            }
            String days = "days";
            if (left == 1) {
                days = "day";
            }
            tooltip.addPara("Requires %s " + days + " to build.", opad, highlight, "" + left);
        } else if (!this.isFunctional() && mode == Industry.IndustryTooltipMode.NORMAL) {
            tooltip.addPara("Currently under construction and not producing anything or providing other benefits.", opad);
            left = (int)(this.buildTime - this.buildProgress);
            if (left < 1) {
                left = 1;
            }
            String days = "days";
            if (left == 1) {
                days = "day";
            }
            tooltip.addPara("Requires %s more " + days + " to finish building.", opad, highlight, "" + left);
        }
        if (!(this.isAvailableToBuild() || mode != Industry.IndustryTooltipMode.ADD_INDUSTRY && mode != Industry.IndustryTooltipMode.UPGRADE && mode != Industry.IndustryTooltipMode.DOWNGRADE || (reason = this.getUnavailableReason()) == null)) {
            tooltip.addPara(reason, bad, opad);
        }
        if (!(category = this.getSpec().hasTag("parent_item"))) {
            int qty;
            int credits = (int)Global.getSector().getPlayerFleet().getCargo().getCredits().get();
            String creditsStr = Misc.getDGSCredits(credits);
            if (mode == Industry.IndustryTooltipMode.UPGRADE || mode == Industry.IndustryTooltipMode.ADD_INDUSTRY) {
                int cost = (int)this.getBuildCost();
                String costStr = Misc.getDGSCredits(cost);
                int days = (int)this.getBuildTime();
                String daysStr = "days";
                if (days == 1) {
                    daysStr = "day";
                }
                LabelAPI label = null;
                label = mode == Industry.IndustryTooltipMode.UPGRADE ? tooltip.addPara("%s and %s " + daysStr + " to upgrade. You have %s.", opad, highlight, costStr, "" + days, creditsStr) : tooltip.addPara("%s and %s " + daysStr + " to build. You have %s.", opad, highlight, costStr, "" + days, creditsStr);
                label.setHighlight(costStr, "" + days, creditsStr);
                if (credits >= cost) {
                    label.setHighlightColors(highlight, highlight, highlight);
                } else {
                    label.setHighlightColors(bad, highlight, highlight);
                }
            } else if (mode == Industry.IndustryTooltipMode.DOWNGRADE && this.getSpec().getUpgrade() != null) {
                float refundFraction = Global.getSettings().getFloat("industryRefundFraction");
                IndustrySpecAPI spec = Global.getSettings().getIndustrySpec(this.getSpec().getUpgrade());
                int cost = (int)(spec.getCost() * refundFraction);
                String refundStr = Misc.getDGSCredits(cost);
                tooltip.addPara("%s refunded for downgrade.", opad, highlight, refundStr);
            }
            this.addPostDescriptionSection(tooltip, mode);
            if (!this.getIncome().isUnmodified()) {
                int income = this.getIncome().getModifiedInt();
                tooltip.addPara("Monthly income: %s", opad, highlight, Misc.getDGSCredits(income));
                tooltip.addStatModGrid(250.0f, 65.0f, 10.0f, pad, this.getIncome(), true, new TooltipMakerAPI.StatModValueGetter(){

                    public String getPercentValue(MutableStat.StatMod mod) {
                        return null;
                    }

                    public String getMultValue(MutableStat.StatMod mod) {
                        return null;
                    }

                    public Color getModColor(MutableStat.StatMod mod) {
                        return null;
                    }

                    public String getFlatValue(MutableStat.StatMod mod) {
                        return String.valueOf(Misc.getWithDGS(mod.value)) + "\u00a2";
                    }
                });
            }
            if (!this.getUpkeep().isUnmodified()) {
                int upkeep = this.getUpkeep().getModifiedInt();
                tooltip.addPara("Monthly upkeep: %s", opad, highlight, Misc.getDGSCredits(upkeep));
                tooltip.addStatModGrid(250.0f, 65.0f, 10.0f, pad, this.getUpkeep(), true, new TooltipMakerAPI.StatModValueGetter(){

                    public String getPercentValue(MutableStat.StatMod mod) {
                        return null;
                    }

                    public String getMultValue(MutableStat.StatMod mod) {
                        return null;
                    }

                    public Color getModColor(MutableStat.StatMod mod) {
                        return null;
                    }

                    public String getFlatValue(MutableStat.StatMod mod) {
                        return String.valueOf(Misc.getWithDGS(mod.value)) + "\u00a2";
                    }
                });
            }
            this.addPostUpkeepSection(tooltip, mode);
            boolean hasSupply = false;
            for (MutableCommodityQuantity curr : this.supply.values()) {
                int qty2 = curr.getQuantity().getModifiedInt();
                if (qty2 <= 0) continue;
                hasSupply = true;
                break;
            }
            boolean hasDemand = false;
            for (MutableCommodityQuantity curr : this.demand.values()) {
                int qty3 = curr.getQuantity().getModifiedInt();
                if (qty3 <= 0) continue;
                hasDemand = true;
                break;
            }
            float maxIconsPerRow = 10.0f;
            if (hasSupply) {
                tooltip.addSectionHeading("Production", color, dark, Alignment.MID, opad);
                tooltip.beginIconGroup();
                tooltip.setIconSpacingMedium();
                float icons = 0.0f;
                for (MutableCommodityQuantity curr : this.supply.values()) {
                    qty = curr.getQuantity().getModifiedInt();
                    int normal = qty;
                    if (normal > 0) {
                        tooltip.addIcons(this.market.getCommodityData(curr.getCommodityId()), normal, IconRenderMode.NORMAL);
                    }
                    int plus = 0;
                    int minus = 0;
                    for (MutableStat.StatMod mod : curr.getQuantity().getFlatMods().values()) {
                        if (mod.value > 0.0f) {
                            plus += (int)mod.value;
                            continue;
                        }
                        if (mod.desc == null || !mod.desc.contains("shortage")) continue;
                        minus += (int)Math.abs(mod.value);
                    }
                    if ((minus = Math.min(minus, plus)) > 0 && mode == Industry.IndustryTooltipMode.NORMAL) {
                        tooltip.addIcons(this.market.getCommodityData(curr.getCommodityId()), minus, IconRenderMode.DIM_RED);
                    }
                    icons += (float)(normal + Math.max(0, minus));
                }
                int rows = (int)Math.ceil(icons / maxIconsPerRow);
                rows = 3;
                tooltip.addIconGroup(32.0f, rows, opad);
            }
            this.addPostSupplySection(tooltip, hasSupply, mode);
            if (hasDemand || this.hasPostDemandSection(hasDemand, mode)) {
                tooltip.addSectionHeading("Demand & effects", color, dark, Alignment.MID, opad);
            }
            if (hasDemand) {
                tooltip.beginIconGroup();
                tooltip.setIconSpacingMedium();
                float icons = 0.0f;
                for (MutableCommodityQuantity curr : this.demand.values()) {
                    qty = curr.getQuantity().getModifiedInt();
                    if (qty <= 0) continue;
                    CommodityOnMarketAPI com = orig.getCommodityData(curr.getCommodityId());
                    int available = com.getAvailable();
                    int normal = Math.min(available, qty);
                    int red = Math.max(0, qty - available);
                    if (mode != Industry.IndustryTooltipMode.NORMAL) {
                        normal = qty;
                        red = 0;
                    }
                    if (normal > 0) {
                        tooltip.addIcons(com, normal, IconRenderMode.NORMAL);
                    }
                    if (red > 0) {
                        tooltip.addIcons(com, red, IconRenderMode.DIM_RED);
                    }
                    icons += (float)(normal + Math.max(0, red));
                }
                int rows = (int)Math.ceil(icons / maxIconsPerRow);
                rows = 3;
                rows = 1;
                tooltip.addIconGroup(32.0f, rows, opad);
            }
            this.addPostDemandSection(tooltip, hasDemand, mode);
            if (!needToAddIndustry) {
                this.addInstalledItemsSection(mode, tooltip, expanded);
                this.addImprovedSection(mode, tooltip, expanded);
                ListenerUtil.addToIndustryTooltip(this, mode, tooltip, this.getTooltipWidth(), expanded);
            }
            tooltip.addPara("*Shown production and demand values are already adjusted based on current market size and local conditions.", gray, opad);
        }
        if (needToAddIndustry) {
            this.unapply();
            this.market.getIndustries().remove(this);
        }
        this.market = orig;
        this.market.setRetainSuppressedConditionsSetWhenEmpty(null);
        if (!needToAddIndustry) {
            this.reapply();
        }
    }

    public void addInstalledItemsSection(Industry.IndustryTooltipMode mode, TooltipMakerAPI tooltip, boolean expanded) {
        float opad = 10.0f;
        FactionAPI faction = this.market.getFaction();
        Color color = faction.getBaseUIColor();
        Color dark = faction.getDarkUIColor();
        LabelAPI heading = tooltip.addSectionHeading("Items", color, dark, Alignment.MID, opad);
        boolean addedSomething = false;
        if (this.aiCoreId != null) {
            Industry.AICoreDescriptionMode aiCoreDescMode = Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP;
            this.addAICoreSection(tooltip, this.aiCoreId, aiCoreDescMode);
            addedSomething = true;
        }
        if (!(addedSomething |= this.addNonAICoreInstalledItems(mode, tooltip, expanded))) {
            heading.setText("No items installed");
        }
    }

    protected boolean addNonAICoreInstalledItems(Industry.IndustryTooltipMode mode, TooltipMakerAPI tooltip, boolean expanded) {
        if (this.special == null) {
            return false;
        }
        float opad = 10.0f;
        SpecialItemSpecAPI spec = Global.getSettings().getSpecialItemSpec(this.special.getId());
        TooltipMakerAPI text = tooltip.beginImageWithText(spec.getIconName(), 48.0f);
        InstallableItemEffect effect = ItemEffectsRepo.ITEM_EFFECTS.get(this.special.getId());
        effect.addItemDescription(this, text, this.special, InstallableIndustryItemPlugin.InstallableItemDescriptionMode.INDUSTRY_TOOLTIP);
        tooltip.addImageWithText(opad);
        return true;
    }

    @Override
    public List<SpecialItemData> getVisibleInstalledItems() {
        ArrayList<SpecialItemData> result = new ArrayList<SpecialItemData>();
        if (this.special != null) {
            result.add(this.special);
        }
        return result;
    }

    @Override
    public boolean wantsToUseSpecialItem(SpecialItemData data) {
        if (this.special != null) {
            return false;
        }
        SpecialItemSpecAPI spec = Global.getSettings().getSpecialItemSpec(data.getId());
        String[] industries = spec.getParams().split(",");
        HashSet<String> all = new HashSet<String>();
        String[] stringArray = industries;
        int n = industries.length;
        int n2 = 0;
        while (n2 < n) {
            String ind = stringArray[n2];
            all.add(ind.trim());
            ++n2;
        }
        return all.contains(this.getId());
    }

    @Override
    public void addAICoreSection(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        this.addAICoreSection(tooltip, this.aiCoreId, mode);
    }

    @Override
    public void addAICoreSection(TooltipMakerAPI tooltip, String coreId, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        FactionAPI faction = this.market.getFaction();
        Color color = faction.getBaseUIColor();
        Color dark = faction.getDarkUIColor();
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_TOOLTIP && coreId == null) {
            tooltip.addPara("No AI core currently assigned. Click to assign an AI core from your cargo.", opad);
            return;
        }
        boolean alpha = coreId.equals("alpha_core");
        boolean beta = coreId.equals("beta_core");
        boolean gamma = coreId.equals("gamma_core");
        if (alpha) {
            this.addAlphaCoreDescription(tooltip, mode);
        } else if (beta) {
            this.addBetaCoreDescription(tooltip, mode);
        } else if (gamma) {
            this.addGammaCoreDescription(tooltip, mode);
        } else {
            this.addUnknownCoreDescription(coreId, tooltip, mode);
        }
    }

    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "Alpha-level AI core currently assigned. ";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "Alpha-level AI core. ";
        }
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP || mode == Industry.AICoreDescriptionMode.MANAGE_CORE_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases production by %s unit.", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, "" + SUPPLY_BONUS);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases production by %s unit.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, "" + SUPPLY_BONUS);
    }

    protected void addBetaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "Beta-level AI core currently assigned. ";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "Beta-level AI core. ";
        }
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP || mode == Industry.AICoreDescriptionMode.MANAGE_CORE_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION);
    }

    protected void addGammaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "Gamma-level AI core currently assigned. ";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "Gamma-level AI core. ";
        }
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP || mode == Industry.AICoreDescriptionMode.MANAGE_CORE_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "Reduces demand by %s unit.", opad, highlight, "" + DEMAND_REDUCTION);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "Reduces demand by %s unit.", opad, highlight, "" + DEMAND_REDUCTION);
    }

    protected void addUnknownCoreDescription(String coreId, TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        CommoditySpecAPI core = Global.getSettings().getCommoditySpec(coreId);
        if (core == null) {
            return;
        }
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = String.valueOf(core.getName()) + " currently assigned. ";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = String.valueOf(core.getName()) + ". ";
        }
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP || mode == Industry.AICoreDescriptionMode.MANAGE_CORE_TOOLTIP) {
            TooltipMakerAPI text = tooltip.beginImageWithText(core.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "No effect.", opad);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "No effect.", opad);
    }

    protected void addPostSupplySection(TooltipMakerAPI tooltip, boolean hasSupply, Industry.IndustryTooltipMode mode) {
    }

    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
    }

    protected void addRightAfterDescriptionSection(TooltipMakerAPI tooltip, Industry.IndustryTooltipMode mode) {
    }

    protected void addPostDescriptionSection(TooltipMakerAPI tooltip, Industry.IndustryTooltipMode mode) {
    }

    protected void addPostUpkeepSection(TooltipMakerAPI tooltip, Industry.IndustryTooltipMode mode) {
    }

    @Override
    public String getAICoreId() {
        return this.aiCoreId;
    }

    @Override
    public void setAICoreId(String aiCoreId) {
        this.aiCoreId = aiCoreId;
    }

    protected void applyAICoreToIncomeAndUpkeep() {
        if (this.aiCoreId == null || "gamma_core".equals(this.aiCoreId)) {
            this.getUpkeep().unmodifyMult("ind_core");
            return;
        }
        float mult = UPKEEP_MULT;
        String name = "AI Core assigned";
        if (this.aiCoreId.equals("alpha_core")) {
            name = "Alpha Core assigned";
        } else if (this.aiCoreId.equals("beta_core")) {
            name = "Beta Core assigned";
        } else if (this.aiCoreId.equals("gamma_core")) {
            name = "Gamma Core assigned";
        }
        this.getUpkeep().modifyMult("ind_core", mult, name);
    }

    protected void updateAICoreToSupplyAndDemandModifiers() {
        if (this.aiCoreId == null) {
            return;
        }
        boolean alpha = this.aiCoreId.equals("alpha_core");
        boolean beta = this.aiCoreId.equals("beta_core");
        boolean gamma = this.aiCoreId.equals("gamma_core");
        if (alpha) {
            this.applyAlphaCoreSupplyAndDemandModifiers();
        } else if (beta) {
            this.applyBetaCoreSupplyAndDemandModifiers();
        } else if (gamma) {
            this.applyGammaCoreSupplyAndDemandModifiers();
        }
    }

    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.supplyBonus.modifyFlat(this.getModId(0), SUPPLY_BONUS, "Alpha core");
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "Alpha core");
    }

    protected void applyBetaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "Beta core");
    }

    protected void applyGammaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "Gamma core");
    }

    protected void updateSupplyAndDemandModifiers() {
        this.supplyBonus.unmodify();
        this.demandReduction.unmodify();
        this.updateAICoreToSupplyAndDemandModifiers();
        this.updateImprovementSupplyAndDemandModifiers();
        this.supplyBonus.modifyFlat(this.getModId(1), this.market.getAdmin().getStats().getDynamic().getValue("supply_bonus", 0.0f), "Administrator");
        this.demandReduction.modifyFlat(this.getModId(1), this.market.getAdmin().getStats().getDynamic().getValue("demand_reduction", 0.0f), "Administrator");
        if (this.supplyBonusFromOther != null) {
            this.supplyBonus.applyMods(this.supplyBonusFromOther);
        }
        if (this.demandReductionFromOther != null) {
            this.demandReduction.applyMods(this.demandReductionFromOther);
        }
    }

    @Override
    public boolean showShutDown() {
        return true;
    }

    @Override
    public boolean canShutDown() {
        return true;
    }

    @Override
    public String getCanNotShutDownReason() {
        return null;
    }

    @Override
    public boolean canUpgrade() {
        return true;
    }

    @Override
    public boolean canDowngrade() {
        return true;
    }

    protected String getDescriptionOverride() {
        return null;
    }

    @Override
    public String getNameForModifier() {
        return Misc.ucFirst(this.getCurrentName().toLowerCase());
    }

    @Override
    public boolean isDemandLegal(CommodityOnMarketAPI com) {
        return !com.isIllegal();
    }

    @Override
    public boolean isSupplyLegal(CommodityOnMarketAPI com) {
        return !com.isIllegal();
    }

    protected boolean isAICoreId(String str) {
        HashSet<String> cores = new HashSet<String>();
        cores.add("alpha_core");
        cores.add("beta_core");
        cores.add("gamma_core");
        return cores.contains(str);
    }

    @Override
    public void initWithParams(List<String> params) {
        for (String str : params) {
            if (!this.isAICoreId(str)) continue;
            this.setAICoreId(str);
            break;
        }
        for (String str : params) {
            SpecialItemSpecAPI spec = Global.getSettings().getSpecialItemSpec(str);
            if (spec == null) continue;
            String[] industries = spec.getParams().split(",");
            HashSet<String> all = new HashSet<String>();
            String[] stringArray = industries;
            int n = industries.length;
            int n2 = 0;
            while (n2 < n) {
                String ind = stringArray[n2];
                all.add(ind.trim());
                ++n2;
            }
            if (!all.contains(this.getId())) continue;
            this.setSpecialItem(new SpecialItemData(str, null));
        }
    }

    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return false;
    }

    protected int getBaseStabilityMod() {
        return 0;
    }

    protected void modifyStabilityWithBaseMod() {
        int stabilityMod = this.getBaseStabilityMod();
        int stabilityPenalty = this.getStabilityPenalty();
        if (stabilityPenalty > stabilityMod) {
            stabilityPenalty = stabilityMod;
        }
        if ((stabilityMod -= stabilityPenalty) > 0) {
            this.market.getStability().modifyFlat(this.getModId(), stabilityMod, this.getNameForModifier());
        }
    }

    protected void unmodifyStabilityWithBaseMod() {
        this.market.getStability().unmodifyFlat(this.getModId());
    }

    protected Pair<String, Integer> getStabilityAffectingDeficit() {
        return new Pair<String, Integer>("supplies", 0);
    }

    protected int getStabilityPenalty() {
        float deficit = ((Integer)this.getStabilityAffectingDeficit().two).intValue();
        if (deficit < 0.0f) {
            deficit = 0.0f;
        }
        return Math.round(deficit);
    }

    protected void addStabilityPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        Color h = Misc.getHighlightColor();
        float opad = 10.0f;
        MutableStat fake = new MutableStat(0.0f);
        int stabilityMod = this.getBaseStabilityMod();
        int stabilityPenalty = this.getStabilityPenalty();
        if (stabilityPenalty > stabilityMod) {
            stabilityPenalty = stabilityMod;
        }
        String str = BaseIndustry.getDeficitText((String)this.getStabilityAffectingDeficit().one);
        fake.modifyFlat("1", stabilityMod, this.getNameForModifier());
        if (stabilityPenalty != 0) {
            fake.modifyFlat("2", -stabilityPenalty, str);
        }
        int total = stabilityMod - stabilityPenalty;
        String totalStr = "+" + total;
        if (total < 0) {
            totalStr = "" + total;
            h = Misc.getNegativeHighlightColor();
        }
        float pad = 3.0f;
        if (total >= 0) {
            tooltip.addPara("Stability bonus: %s", opad, h, totalStr);
        } else {
            tooltip.addPara("Stability penalty: %s", opad, h, totalStr);
        }
        tooltip.addStatModGrid(400.0f, 35.0f, opad, pad, fake, new TooltipMakerAPI.StatModValueGetter(){

            public String getPercentValue(MutableStat.StatMod mod) {
                return null;
            }

            public String getMultValue(MutableStat.StatMod mod) {
                return null;
            }

            public Color getModColor(MutableStat.StatMod mod) {
                if (mod.value < 0.0f) {
                    return Misc.getNegativeHighlightColor();
                }
                return null;
            }

            public String getFlatValue(MutableStat.StatMod mod) {
                return null;
            }
        });
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hiddenOverride = hidden ? Boolean.valueOf(true) : null;
    }

    @Override
    public boolean isHidden() {
        if (this.hiddenOverride != null) {
            return this.hiddenOverride;
        }
        return false;
    }

    public String getDisruptedKey() {
        if (this.dKey != null) {
            return this.dKey;
        }
        this.dKey = "$core_disrupted_" + this.getClass().getSimpleName();
        return this.dKey;
    }

    @Override
    public void setDisrupted(float days) {
        this.setDisrupted(days, false);
    }

    @Override
    public void setDisrupted(float days, boolean useMax) {
        if (!this.canBeDisrupted()) {
            return;
        }
        boolean was = this.isDisrupted();
        String key = this.getDisruptedKey();
        MemoryAPI memory = this.market.getMemoryWithoutUpdate();
        float dur = days;
        if (useMax) {
            dur = Math.max(memory.getExpire(key), dur);
        }
        if (dur <= 0.0f) {
            memory.unset(key);
        } else {
            memory.set(key, true, dur);
        }
        if (!was) {
            this.notifyDisrupted();
        }
    }

    @Override
    public float getDisruptedDays() {
        String key = this.getDisruptedKey();
        float dur = this.market.getMemoryWithoutUpdate().getExpire(key);
        if (dur < 0.0f) {
            dur = 0.0f;
        }
        return dur;
    }

    @Override
    public boolean canBeDisrupted() {
        return true;
    }

    @Override
    public boolean isDisrupted() {
        String key = this.getDisruptedKey();
        return this.market.getMemoryWithoutUpdate().is(key, true);
    }

    @Override
    public float getPatherInterest() {
        SpecialItemSpecAPI spec;
        float interest = 0.0f;
        if ("alpha_core".equals(this.aiCoreId)) {
            interest += 4.0f;
        } else if ("beta_core".equals(this.aiCoreId)) {
            interest += 2.0f;
        } else if ("gamma_core".equals(this.aiCoreId)) {
            interest += 1.0f;
        }
        if (this.special != null && (spec = Global.getSettings().getSpecialItemSpec(this.special.getId())) != null) {
            if (spec.hasTag("pather1")) {
                interest += 1.0f;
            } else if (spec.hasTag("pather2")) {
                interest += 2.0f;
            } else if (spec.hasTag("pather4")) {
                interest += 4.0f;
            } else if (spec.hasTag("pather6")) {
                interest += 6.0f;
            } else if (spec.hasTag("pather8")) {
                interest += 8.0f;
            } else if (spec.hasTag("pather10")) {
                interest += 10.0f;
            }
        }
        return interest;
    }

    @Override
    public CargoAPI generateCargoForGatheringPoint(Random random) {
        return null;
    }

    @Override
    public String getCargoTitleForGatheringPoint() {
        return this.getCurrentName();
    }

    @Override
    public SpecialItemData getSpecialItem() {
        return this.special;
    }

    @Override
    public void setSpecialItem(SpecialItemData special) {
        InstallableItemEffect effect;
        if (this.special != null && (effect = ItemEffectsRepo.ITEM_EFFECTS.get(this.special.getId())) != null) {
            effect.unapply(this);
        }
        this.special = special;
    }

    protected float getDeficitMult(String ... commodities) {
        float mult;
        float deficit = ((Integer)this.getMaxDeficit((String[])commodities).two).intValue();
        float demand = 0.0f;
        String[] stringArray = commodities;
        int n = commodities.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            demand = Math.max(demand, (float)this.getDemand(id).getQuantity().getModifiedInt());
            ++n2;
        }
        if (deficit < 0.0f) {
            deficit = 0.0f;
        }
        if (demand < 1.0f) {
            demand = 1.0f;
            deficit = 0.0f;
        }
        if ((mult = (demand - deficit) / demand) < 0.0f) {
            mult = 0.0f;
        }
        if (mult > 1.0f) {
            mult = 1.0f;
        }
        return mult;
    }

    protected void addGroundDefensesImpactSection(TooltipMakerAPI tooltip, float bonus, String ... commodities) {
        float mult;
        Color h = Misc.getHighlightColor();
        float opad = 10.0f;
        MutableStat fake = new MutableStat(1.0f);
        fake.modifyFlat("1", bonus, this.getNameForModifier());
        if (commodities != null && (mult = this.getDeficitMult(commodities)) != 1.0f) {
            String com = (String)this.getMaxDeficit((String[])commodities).one;
            fake.modifyFlat("2", -(1.0f - mult) * bonus, BaseIndustry.getDeficitText(com));
        }
        float total = Misc.getRoundedValueFloat(fake.getModifiedValue());
        String totalStr = "\u00d7" + total;
        if (total < 1.0f) {
            h = Misc.getNegativeHighlightColor();
        }
        float pad = 3.0f;
        tooltip.addPara("Ground defense strength: %s", opad, h, totalStr);
        tooltip.addStatModGrid(400.0f, 35.0f, opad, pad, fake, new TooltipMakerAPI.StatModValueGetter(){

            public String getPercentValue(MutableStat.StatMod mod) {
                return null;
            }

            public String getMultValue(MutableStat.StatMod mod) {
                return null;
            }

            public Color getModColor(MutableStat.StatMod mod) {
                if (mod.value < 0.0f) {
                    return Misc.getNegativeHighlightColor();
                }
                return null;
            }

            public String getFlatValue(MutableStat.StatMod mod) {
                String r = Misc.getRoundedValue(mod.value);
                if (mod.value >= 0.0f) {
                    return "+" + r;
                }
                return r;
            }
        });
    }

    @Override
    public boolean isIndustry() {
        return this.getSpec().hasTag("industry");
    }

    @Override
    public boolean isStructure() {
        return this.getSpec().hasTag("structure");
    }

    @Override
    public boolean isOther() {
        return !this.isIndustry() && !this.isStructure();
    }

    @Override
    public void notifyColonyRenamed() {
    }

    @Override
    public boolean canImprove() {
        return this.canImproveToIncreaseProduction();
    }

    @Override
    public float getImproveBonusXP() {
        return 0.0f;
    }

    @Override
    public String getImproveMenuText() {
        return "Make improvements...";
    }

    @Override
    public int getImproveStoryPoints() {
        int base = Global.getSettings().getInt("industryImproveBase");
        return base * (int)Math.round(Math.pow(2.0, Misc.getNumImprovedIndustries(this.market)));
    }

    @Override
    public boolean isImproved() {
        return this.improved != null && this.improved != false;
    }

    @Override
    public void setImproved(boolean improved) {
        this.improved = !improved ? null : Boolean.valueOf(improved);
    }

    protected void applyImproveModifiers() {
    }

    @Override
    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float initPad = 0.0f;
        float opad = 10.0f;
        boolean addedSomething = false;
        if (this.canImproveToIncreaseProduction()) {
            String unit = "unit";
            if (this.getImproveProductionBonus() != 1) {
                unit = "units";
            }
            if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
                info.addPara("Production increased by %s " + unit + ".", initPad, Misc.getHighlightColor(), "" + this.getImproveProductionBonus());
            } else {
                info.addPara("Increases production by %s " + unit + ".", initPad, Misc.getHighlightColor(), "" + this.getImproveProductionBonus());
            }
            initPad = opad;
            addedSomething = true;
        }
        if (mode != Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("Each improvement made at a colony doubles the number of " + Misc.STORY + " points required to make an additional improvement.", initPad, Misc.getStoryOptionColor(), String.valueOf(Misc.STORY) + " points");
            addedSomething = true;
        }
        if (!addedSomething) {
            info.addSpacer(-opad);
        }
    }

    @Override
    public String getImproveDialogTitle() {
        return "Improving " + this.getSpec().getName();
    }

    @Override
    public String getImproveSoundId() {
        return Sounds.STORY_POINT_SPEND_INDUSTRY;
    }

    protected boolean canImproveToIncreaseProduction() {
        return false;
    }

    protected int getImproveProductionBonus() {
        return DEFAULT_IMPROVE_SUPPLY_BONUS;
    }

    protected String getImprovementsDescForModifiers() {
        return "Improvements";
    }

    protected void updateImprovementSupplyAndDemandModifiers() {
        if (!this.canImproveToIncreaseProduction()) {
            return;
        }
        if (!this.isImproved()) {
            return;
        }
        int bonus = this.getImproveProductionBonus();
        if (bonus <= 0) {
            return;
        }
        this.supplyBonus.modifyFlat(this.getModId(3), bonus, this.getImprovementsDescForModifiers());
    }

    public void addImprovedSection(Industry.IndustryTooltipMode mode, TooltipMakerAPI tooltip, boolean expanded) {
        if (!this.isImproved()) {
            return;
        }
        float opad = 10.0f;
        tooltip.addSectionHeading("Improvements made", Misc.getStoryOptionColor(), Misc.getStoryDarkColor(), Alignment.MID, opad);
        tooltip.addSpacer(opad);
        this.addImproveDesc(tooltip, Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP);
    }

    @Override
    public MarketCMD.RaidDangerLevel adjustCommodityDangerLevel(String commodityId, MarketCMD.RaidDangerLevel level) {
        return level;
    }

    @Override
    public MarketCMD.RaidDangerLevel adjustItemDangerLevel(String itemId, String data, MarketCMD.RaidDangerLevel level) {
        return level;
    }

    @Override
    public int adjustMarineTokensToRaidItem(String itemId, String data, int marineTokens) {
        return marineTokens;
    }

    @Override
    public boolean canInstallAICores() {
        return true;
    }

    @Override
    public List<InstallableIndustryItemPlugin> getInstallableItems() {
        boolean found = false;
        if (this.hasInstallableItems != null) {
            found = this.hasInstallableItems;
        } else {
            block0: for (SpecialItemSpecAPI spec : Global.getSettings().getAllSpecialItemSpecs()) {
                if (spec.getParams() == null || spec.getParams().isEmpty() || !(spec.getNewPluginInstance(null) instanceof GenericSpecialItemPlugin)) continue;
                String[] stringArray = spec.getParams().split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if ((id = id.trim()).equals(this.getId())) {
                        found = true;
                        break block0;
                    }
                    ++n2;
                }
            }
            this.hasInstallableItems = found;
        }
        ArrayList<InstallableIndustryItemPlugin> list = new ArrayList<InstallableIndustryItemPlugin>();
        if (found) {
            list.add(new GenericInstallableItemPlugin(this));
        }
        return list;
    }

    public float getBuildProgress() {
        return this.buildProgress;
    }

    public void setBuildProgress(float buildProgress) {
        this.buildProgress = buildProgress;
    }
}

