/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseInstallableItemEffect;
import com.fs.starfarer.api.util.Misc;

public abstract class BoostIndustryInstallableItemEffect
extends BaseInstallableItemEffect {
    protected int supplyIncrease = 0;
    protected int demandIncrease = 0;

    public BoostIndustryInstallableItemEffect(String id, int supplyIncrease, int demandIncrease) {
        super(id);
        this.supplyIncrease = supplyIncrease;
        this.demandIncrease = demandIncrease;
    }

    public void apply(Industry industry) {
        if (this.supplyIncrease != 0) {
            industry.getSupplyBonus().modifyFlat(this.spec.getId(), this.supplyIncrease, Misc.ucFirst(this.spec.getName().toLowerCase()));
        }
        if (this.demandIncrease != 0) {
            industry.getDemandReduction().modifyFlat(this.spec.getId(), -this.demandIncrease, Misc.ucFirst(this.spec.getName().toLowerCase()));
        }
    }

    public void unapply(Industry industry) {
        if (this.supplyIncrease != 0) {
            industry.getSupplyBonus().modifyFlat(this.spec.getId(), 0.0f, Misc.ucFirst(this.spec.getName().toLowerCase()));
        }
        if (this.demandIncrease != 0) {
            industry.getDemandReduction().modifyFlat(this.spec.getId(), 0.0f, Misc.ucFirst(this.spec.getName().toLowerCase()));
        }
    }

    public int getSupplyIncrease() {
        return this.supplyIncrease;
    }

    public void setSupplyIncrease(int supplyIncrease) {
        this.supplyIncrease = supplyIncrease;
    }

    public int getDemandIncrease() {
        return this.demandIncrease;
    }

    public void setDemandIncrease(int demandIncrease) {
        this.demandIncrease = demandIncrease;
    }
}

