/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructionQueue {
    protected List<ConstructionQueueItem> items = new ArrayList<ConstructionQueueItem>();

    protected Object readResolve() {
        if (this.items == null) {
            this.items = new ArrayList<ConstructionQueueItem>();
        }
        return this;
    }

    public List<ConstructionQueueItem> getItems() {
        return this.items;
    }

    public void setItems(List<ConstructionQueueItem> items) {
        this.items = items;
    }

    public void addToEnd(String id, int cost) {
        ConstructionQueueItem item = new ConstructionQueueItem(id, cost);
        this.items.add(item);
    }

    public void moveUp(String id) {
        ConstructionQueueItem item = this.getItem(id);
        if (item == null) {
            return;
        }
        int index = this.items.indexOf(item);
        if (--index < 0) {
            index = 0;
        }
        this.items.remove(item);
        this.items.add(index, item);
    }

    public void moveDown(String id) {
        ConstructionQueueItem item = this.getItem(id);
        if (item == null) {
            return;
        }
        int index = this.items.indexOf(item);
        this.items.remove(item);
        if (++index > this.items.size()) {
            index = this.items.size();
        }
        this.items.add(index, item);
    }

    public void moveToFront(String id) {
        ConstructionQueueItem item = this.getItem(id);
        if (item == null) {
            return;
        }
        this.items.remove(item);
        this.items.add(0, item);
    }

    public void moveToBack(String id) {
        ConstructionQueueItem item = this.getItem(id);
        if (item == null) {
            return;
        }
        this.items.remove(item);
        this.items.add(item);
    }

    public void removeItem(String id) {
        this.items.remove(this.getItem(id));
    }

    public ConstructionQueueItem getItem(String id) {
        for (ConstructionQueueItem item : this.items) {
            if (!item.id.equals(id)) continue;
            return item;
        }
        return null;
    }

    public boolean hasItem(String id) {
        return this.getItem(id) != null;
    }

    public static class ConstructionQueueItem {
        public String id;
        public int cost;

        public ConstructionQueueItem(String id, int cost) {
            this.id = id;
            this.cost = cost;
        }
    }
}

