/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroundDefenses
extends BaseIndustry {
    public static float DEFENSE_BONUS_BASE = 1.0f;
    public static float DEFENSE_BONUS_BATTERIES = 2.0f;
    public static float IMPROVE_DEFENSE_BONUS = 0.25f;
    public static float ALPHA_CORE_BONUS = 0.5f;

    @Override
    public void apply() {
        super.apply(true);
        int size = this.market.getSize();
        boolean hb = "heavybatteries".equals(this.getId());
        this.demand("supplies", size);
        this.demand("marines", size);
        this.demand("hand_weapons", size - 2);
        this.modifyStabilityWithBaseMod();
        float mult = this.getDeficitMult("supplies", "marines", "hand_weapons");
        String extra = "";
        if (mult != 1.0f) {
            String com = (String)this.getMaxDeficit((String[])new String[]{"supplies", "marines", "hand_weapons"}).one;
            extra = " (" + GroundDefenses.getDeficitText(com).toLowerCase() + ")";
        }
        float bonus = hb ? DEFENSE_BONUS_BATTERIES : DEFENSE_BONUS_BASE;
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(this.getModId(), 1.0f + bonus * mult, String.valueOf(this.getNameForModifier()) + extra);
        if (!this.isFunctional()) {
            this.supply.clear();
            this.unapply();
        }
    }

    @Override
    public void unapply() {
        super.unapply();
        this.unmodifyStabilityWithBaseMod();
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId());
    }

    @Override
    public String getCurrentImage() {
        PlanetAPI planet;
        boolean batteries = "heavybatteries".equals(this.getId());
        if (batteries && ((planet = this.market.getPlanetEntity()) == null || planet.isGasGiant())) {
            return Global.getSettings().getSpriteName("industry", "heavy_batteries_orbital");
        }
        return super.getCurrentImage();
    }

    @Override
    public boolean isDemandLegal(CommodityOnMarketAPI com) {
        return true;
    }

    @Override
    public boolean isSupplyLegal(CommodityOnMarketAPI com) {
        return true;
    }

    @Override
    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional();
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            this.addStabilityPostDemandSection(tooltip, hasDemand, mode);
            boolean hb = "heavybatteries".equals(this.getId());
            float bonus = hb ? DEFENSE_BONUS_BATTERIES : DEFENSE_BONUS_BASE;
            this.addGroundDefensesImpactSection(tooltip, bonus, "supplies", "marines", "hand_weapons");
        }
    }

    @Override
    protected int getBaseStabilityMod() {
        return 1;
    }

    @Override
    protected Pair<String, Integer> getStabilityAffectingDeficit() {
        return this.getMaxDeficit("supplies", "marines", "hand_weapons");
    }

    @Override
    protected void applyAlphaCoreModifiers() {
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(this.getModId(1), 1.0f + ALPHA_CORE_BONUS, "Alpha core (" + this.getNameForModifier() + ")");
    }

    @Override
    protected void applyNoAICoreModifiers() {
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId(1));
    }

    @Override
    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "Alpha core");
    }

    @Override
    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "Alpha-level AI core currently assigned. ";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "Alpha-level AI core. ";
        }
        float a = ALPHA_CORE_BONUS;
        String str = "\u00d7" + (1.0f + a);
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases ground defenses by %s.", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases ground defenses by %s.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
    }

    @Override
    public boolean canImprove() {
        return true;
    }

    @Override
    protected void applyImproveModifiers() {
        if (this.isImproved()) {
            this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMult("ground_defenses_improve", 1.0f + IMPROVE_DEFENSE_BONUS, String.valueOf(this.getImprovementsDescForModifiers()) + " (" + this.getNameForModifier() + ")");
        } else {
            this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult("ground_defenses_improve");
        }
    }

    @Override
    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        float a = IMPROVE_DEFENSE_BONUS;
        String str = "\u00d7" + (1.0f + a);
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("Ground defenses increased by %s.", 0.0f, highlight, str);
        } else {
            info.addPara("Increases ground defenses by %s.", 0.0f, highlight, str);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }

    @Override
    public MarketCMD.RaidDangerLevel adjustCommodityDangerLevel(String commodityId, MarketCMD.RaidDangerLevel level) {
        return level.next();
    }

    @Override
    public MarketCMD.RaidDangerLevel adjustItemDangerLevel(String itemId, String data, MarketCMD.RaidDangerLevel level) {
        return level.next();
    }
}

