/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HyperspaceTopographyEventIntel;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spaceport
extends BaseIndustry
implements MarketImmigrationModifier {
    public static float OFFICER_PROB_MOD = 0.1f;
    public static float OFFICER_PROB_MOD_MEGA = 0.2f;
    public static float UPKEEP_MULT_PER_DEFICIT = 0.1f;
    public static float BASE_ACCESSIBILITY = 0.6f;
    public static float MEGAPORT_ACCESSIBILITY = 0.9f;
    public static float ALPHA_CORE_ACCESSIBILITY = 0.2f;
    public static float IMPROVE_ACCESSIBILITY = 0.2f;

    @Override
    public void apply() {
        super.apply(true);
        int size = this.market.getSize();
        boolean megaport = "megaport".equals(this.getId());
        int extraSize = 0;
        if (megaport) {
            extraSize = 2;
        }
        this.demand("fuel", size - 2 + extraSize);
        this.demand("supplies", size - 2 + extraSize);
        this.demand("ships", size - 2 + extraSize);
        this.supply("crew", size - 1 + extraSize);
        String desc = this.getNameForModifier();
        Pair<String, Integer> deficit = this.getUpkeepAffectingDeficit();
        if ((Integer)deficit.two > 0) {
            float loss = this.getUpkeepPenalty(deficit);
            this.getUpkeep().modifyMult("deficit", 1.0f + loss, Spaceport.getDeficitText((String)deficit.one));
        } else {
            this.getUpkeep().unmodifyMult("deficit");
        }
        this.market.setHasSpaceport(true);
        float a = BASE_ACCESSIBILITY;
        if (megaport) {
            a = MEGAPORT_ACCESSIBILITY;
        }
        if (a > 0.0f) {
            this.market.getAccessibilityMod().modifyFlat(this.getModId(0), a, desc);
        }
        float officerProb = OFFICER_PROB_MOD;
        if (megaport) {
            officerProb = OFFICER_PROB_MOD_MEGA;
        }
        this.market.getStats().getDynamic().getMod("officer_prob").modifyFlat(this.getModId(0), officerProb);
        if (!this.isFunctional()) {
            this.supply.clear();
            this.unapply();
            this.market.setHasSpaceport(true);
        }
    }

    @Override
    public void unapply() {
        super.unapply();
        this.market.setHasSpaceport(false);
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(0));
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(1));
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(2));
        this.market.getStats().getDynamic().getMod("officer_prob").unmodifyFlat(this.getModId(0));
    }

    protected float getUpkeepPenalty(Pair<String, Integer> deficit) {
        float loss = (float)((Integer)deficit.two).intValue() * UPKEEP_MULT_PER_DEFICIT;
        if (loss < 0.0f) {
            loss = 0.0f;
        }
        return loss;
    }

    protected Pair<String, Integer> getUpkeepAffectingDeficit() {
        return this.getMaxDeficit("fuel", "supplies", "ships");
    }

    @Override
    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional();
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            MutableStat fake = new MutableStat(0.0f);
            boolean megaport = "megaport".equals(this.getId());
            String desc = this.getNameForModifier();
            float a = BASE_ACCESSIBILITY;
            if (megaport) {
                a = MEGAPORT_ACCESSIBILITY;
            }
            if (a > 0.0f) {
                fake.modifyFlat(this.getModId(0), a, desc);
            }
            float total = a;
            String totalStr = "+" + Math.round(total * 100.0f) + "%";
            Color h = Misc.getHighlightColor();
            if (total < 0.0f) {
                h = Misc.getNegativeHighlightColor();
                totalStr = Math.round(total * 100.0f) + "%";
            }
            float opad = 10.0f;
            float pad = 3.0f;
            if (total >= 0.0f) {
                tooltip.addPara("Accessibility bonus: %s", opad, h, totalStr);
            } else {
                tooltip.addPara("Accessibility penalty: %s", opad, h, totalStr);
            }
            float bonus = this.getPopulationGrowthBonus();
            tooltip.addPara("Population growth: %s", opad, h, "+" + (int)bonus);
            HyperspaceTopographyEventIntel intel = HyperspaceTopographyEventIntel.get();
            if (intel != null && intel.isStageActive((Object)HyperspaceTopographyEventIntel.Stage.SLIPSTREAM_DETECTION)) {
                h = Misc.getHighlightColor();
                tooltip.addSectionHeading("Hyperspace topography", Alignment.MID, opad);
                if (!this.isFunctional()) {
                    tooltip.addPara("Slipstream detection requires functional Spaceport", Misc.getNegativeHighlightColor(), opad);
                } else {
                    int range = Math.round(this.market.getStats().getDynamic().getMod("slipstream_reveal_range_ly_mod").computeEffective(0.0f));
                    tooltip.addPara("Slipstream detection range: %s light-years", opad, h, "" + range);
                    tooltip.addStatModGrid(tooltip.getWidthSoFar(), 50.0f, opad, pad, this.market.getStats().getDynamic().getMod("slipstream_reveal_range_ly_mod"));
                }
            }
        }
    }

    public float getPopulationGrowthBonus() {
        boolean megaport = "megaport".equals(this.getId());
        float bonus = 2.0f;
        if (megaport) {
            bonus = this.market.getSize();
        }
        return bonus;
    }

    @Override
    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        float bonus = this.getPopulationGrowthBonus();
        incoming.getWeight().modifyFlat(this.getModId(), bonus, this.getNameForModifier());
    }

    @Override
    protected void applyAlphaCoreModifiers() {
        this.market.getAccessibilityMod().modifyFlat(this.getModId(2), ALPHA_CORE_ACCESSIBILITY, "Alpha core (" + this.getNameForModifier() + ")");
    }

    @Override
    protected void applyNoAICoreModifiers() {
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(2));
    }

    @Override
    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "Alpha core");
    }

    @Override
    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "Alpha-level AI core currently assigned. ";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "Alpha-level AI core. ";
        }
        float a = ALPHA_CORE_ACCESSIBILITY;
        String aStr = Math.round(a * 100.0f) + "%";
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases accessibility by %s.", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, aStr);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases accessibility by %s.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, aStr);
    }

    @Override
    public boolean canImprove() {
        return true;
    }

    @Override
    protected void applyImproveModifiers() {
        if (this.isImproved()) {
            this.market.getAccessibilityMod().modifyFlat("spaceport_improve", IMPROVE_ACCESSIBILITY, String.valueOf(this.getImprovementsDescForModifiers()) + " (" + this.getNameForModifier() + ")");
        } else {
            this.market.getAccessibilityMod().unmodifyFlat("spaceport_improve");
        }
    }

    @Override
    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        float a = IMPROVE_ACCESSIBILITY;
        String aStr = Math.round(a * 100.0f) + "%";
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("Accessibility increased by %s.", 0.0f, highlight, aStr);
        } else {
            info.addPara("Increases accessibility by %s.", 0.0f, highlight, aStr);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }
}

