/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.enc;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.enc.BaseEPEncounterCreator;
import com.fs.starfarer.api.impl.campaign.enc.EncounterManager;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPoint;
import com.fs.starfarer.api.impl.campaign.fleets.AutoDespawnScript;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantStationFleetManager;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class OutsideSystemRemnantEPEC
extends BaseEPEncounterCreator {
    public void createEncounter(EncounterManager manager, EncounterPoint point) {
        if (!(point.custom instanceof RemnantStationFleetManager)) {
            return;
        }
        Random random = manager.getRandom();
        RemnantStationFleetManager fm = (RemnantStationFleetManager)point.custom;
        int difficulty = 0;
        int max = 10;
        float mult = 1.0f;
        if (fm.getSource() != null && fm.getSource().getStarSystem() != null && fm.getSource().getStarSystem().hasTag("theme_remnant_suppressed")) {
            max = 3;
            mult = 0.25f;
        }
        difficulty += (int)Math.min((float)fm.getTotalLost() * mult, (float)max);
        if ((difficulty += random.nextInt(4)) > 10) {
            difficulty = 10;
        }
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = point.getLocInHyper();
        HubMissionWithTriggers.FleetSize size = HubMissionWithTriggers.FleetSize.MEDIUM;
        HubMissionWithTriggers.FleetQuality quality = HubMissionWithTriggers.FleetQuality.VERY_HIGH;
        HubMissionWithTriggers.OfficerQuality oQuality = HubMissionWithTriggers.OfficerQuality.AI_MIXED;
        HubMissionWithTriggers.OfficerNum oNum = HubMissionWithTriggers.OfficerNum.ALL_SHIPS;
        String type = "patrolSmall";
        if (difficulty <= 1) {
            size = HubMissionWithTriggers.FleetSize.VERY_SMALL;
            type = "patrolSmall";
            oQuality = HubMissionWithTriggers.OfficerQuality.AI_GAMMA;
        } else if (difficulty <= 2) {
            size = HubMissionWithTriggers.FleetSize.SMALL;
            type = "patrolSmall";
            oQuality = HubMissionWithTriggers.OfficerQuality.AI_GAMMA;
        } else if (difficulty <= 5) {
            size = HubMissionWithTriggers.FleetSize.MEDIUM;
            type = "patrolSmall";
            oQuality = HubMissionWithTriggers.OfficerQuality.AI_BETA_OR_GAMMA;
        } else if (difficulty <= 7) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
            type = "patrolMedium";
            oQuality = HubMissionWithTriggers.OfficerQuality.AI_BETA_OR_GAMMA;
        } else if (difficulty == 8) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
            type = "patrolLarge";
            oQuality = HubMissionWithTriggers.OfficerQuality.AI_MIXED;
        } else if (difficulty == 9) {
            size = HubMissionWithTriggers.FleetSize.LARGER;
            type = "patrolLarge";
            oQuality = HubMissionWithTriggers.OfficerQuality.AI_ALPHA;
        } else {
            size = HubMissionWithTriggers.FleetSize.VERY_LARGE;
            type = "patrolLarge";
            oQuality = HubMissionWithTriggers.OfficerQuality.AI_ALPHA;
        }
        m.triggerCreateFleet(size, quality, "remnant", type, loc);
        m.triggerSetFleetOfficers(oNum, oQuality);
        m.triggerSetRemnantConfigActive();
        m.triggerFleetUnsetAllowLongPursuit();
        CampaignFleetAPI fleet = m.createFleet();
        if (fleet != null) {
            point.where.addEntity(fleet);
            fleet.setLocation(point.loc.x, point.loc.y);
            Vector2f spawnLoc = Misc.getPointWithinRadius(point.loc, 1000.0f);
            SectorEntityToken e = point.where.createToken(spawnLoc);
            String actionText = "patrolling";
            if (difficulty <= 2) {
                actionText = "reconnoitering";
            }
            fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, e, 30.0f * random.nextFloat(), actionText);
            fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, fm.getSource(), 1000.0f, "returning to " + fm.getSource().getName());
            fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, fm.getSource(), 3.0f + random.nextFloat() * 2.0f, "uploading encrypted data");
            fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, fm.getSource(), 10.0f);
            fleet.addScript(new AutoDespawnScript(fleet));
        }
    }

    public float getFrequencyForPoint(EncounterManager manager, EncounterPoint point) {
        if (!EncounterManager.EP_TYPE_OUTSIDE_SYSTEM.equals(point.type)) {
            return 0.0f;
        }
        if (!(point.custom instanceof RemnantStationFleetManager)) {
            return 0.0f;
        }
        RemnantStationFleetManager fm = (RemnantStationFleetManager)point.custom;
        float mult = 0.5f;
        if (fm.getSource() != null && fm.getSource().getStarSystem() != null && fm.getSource().getStarSystem().hasTag("theme_remnant_suppressed")) {
            mult = 0.1f;
        }
        return 10.0f * Math.min(10.0f, (float)fm.getTotalLost()) * mult;
    }
}

