/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.enc;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.enc.BaseEPEncounterCreator;
import com.fs.starfarer.api.impl.campaign.enc.EncounterManager;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPoint;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RuinsFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.ScavengerPiracyScript;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class SlipstreamScavengerEPEC
extends BaseEPEncounterCreator {
    public void createEncounter(EncounterManager manager, EncounterPoint point) {
        Random random = manager.getRandom();
        boolean pirate = random.nextBoolean();
        pirate = true;
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(random);
        picker.add("scavengerSmall", 5.0f);
        picker.add("scavengerMedium", 15.0f);
        picker.add("scavengerLarge", 10.0f);
        String type = (String)picker.pick();
        CampaignFleetAPI fleet = RuinsFleetRouteManager.createScavenger(type, point.getLocInHyper(), null, null, pirate, random);
        if (fleet != null) {
            point.where.addEntity(fleet);
            fleet.setLocation(point.loc.x, point.loc.y);
            Vector2f spawnLoc = Misc.getPointWithinRadius(point.loc, 1000.0f);
            SectorEntityToken e = point.where.createToken(spawnLoc);
            fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, e, 30.0f * random.nextFloat(), "waiting");
            fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
            fleet.addScript(new MissionFleetAutoDespawn(null, fleet));
            fleet.addScript(new ScavengerPiracyScript(fleet));
        }
    }

    public float getFrequencyForPoint(EncounterManager manager, EncounterPoint point) {
        if (!EncounterManager.EP_TYPE_SLIPSTREAM.equals(point.type)) {
            return 0.0f;
        }
        float f = SlipstreamScavengerEPEC.getProximityFactor(point.getLocInHyper());
        if (f > 0.0f) {
            f = 0.25f + 0.75f * f;
        }
        return 10.0f * f;
    }

    public static float getProximityFactor(Vector2f locInHyper) {
        StarSystemAPI ruins = SlipstreamScavengerEPEC.getClosestSystemWithRuins(locInHyper);
        float f = SlipstreamScavengerEPEC.getRuinsProximityFactor(ruins, locInHyper);
        return f;
    }
}

