/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.eventide;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.eventide.AnimAction;
import com.fs.starfarer.api.impl.campaign.eventide.CharAnimFrame;
import com.fs.starfarer.api.impl.campaign.eventide.HitArea;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

public class Actor {
    public AnimAction currAction;
    public AnimAction nextAction;
    public float facing = 1.0f;
    public Vector2f loc = new Vector2f();
    public int maxHealth;
    public int health;
    public String texId;
    public Map<String, String> actionRemap1 = new LinkedHashMap<String, String>();
    public Map<String, String> actionRemap2 = new LinkedHashMap<String, String>();
    public Map<String, Float> actionSpeedMult = new LinkedHashMap<String, Float>();
    protected float freeze = 0.0f;

    public Actor() {
        this(null);
    }

    public Actor(String texId) {
        this.texId = texId;
    }

    public String getActionId() {
        if (this.currAction == null) {
            return "";
        }
        return this.currAction.anim.action;
    }

    public void endCurrentAnimation() {
        if (this.currAction != null) {
            this.currAction.makeCurrentFrameLast = true;
        }
    }

    public void freeze(float sec) {
        this.freeze = sec;
    }

    public void advance(float amount) {
        this.freeze -= amount;
        if (this.freeze > 0.0f) {
            return;
        }
        if (this.currAction != null) {
            Float mult = this.actionSpeedMult.get(this.currAction.anim.action);
            if (mult == null) {
                mult = Float.valueOf(1.0f);
            }
            this.currAction.advance(amount * mult.floatValue());
            if (this.currAction.isDone()) {
                this.currAction = null;
            }
        }
        if (this.currAction == null) {
            if (this.nextAction != null) {
                this.currAction = this.nextAction;
                this.nextAction = null;
            } else {
                this.doAction("IDLE", true);
            }
            this.currAction.advance(0.0f);
        }
    }

    public CharAnimFrame getCurrentFrame() {
        if (this.currAction == null) {
            return null;
        }
        return this.currAction.curr;
    }

    public void doAction(String action, boolean forceInterruptCurrent) {
        if (action == "ATTACK" && this.currAction != null && this.currAction.performedBlock) {
            action = "RIPOSTE";
            forceInterruptCurrent = true;
        } else if (this.currAction != null && this.currAction.anim != null && this.currAction.anim.interruptableBy.contains(action)) {
            forceInterruptCurrent = true;
        }
        if (this.actionRemap1.containsKey(action)) {
            action = this.actionRemap1.get(action);
        }
        if (this.actionRemap2.containsKey(action)) {
            action = this.actionRemap2.get(action);
        }
        if (forceInterruptCurrent) {
            this.nextAction = null;
            this.currAction = new AnimAction(this, action, this.getCurrentFrame());
            if (this.currAction.anim == null) {
                this.currAction = null;
            } else {
                this.currAction.advance(0.0f);
            }
        } else {
            if (this.nextAction == null || this.nextAction.anim == null) {
                this.nextAction = null;
            }
            this.nextAction = new AnimAction(this, action, this.getCurrentFrame());
        }
    }

    public void render(float alphaMult) {
        boolean renderShadow = true;
        renderShadow = false;
        if (renderShadow && this.currAction != null && this.currAction.anim != null && this.currAction.curr != null && !this.currAction.curr.hittableArea.isEmpty()) {
            HitArea area = this.currAction.curr.hittableArea.get(0);
            area = area.getAdjustedForAction(this.currAction);
            SpriteAPI shadow = Global.getSettings().getSprite("graphics/fx/hit_glow.png");
            shadow.setNormalBlend();
            shadow.setColor(Color.black);
            float sw = this.currAction.curr.width * 1.25f;
            if (sw > 200.0f) {
                sw = 200.0f + (sw - 200.0f) * 0.33f;
            }
            shadow.setSize(sw, 40.0f);
            shadow.setAlphaMult(0.5f);
            shadow.renderAtCenter(area.x + area.w / 2.0f, this.loc.y - this.currAction.anim.frameHeight / 2.0f + 5.0f);
        }
        this.currAction.render(alphaMult);
    }
}

