/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.eventide;

import com.fs.starfarer.api.campaign.CustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.CustomVisualDialogDelegate;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.eventide.DuelPanel;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuelDialogDelegate
implements CustomVisualDialogDelegate {
    protected CustomVisualDialogDelegate.DialogCallbacks callbacks;
    protected float endDelay = 2.0f;
    protected boolean finished = false;
    protected String musicId;
    protected DuelPanel duelPanel;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;
    protected boolean tutorialMode;

    public DuelDialogDelegate(@Deprecated String musicId, DuelPanel duelPanel, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap, boolean tutorialMode) {
        this.musicId = musicId;
        this.duelPanel = duelPanel;
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        this.tutorialMode = tutorialMode;
    }

    @Override
    public CustomUIPanelPlugin getCustomPanelPlugin() {
        return this.duelPanel;
    }

    @Override
    public void init(CustomPanelAPI panel, CustomVisualDialogDelegate.DialogCallbacks callbacks) {
        this.callbacks = callbacks;
        callbacks.getPanelFader().setDurationOut(2.0f);
        this.duelPanel.init(panel, callbacks, this.dialog);
    }

    @Override
    public float getNoiseAlpha() {
        return 0.0f;
    }

    @Override
    public void advance(float amount) {
        if (!(this.finished || this.duelPanel.getPlayer().health > 0 && this.duelPanel.getEnemy().health > 0)) {
            this.endDelay -= amount;
            if (this.endDelay <= 0.0f) {
                this.callbacks.getPanelFader().fadeOut();
                if (this.callbacks.getPanelFader().isFadedOut()) {
                    this.callbacks.dismissDialog();
                    this.finished = true;
                }
            }
        }
    }

    @Override
    public void reportDismissed(int option) {
        if (this.memoryMap != null) {
            if (!this.tutorialMode) {
                if (this.duelPanel.getPlayer().health > 0) {
                    this.memoryMap.get("local").set("$soe_playerWonDuel", true, 0.0f);
                } else {
                    this.memoryMap.get("local").set("$soe_playerLostDuel", true, 0.0f);
                }
                FireBest.fire(null, this.dialog, this.memoryMap, "SOEDuelFinished");
            } else {
                FireBest.fire(null, this.dialog, this.memoryMap, "SOETutorialFinished");
            }
        }
    }
}

