/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CivilDisorder
extends BaseEventPlugin {
    private float elapsedDays = 0.0f;
    private CampaignEventTarget eventTarget;
    private boolean started = false;
    private int stage = 0;
    private String type;

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        this.type = type;
        this.eventTarget = eventTarget;
    }

    @Override
    public void startEvent() {
        this.started = true;
    }

    @Override
    public void advance(float amount) {
        WeightedRandomPicker<String> picker;
        if (Global.getSector().isPaused()) {
            return;
        }
        if (!this.started) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (this.elapsedDays > 0.0f && this.stage == 0) {
            picker = new WeightedRandomPicker<String>();
            picker.add("start1");
            picker.add("start2");
            picker.add("start3");
            Global.getSector().reportEventStage(this, (String)picker.pick(), MessagePriority.SECTOR);
            ++this.stage;
        }
        if (this.elapsedDays > 1.0f && this.stage == 1) {
            picker = new WeightedRandomPicker();
            picker.add("ending1");
            picker.add("ending2");
            picker.add("ending3");
            picker.add("ending4");
            Global.getSector().reportEventStage(this, (String)picker.pick(), MessagePriority.SECTOR);
            ++this.stage;
        }
        if (this.elapsedDays > 2.0f && this.stage == 2) {
            picker = new WeightedRandomPicker();
            picker.add("end1");
            picker.add("end2");
            Global.getSector().reportEventStage(this, (String)picker.pick(), MessagePriority.SECTOR);
            ++this.stage;
        }
    }

    @Override
    public boolean isDone() {
        return this.elapsedDays > 5.0f || this.stage >= 3;
    }

    @Override
    public CampaignEventTarget getEventTarget() {
        return this.eventTarget;
    }

    @Override
    public String getEventType() {
        return this.type;
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("$market", this.eventTarget.getEntity().getName());
        map.put("$rulingFaction", this.eventTarget.getEntity().getFaction().getDisplayName());
        map.put("$rulingParty", this.eventTarget.getEntity().getFaction().getDisplayName());
        map.put("$theRulingFaction", this.eventTarget.getEntity().getFaction().getDisplayNameWithArticle());
        map.put("$TheRulingFaction", Misc.ucFirst(this.eventTarget.getEntity().getFaction().getDisplayNameWithArticle()));
        return map;
    }

    @Override
    public MessagePriority getWarningWhenPossiblePriority() {
        return MessagePriority.SECTOR;
    }

    @Override
    public MessagePriority getWarningWhenLikelyPriority() {
        return MessagePriority.SECTOR;
    }

    @Override
    public String getStageIdForLikely() {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>();
        picker.add("possible1");
        picker.add("possible2");
        picker.add("possible3");
        picker.add("possible4");
        return (String)picker.pick();
    }

    @Override
    public String getStageIdForPossible() {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>();
        picker.add("possible1");
        picker.add("possible2");
        picker.add("possible3");
        picker.add("possible4");
        return (String)picker.pick();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void setParam(Object param) {
    }

    @Override
    public boolean allowMultipleOngoingForSameTarget() {
        return false;
    }

    @Override
    public Color[] getHighlightColors(String stageId) {
        return null;
    }

    @Override
    public String[] getHighlights(String stageId) {
        return null;
    }
}

