/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactionHostilityEvent
extends BaseEventPlugin {
    public static final float HOSTILITY_PENALTY = 0.2f;
    public static Logger log = Global.getLogger(FactionHostilityEvent.class);
    protected float elapsedDays = 0.0f;
    protected float duration = 0.0f;
    protected FactionHostilityPairKey target = null;
    protected FactionAPI one;
    protected FactionAPI two;
    protected boolean ended = false;
    protected float prevRel = 0.0f;
    protected float prevRelOne = 0.0f;
    protected float prevRelTwo = 0.0f;

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget, false);
    }

    @Override
    public void startEvent() {
        super.startEvent(true);
        if (!(this.eventTarget.getCustom() instanceof FactionHostilityPairKey)) {
            this.endEvent();
            return;
        }
        this.target = (FactionHostilityPairKey)this.eventTarget.getCustom();
        this.one = this.target.one;
        this.two = this.target.two;
        this.duration = 365.0f * (0.5f + 0.5f * (float)Math.random());
        log.info((Object)String.format("Starting hostility event: %s -> %s", this.one.getDisplayName(), this.two.getDisplayName()));
        FactionAPI commFac = Misc.getCommissionFaction();
        if (commFac != null && (commFac == this.one || commFac == this.two)) {
            Global.getSector().reportEventStage(this, "warning", Global.getSector().getPlayerFleet(), MessagePriority.ENSURE_DELIVERY, null);
        }
    }

    protected void startHostilities() {
        log.info((Object)String.format("Making factions hostile: %s -> %s", this.one.getDisplayName(), this.two.getDisplayName()));
        this.prevRel = this.one.getRelationship(this.two.getId());
        this.one.setRelationship(this.two.getId(), RepLevel.HOSTILE);
        this.prevRelOne = this.one.getRelationship("player");
        this.prevRelTwo = this.two.getRelationship("player");
        final FactionAPI commFac = Misc.getCommissionFaction();
        if (commFac != null && (commFac == this.one || commFac == this.two)) {
            Global.getSector().reportEventStage(this, "start", Global.getSector().getPlayerFleet(), MessagePriority.ENSURE_DELIVERY, new BaseOnMessageDeliveryScript(){

                public void beforeDelivery(CommMessageAPI message) {
                    Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MAKE_HOSTILE_AT_BEST, null, null, true), (commFac == FactionHostilityEvent.this.one ? FactionHostilityEvent.this.two : FactionHostilityEvent.this.one).getId());
                }
            });
        } else {
            Global.getSector().reportEventStage(this, "start", Global.getSector().getPlayerFleet(), MessagePriority.ENSURE_DELIVERY, null);
        }
    }

    @Override
    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (!this.started && this.elapsedDays > 10.0f) {
            this.startHostilities();
            this.started = true;
        }
        if (this.elapsedDays >= this.duration) {
            this.endEvent();
        }
    }

    protected void endEvent() {
        if (this.ended) {
            return;
        }
        this.ended = true;
        this.one.setRelationship(this.two.getId(), Math.max(0.0f, this.prevRel));
        Global.getSector().reportEventStage(this, "end", Global.getSector().getPlayerFleet(), MessagePriority.ENSURE_DELIVERY, new BaseOnMessageDeliveryScript(){

            public void beforeDelivery(CommMessageAPI message) {
                FactionAPI commFac = Misc.getCommissionFaction();
                if (commFac == null) {
                    return;
                }
                if (commFac != FactionHostilityEvent.this.one && commFac != FactionHostilityEvent.this.two) {
                    return;
                }
                FactionAPI other = FactionHostilityEvent.this.one;
                float prevRel = FactionHostilityEvent.this.prevRelOne;
                if (other == commFac) {
                    other = FactionHostilityEvent.this.two;
                    prevRel = FactionHostilityEvent.this.prevRelTwo;
                }
                float currRel = other.getRelationship("player");
                CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                impact.delta = prevRel - currRel - 0.2f;
                if (impact.delta < 0.0f) {
                    impact.delta = 0.0f;
                }
                Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, impact, null, true), other.getId());
            }
        });
    }

    @Override
    public String getEventName() {
        String postfix = " hostilities";
        if (this.isDone()) {
            postfix = " hostilities - over";
        }
        return String.valueOf(Misc.ucFirst(this.one.getDisplayName())) + " / " + Misc.ucFirst(this.two.getDisplayName()) + postfix;
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        action.equals("TODO");
        return true;
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        Map<String, String> map = super.getTokenReplacements();
        FactionHostilityEvent.addFactionNameTokens(map, "one", this.one);
        FactionHostilityEvent.addFactionNameTokens(map, "two", this.two);
        FactionAPI commFac = Misc.getCommissionFaction();
        if (commFac != null && (commFac == this.one || commFac == this.two)) {
            map.put("$sender", commFac.getDisplayName());
            FactionHostilityEvent.addFactionNameTokens(map, "commission", commFac);
            FactionHostilityEvent.addFactionNameTokens(map, "other", commFac == this.one ? this.two : this.one);
        }
        return map;
    }

    @Override
    public String[] getHighlights(String stageId) {
        ArrayList result = new ArrayList();
        return result.toArray(new String[0]);
    }

    @Override
    public boolean isDone() {
        return this.ended;
    }

    public static class FactionHostilityPairKey {
        protected FactionAPI one;
        protected FactionAPI two;

        public FactionHostilityPairKey(FactionAPI one, FactionAPI two) {
            this.one = one;
            this.two = two;
            if (one.getId().compareTo(two.getId()) > 0) {
                FactionAPI temp = one;
                one = two;
                two = temp;
            }
        }

        public FactionHostilityPairKey(String one, String two) {
            this(Global.getSector().getFaction(one), Global.getSector().getFaction(two));
        }

        public FactionAPI getOne() {
            return this.one;
        }

        public FactionAPI getTwo() {
            return this.two;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.one == null ? 0 : this.one.hashCode());
            result = 31 * result + (this.two == null ? 0 : this.two.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FactionHostilityPairKey other = (FactionHostilityPairKey)obj;
            if (this.one == null ? other.one != null : this.one != other.one) {
                return false;
            }
            return !(this.two == null ? other.two != null : this.two != other.two);
        }
    }
}

