/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.impl.campaign.command.WarSimScript;
import com.fs.starfarer.api.impl.campaign.econ.ShippingDisruption;
import com.fs.starfarer.api.impl.campaign.fleets.BaseRouteFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.misc.TradeFleetDepartureIntel;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class EconomyFleetRouteManager
extends BaseRouteFleetManager
implements FleetEventListener {
    public static final Integer ROUTE_SRC_LOAD = 1;
    public static final Integer ROUTE_TRAVEL_DST = 2;
    public static final Integer ROUTE_TRAVEL_WS = 3;
    public static final Integer ROUTE_RESUPPLY_WS = 4;
    public static final Integer ROUTE_DST_UNLOAD = 5;
    public static final Integer ROUTE_DST_LOAD = 6;
    public static final Integer ROUTE_TRAVEL_BACK_WS = 7;
    public static final Integer ROUTE_RESUPPLY_BACK_WS = 8;
    public static final Integer ROUTE_TRAVEL_SRC = 9;
    public static final Integer ROUTE_SRC_UNLOAD = 10;
    public static final String SOURCE_ID = "econ";
    public static Logger log = Global.getLogger(EconomyFleetRouteManager.class);
    public static Map<WarSimScript.LocationDanger, Float> DANGER_LOSS_PROB = new HashMap<WarSimScript.LocationDanger, Float>();
    protected TimeoutTracker<String> recentlySentTradeFleet = new TimeoutTracker();

    static {
        DANGER_LOSS_PROB.put(WarSimScript.LocationDanger.NONE, Float.valueOf(0.01f));
        DANGER_LOSS_PROB.put(WarSimScript.LocationDanger.MINIMAL, Float.valueOf(0.03f));
        DANGER_LOSS_PROB.put(WarSimScript.LocationDanger.LOW, Float.valueOf(0.07f));
        DANGER_LOSS_PROB.put(WarSimScript.LocationDanger.MEDIUM, Float.valueOf(0.1f));
        DANGER_LOSS_PROB.put(WarSimScript.LocationDanger.HIGH, Float.valueOf(0.15f));
        DANGER_LOSS_PROB.put(WarSimScript.LocationDanger.EXTREME, Float.valueOf(0.2f));
    }

    public EconomyFleetRouteManager() {
        super(0.2f, 0.3f);
    }

    protected Object readResolve() {
        if (this.recentlySentTradeFleet == null) {
            this.recentlySentTradeFleet = new TimeoutTracker();
        }
        return this;
    }

    public void advance(float amount) {
        super.advance(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        this.recentlySentTradeFleet.advance(days);
    }

    protected String getRouteSourceId() {
        return SOURCE_ID;
    }

    protected int getMaxFleets() {
        int numMarkets = Global.getSector().getEconomy().getNumMarkets();
        int maxBasedOnMarkets = numMarkets * 2;
        return Math.min(maxBasedOnMarkets, Global.getSettings().getInt("maxEconFleets"));
    }

    protected void addRouteFleetIfPossible() {
        MarketAPI from = this.pickSourceMarket();
        MarketAPI to = this.pickDestMarket(from);
        if (from != null && to != null) {
            WarSimScript.LocationDanger danger;
            EconomyFleetAssignmentAI.EconomyRouteData data = EconomyFleetRouteManager.createData(from, to);
            if (data == null) {
                return;
            }
            log.info((Object)("Added trade fleet route from " + from.getName() + " to " + to.getName()));
            Long seed = Misc.genRandomSeed();
            String id = this.getRouteSourceId();
            RouteManager.OptionalFleetData extra = new RouteManager.OptionalFleetData(from);
            float tier = data.size;
            float stability = from.getStabilityValue();
            String factionId = from.getFactionId();
            if (!from.getFaction().isHostileTo("independent") && !to.getFaction().isHostileTo("independent") && (float)Math.random() * 10.0f > stability + tier) {
                factionId = "independent";
            }
            if (data.smuggling) {
                factionId = "independent";
            }
            extra.factionId = factionId;
            RouteManager.RouteData route = RouteManager.getInstance().addRoute(id, from, seed, extra, this);
            route.setCustom(data);
            StarSystemAPI sysFrom = data.from.getStarSystem();
            StarSystemAPI sysTo = data.to.getStarSystem();
            WarSimScript.LocationDanger dFrom = WarSimScript.getDangerFor(factionId, sysFrom);
            WarSimScript.LocationDanger dTo = WarSimScript.getDangerFor(factionId, sysTo);
            WarSimScript.LocationDanger locationDanger = danger = dFrom.ordinal() > dTo.ordinal() ? dFrom : dTo;
            if (sysFrom != null && sysFrom.isCurrentLocation()) {
                danger = WarSimScript.LocationDanger.NONE;
            }
            float pLoss = DANGER_LOSS_PROB.get((Object)danger).floatValue();
            if (data.smuggling) {
                pLoss = (float)((double)pLoss * 0.5);
            }
            if ((float)Math.random() < pLoss) {
                boolean returning = (float)Math.random() < 0.5f;
                EconomyFleetRouteManager.applyLostShipping(data, returning, true, true, true);
                RouteManager.getInstance().removeRoute(route);
                return;
            }
            float orbitDays = 2.0f + (float)Math.random() * 3.0f;
            orbitDays = data.size * (0.75f + (float)Math.random() * 0.5f);
            route.addSegment(new RouteManager.RouteSegment(ROUTE_SRC_LOAD, orbitDays, from.getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_TRAVEL_DST, from.getPrimaryEntity(), to.getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_DST_UNLOAD, orbitDays * 0.5f, to.getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_DST_LOAD, orbitDays * 0.5f, to.getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_TRAVEL_SRC, to.getPrimaryEntity(), from.getPrimaryEntity()));
            route.addSegment(new RouteManager.RouteSegment(ROUTE_SRC_UNLOAD, orbitDays, from.getPrimaryEntity()));
            this.setDelayAndSendMessage(route);
            this.recentlySentTradeFleet.add(from.getId(), Global.getSettings().getFloat("minEconSpawnIntervalPerMarket"));
        }
    }

    protected void setDelayAndSendMessage(RouteManager.RouteData route) {
        EconomyFleetAssignmentAI.EconomyRouteData data = (EconomyFleetAssignmentAI.EconomyRouteData)route.getCustom();
        float delay = 0.1f;
        delay = 10.0f;
        delay = data.size <= 4.0f ? 5.0f : (data.size <= 6.0f ? 10.0f : 15.0f);
        delay *= 0.75f + (float)Math.random() * 0.5f;
        delay = (int)delay;
        route.setDelay(delay);
        if (!"player".equals(route.getFactionId())) {
            new TradeFleetDepartureIntel(route);
        }
    }

    public MarketAPI pickSourceMarket() {
        WeightedRandomPicker<MarketAPI> markets = new WeightedRandomPicker<MarketAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.isHidden() || !market.hasSpaceport() || SharedData.getData().getMarketsWithoutTradeFleetSpawn().contains(market.getId()) || this.recentlySentTradeFleet.contains(market.getId())) continue;
            markets.add(market, market.getSize());
        }
        return (MarketAPI)markets.pick();
    }

    public MarketAPI pickDestMarket(MarketAPI from) {
        if (from == null) {
            return null;
        }
        WeightedRandomPicker<MarketAPI> markets = new WeightedRandomPicker<MarketAPI>();
        ArrayList<CommodityOnMarketAPI> relevant = new ArrayList<CommodityOnMarketAPI>();
        for (CommodityOnMarketAPI com : from.getAllCommodities()) {
            if (com.isNonEcon()) continue;
            int exported = Math.min(com.getAvailable(), com.getMaxSupply());
            int imported = Math.max(0, com.getMaxDemand() - exported);
            if (imported <= 0 && exported <= 0) continue;
            relevant.add(com);
        }
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsInGroup(from.getEconGroup())) {
            int shipping;
            if (market.isHidden() || !market.hasSpaceport() || SharedData.getData().getMarketsWithoutTradeFleetSpawn().contains(market.getId()) || market == from || (shipping = Misc.getShippingCapacity(market, market.getFaction() == from.getFaction())) <= 0) continue;
            float w = 0.0f;
            for (CommodityOnMarketAPI com : relevant) {
                int exported = Math.min(com.getAvailable(), com.getMaxSupply());
                exported = Math.min(exported, shipping);
                int imported = Math.max(0, com.getMaxDemand() - exported);
                imported = Math.min(imported, shipping);
                CommodityOnMarketAPI other = market.getCommodityData(com.getId());
                if ((exported = Math.min(exported, other.getMaxDemand() - other.getMaxSupply())) < 0) {
                    exported = 0;
                }
                imported = Math.min(imported, Math.min(other.getAvailable(), other.getMaxSupply()));
                w += (float)imported;
                w += (float)exported;
            }
            if (from.getFaction().isHostileTo(market.getFaction())) {
                w *= 0.25f;
            }
            markets.add(market, w);
        }
        return (MarketAPI)markets.pick();
    }

    public static EconomyFleetAssignmentAI.EconomyRouteData createData(MarketAPI from, MarketAPI to) {
        Object orig;
        EconomyFleetAssignmentAI.EconomyRouteData smuggling = new EconomyFleetAssignmentAI.EconomyRouteData();
        smuggling.from = from;
        smuggling.to = to;
        smuggling.smuggling = true;
        EconomyFleetAssignmentAI.EconomyRouteData legal = new EconomyFleetAssignmentAI.EconomyRouteData();
        legal.from = from;
        legal.to = to;
        legal.smuggling = false;
        float legalTotal = 0.0f;
        float smugglingTotal = 0.0f;
        ArrayList<Object> relevant = new ArrayList<Object>();
        for (CommodityOnMarketAPI com : from.getAllCommodities()) {
            int imported;
            if (com.isNonEcon()) continue;
            orig = com;
            int exported = Math.min(com.getAvailable(), com.getMaxSupply());
            if (!com.getCommodity().isPrimary()) {
                com = from.getCommodityData(com.getCommodity().getDemandClass());
            }
            if ((imported = Math.max(0, com.getMaxDemand() - exported)) <= 0 && exported <= 0) continue;
            relevant.add(orig);
        }
        int shipping = Misc.getShippingCapacity(from, to.getFaction() == from.getFaction());
        orig = relevant.iterator();
        while (orig.hasNext()) {
            boolean illegal;
            CommodityOnMarketAPI other;
            CommodityOnMarketAPI com;
            CommodityOnMarketAPI orig2 = com = (CommodityOnMarketAPI)orig.next();
            int exported = Math.min(com.getAvailable(), com.getMaxSupply());
            exported = Math.min(exported, shipping);
            if (!com.getCommodity().isPrimary()) {
                com = from.getCommodityData(com.getCommodity().getDemandClass());
            }
            int imported = Math.max(0, com.getMaxDemand() - exported);
            imported = Math.min(imported, shipping);
            if (orig2 != com) {
                imported = 0;
            }
            if ((exported = Math.min(exported, (other = to.getCommodityData(com.getId())).getMaxDemand() - other.getMaxSupply())) < 0) {
                exported = 0;
            }
            if ((imported = Math.min(imported, Math.min(other.getAvailable(), other.getMaxSupply()))) < 0) {
                imported = 0;
            }
            if (imported <= 0 && exported <= 0) continue;
            boolean bl = illegal = com.getCommodityMarketData().getMarketShareData(from).isSourceIsIllegal() || com.getCommodityMarketData().getMarketShareData(to).isSourceIsIllegal() || from.getFaction().isHostileTo(to.getFaction());
            if (imported > exported) {
                if (illegal) {
                    smuggling.addReturn(orig2.getId(), imported);
                    smugglingTotal += (float)imported;
                    continue;
                }
                legal.addReturn(orig2.getId(), imported);
                legalTotal += (float)imported;
                continue;
            }
            if (illegal) {
                smuggling.addDeliver(orig2.getId(), exported);
                smugglingTotal += (float)exported;
                continue;
            }
            legal.addDeliver(orig2.getId(), exported);
            legalTotal += (float)exported;
        }
        Comparator<EconomyFleetAssignmentAI.CargoQuantityData> comp = new Comparator<EconomyFleetAssignmentAI.CargoQuantityData>(){

            @Override
            public int compare(EconomyFleetAssignmentAI.CargoQuantityData o1, EconomyFleetAssignmentAI.CargoQuantityData o2) {
                if (o1.getCommodity().isPersonnel() && !o2.getCommodity().isPersonnel()) {
                    return 1;
                }
                if (o2.getCommodity().isPersonnel() && !o1.getCommodity().isPersonnel()) {
                    return -1;
                }
                return o2.units - o1.units;
            }
        };
        Collections.sort(legal.cargoDeliver, comp);
        Collections.sort(legal.cargoReturn, comp);
        Collections.sort(smuggling.cargoDeliver, comp);
        Collections.sort(smuggling.cargoReturn, comp);
        if (smugglingTotal <= 0.0f && legalTotal <= 0.0f) {
            return null;
        }
        EconomyFleetAssignmentAI.EconomyRouteData data = null;
        data = (float)Math.random() * (smugglingTotal + legalTotal) < smugglingTotal ? smuggling : legal;
        while (data.cargoDeliver.size() > 4) {
            data.cargoDeliver.remove(4);
        }
        while (data.cargoReturn.size() > 4) {
            data.cargoReturn.remove(4);
        }
        float max = 0.0f;
        for (EconomyFleetAssignmentAI.CargoQuantityData curr : data.cargoDeliver) {
            if (!((float)curr.units > max)) continue;
            max = curr.units;
        }
        for (EconomyFleetAssignmentAI.CargoQuantityData curr : data.cargoReturn) {
            if (!((float)curr.units > max)) continue;
            max = curr.units;
        }
        int types = Math.max(data.cargoDeliver.size(), data.cargoReturn.size());
        if (types >= 3) {
            data.size += 1.0f;
        }
        if (types >= 4) {
            data.size += 1.0f;
        }
        data.size = max;
        return data;
    }

    public boolean shouldCancelRouteAfterDelayCheck(RouteManager.RouteData route) {
        String factionId = route.getFactionId();
        boolean smuggling = false;
        if (route.getCustom() instanceof EconomyFleetAssignmentAI.EconomyRouteData) {
            smuggling = ((EconomyFleetAssignmentAI.EconomyRouteData)route.getCustom()).smuggling;
        }
        return factionId != null && route.getMarket() != null && !smuggling && route.getMarket().getFaction().isHostileTo(factionId);
    }

    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        CampaignFleetAPI fleet;
        Random random = new Random();
        if (route.getSeed() != null) {
            random = new Random(route.getSeed());
        }
        if ((fleet = EconomyFleetRouteManager.createTradeRouteFleet(route, random)) == null) {
            return null;
        }
        fleet.addEventListener(this);
        fleet.addScript(new EconomyFleetAssignmentAI(fleet, route));
        return fleet;
    }

    public static String getFleetTypeIdForTier(float tier, boolean smuggling) {
        String type = "trade";
        if (tier <= 3.0f) {
            type = "smallTrader";
        }
        if (smuggling) {
            type = "tradeSmuggler";
        }
        return type;
    }

    public static CampaignFleetAPI createTradeRouteFleet(RouteManager.RouteData route, Random random) {
        float cargoFraction;
        float personnelFraction;
        float fuelFraction;
        EconomyFleetAssignmentAI.EconomyRouteData data = (EconomyFleetAssignmentAI.EconomyRouteData)route.getCustom();
        MarketAPI from = data.from;
        MarketAPI to = data.to;
        float tier = data.size;
        if (data.smuggling && tier > 4.0f) {
            tier = 4.0f;
        }
        String factionId = route.getFactionId();
        float total = 0.0f;
        float fuel = 0.0f;
        float cargo = 0.0f;
        float personnel = 0.0f;
        ArrayList<EconomyFleetAssignmentAI.CargoQuantityData> all = new ArrayList<EconomyFleetAssignmentAI.CargoQuantityData>();
        all.addAll(data.cargoDeliver);
        all.addAll(data.cargoReturn);
        for (EconomyFleetAssignmentAI.CargoQuantityData curr : all) {
            CommoditySpecAPI spec = curr.getCommodity();
            if (spec.isMeta()) continue;
            total += (float)curr.units;
            if (spec.hasTag("personnel")) {
                personnel += (float)curr.units;
                continue;
            }
            if (spec.getId().equals("fuel")) {
                fuel += (float)curr.units;
                continue;
            }
            cargo += (float)curr.units;
        }
        if (total < 1.0f) {
            total = 1.0f;
        }
        if ((fuelFraction = fuel / total) + (personnelFraction = personnel / total) + (cargoFraction = cargo / total) > 0.0f) {
            float mult = 1.0f / (fuelFraction + personnelFraction + cargoFraction);
            fuelFraction *= mult;
            personnelFraction *= mult;
            cargoFraction *= mult;
        }
        log.info((Object)("Creating trade fleet of tier " + tier + " for market [" + from.getName() + "]"));
        float stabilityFactor = 1.0f + from.getStabilityValue() / 20.0f;
        float combat = Math.max(1.0f, tier * stabilityFactor * 0.5f) * 10.0f;
        float freighter = tier * 2.0f * cargoFraction * 3.0f;
        float tanker = tier * 2.0f * fuelFraction * 3.0f;
        float transport = tier * 2.0f * personnelFraction * 3.0f;
        float liner = 0.0f;
        float utility = 0.0f;
        String type = EconomyFleetRouteManager.getFleetTypeIdForTier(tier, data.smuggling);
        if (data.smuggling) {
            freighter *= 0.5f;
            tanker *= 0.5f;
            transport *= 0.5f;
            liner *= 0.5f;
        }
        FleetParamsV3 params = new FleetParamsV3(from, null, factionId, route.getQualityOverride(), type, combat, freighter, tanker, transport, liner, utility, 0.0f);
        params.timestamp = route.getTimestamp();
        params.onlyApplyFleetSizeToCombatShips = true;
        params.maxShipSize = 3;
        params.officerLevelBonus = -2;
        params.officerNumberMult = 0.5f;
        params.random = random;
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet(params);
        if (fleet == null || fleet.isEmpty()) {
            return null;
        }
        if (Misc.isPirateFaction(fleet.getFaction())) {
            fleet.getMemoryWithoutUpdate().set("$forceTOff", true);
        }
        if (data.smuggling) {
            fleet.getMemoryWithoutUpdate().set("$isSmuggler", true);
            Misc.makeLowRepImpact(fleet, "smuggler");
        } else {
            fleet.getMemoryWithoutUpdate().set("$isTradeFleet", true);
        }
        data.cargoCap = fleet.getCargo().getMaxCapacity();
        data.fuelCap = fleet.getCargo().getMaxFuel();
        data.personnelCap = fleet.getCargo().getMaxPersonnel();
        return fleet;
    }

    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        boolean lostPersonnel;
        RouteManager.RouteData route = RouteManager.getInstance().getRoute(this.getRouteSourceId(), fleet);
        if (route == null || !(route.getCustom() instanceof EconomyFleetAssignmentAI.EconomyRouteData)) {
            return;
        }
        if (route.isExpired()) {
            return;
        }
        EconomyFleetAssignmentAI.EconomyRouteData data = (EconomyFleetAssignmentAI.EconomyRouteData)route.getCustom();
        float cargoCap = fleet.getCargo().getMaxCapacity();
        float fuelCap = fleet.getCargo().getMaxFuel();
        float personnelCap = fleet.getCargo().getMaxPersonnel();
        float lossFraction = 0.34f;
        boolean returning = false;
        if (route.getCurrent() != null && route.getCurrentSegmentId() >= ROUTE_DST_LOAD) {
            returning = true;
        }
        boolean lostCargo = data.cargoCap * lossFraction > cargoCap;
        boolean lostFuel = data.fuelCap * lossFraction > fuelCap;
        boolean bl = lostPersonnel = data.personnelCap * lossFraction > personnelCap;
        if (lostCargo) {
            data.cargoCap = 0.0f;
        }
        if (lostFuel) {
            data.fuelCap = 0.0f;
        }
        if (lostPersonnel) {
            data.personnelCap = 0.0f;
        }
        EconomyFleetRouteManager.applyLostShipping(data, returning, lostCargo, lostFuel, lostPersonnel);
        boolean allThreeLost = true;
        allThreeLost &= data.cargoCap <= 0.0f || lostCargo;
        allThreeLost &= data.fuelCap <= 0.0f || lostFuel;
        boolean applyAccessLoss = allThreeLost &= data.personnelCap <= 0.0f || lostPersonnel;
        if (applyAccessLoss) {
            ShippingDisruption.getDisruption(data.from).addShippingLost(data.size);
            ShippingDisruption.getDisruption(data.from).notifyDisrupted(ShippingDisruption.ACCESS_LOSS_DURATION);
        }
    }

    public static void applyLostShipping(EconomyFleetAssignmentAI.EconomyRouteData data, boolean returning, boolean cargo, boolean fuel, boolean personnel) {
        CommodityOnMarketAPI com;
        if (!(cargo || fuel || personnel)) {
            return;
        }
        boolean penalty = true;
        int penalty2 = 2;
        if (!returning) {
            for (EconomyFleetAssignmentAI.CargoQuantityData curr : data.cargoDeliver) {
                com = data.to.getCommodityData(curr.cargo);
                if (!fuel && com.isFuel() || !personnel && com.isPersonnel() || !cargo && !com.isFuel() && !com.isPersonnel()) continue;
                com.getAvailableStat().addTemporaryModFlat(ShippingDisruption.ACCESS_LOSS_DURATION, String.valueOf(ShippingDisruption.COMMODITY_LOSS_PREFIX) + Misc.genUID(), "Recent incoming shipment lost", -penalty2);
                ShippingDisruption.getDisruption(data.to).notifyDisrupted(ShippingDisruption.ACCESS_LOSS_DURATION);
            }
        }
        for (EconomyFleetAssignmentAI.CargoQuantityData curr : data.cargoReturn) {
            com = data.from.getCommodityData(curr.cargo);
            if (!fuel && com.isFuel() || !personnel && com.isPersonnel() || !cargo && !com.isFuel() && !com.isPersonnel()) continue;
            com.getAvailableStat().addTemporaryModFlat(ShippingDisruption.ACCESS_LOSS_DURATION, String.valueOf(ShippingDisruption.COMMODITY_LOSS_PREFIX) + Misc.genUID(), "Recent incoming shipment lost", -penalty2);
            ShippingDisruption.getDisruption(data.from).notifyDisrupted(ShippingDisruption.ACCESS_LOSS_DURATION);
        }
    }

    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    public boolean shouldRepeat(RouteManager.RouteData route) {
        return false;
    }

    public void reportAboutToBeDespawnedByRouteManager(RouteManager.RouteData route) {
    }
}

