/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.BaseLimitedFleetManager;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;

public class LuddicPathFleetManager
extends BaseLimitedFleetManager {
    protected int getMaxFleets() {
        int count = 0;
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            String fid = market.getFactionId();
            if (!fid.equals("luddic_church") && !fid.equals("luddic_path") && !fid.equals("knights_of_ludd")) continue;
            count += market.getSize();
        }
        return count;
    }

    protected CampaignFleetAPI spawnFleet() {
        StarSystemAPI target = this.pickTargetSystem();
        return null;
    }

    protected StarSystemAPI pickTargetSystem() {
        WeightedRandomPicker<StarSystemAPI> picker = new WeightedRandomPicker<StarSystemAPI>();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            if (system.hasTag("system_cut_off_from_hyper")) continue;
            float mult = Misc.getSpawnChanceMult(system.getLocation());
            float weight = 0.0f;
            for (MarketAPI market : Misc.getMarketsInLocation(system)) {
                float w;
                if (market.getFactionId().equals("luddic_church") || market.getFactionId().equals("luddic_path") || market.getFactionId().equals("knights_of_ludd") || !((w = 11.0f - market.getStabilityValue() + (float)market.getSize()) > weight)) continue;
                weight = w;
            }
            picker.add(system, weight *= mult);
        }
        return (StarSystemAPI)picker.pick();
    }
}

