/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactory;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolAssignmentAI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.RollingAverageTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector2f;

public class PatrolFleetManager
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static Logger log = Global.getLogger(PatrolFleetManager.class);
    private MarketAPI market;
    private List<PatrolFleetData> activePatrols = new ArrayList<PatrolFleetData>();
    private IntervalUtil tracker;
    private int maxPatrols;
    private RollingAverageTracker patrolBattlesLost;

    public PatrolFleetManager(MarketAPI market) {
        super(true);
        this.market = market;
        float interval = Global.getSettings().getFloat("averagePatrolSpawnInterval");
        this.tracker = new IntervalUtil(interval * 0.75f, interval * 1.25f);
        this.readResolve();
    }

    protected Object readResolve() {
        if (this.patrolBattlesLost == null) {
            float patrolStrengthCheckInterval = Global.getSettings().getFloat("economyIntervalnGameDays");
            float min = patrolStrengthCheckInterval - Math.min(patrolStrengthCheckInterval * 0.5f, 2.0f);
            float max = patrolStrengthCheckInterval + Math.min(patrolStrengthCheckInterval * 0.5f, 2.0f);
            this.patrolBattlesLost = new RollingAverageTracker(min, max, Misc.getGenericRollingAverageFactor());
        }
        return this;
    }

    public void advance(float amount) {
        boolean hasStationOrSpaceport;
        float days = Global.getSector().getClock().convertToDays(amount);
        this.patrolBattlesLost.advance(days);
        float losses = this.patrolBattlesLost.getAverage();
        this.tracker.advance(days * Math.max(1.0f, losses));
        if (!this.tracker.intervalElapsed()) {
            return;
        }
        if (this.market.hasCondition("decivilized")) {
            return;
        }
        ArrayList<PatrolFleetData> remove = new ArrayList<PatrolFleetData>();
        for (PatrolFleetData data : this.activePatrols) {
            if (data.fleet.getContainingLocation() != null && data.fleet.getContainingLocation().getFleets().contains(data.fleet)) continue;
            remove.add(data);
            log.info((Object)("Cleaning up orphaned patrol [" + data.fleet.getNameWithFaction() + "] for market [" + this.market.getName() + "]"));
        }
        this.activePatrols.removeAll(remove);
        this.maxPatrols = (int)((float)Math.max(1, this.market.getSize() - 3) * (this.market.getStabilityValue() / 10.0f)) + (int)Math.max(0.0f, Math.min(losses, 5.0f));
        if (this.maxPatrols < 1) {
            this.maxPatrols = 1;
        }
        boolean bl = hasStationOrSpaceport = this.market.hasIndustry("orbitalstation") || this.market.hasSpaceport() || this.market.hasIndustry("battlestation");
        if (this.market.hasIndustry("militarybase")) {
            ++this.maxPatrols;
            if (hasStationOrSpaceport) {
                ++this.maxPatrols;
            }
        }
        if (hasStationOrSpaceport) {
            ++this.maxPatrols;
        }
        log.debug((Object)"");
        log.debug((Object)("Checking whether to spawn patrol for market [" + this.market.getName() + "]"));
        if (this.activePatrols.size() < this.maxPatrols) {
            FleetFactory.PatrolType type;
            CampaignFleetAPI fleet;
            log.info((Object)(String.valueOf(this.activePatrols.size()) + " out of a maximum " + this.maxPatrols + " patrols in play for market [" + this.market.getName() + "]"));
            WeightedRandomPicker<FleetFactory.PatrolType> picker = new WeightedRandomPicker<FleetFactory.PatrolType>();
            picker.add(FleetFactory.PatrolType.FAST, Math.max(1, this.maxPatrols - this.getCount(FleetFactory.PatrolType.COMBAT, FleetFactory.PatrolType.HEAVY)));
            picker.add(FleetFactory.PatrolType.COMBAT, (float)Math.max(1, this.maxPatrols - this.getCount(FleetFactory.PatrolType.FAST, FleetFactory.PatrolType.HEAVY) + this.market.getSize()) + losses);
            if (this.market.getSize() >= 5) {
                picker.add(FleetFactory.PatrolType.HEAVY, (float)Math.max(1, this.maxPatrols - this.getCount(FleetFactory.PatrolType.FAST, FleetFactory.PatrolType.COMBAT) + this.market.getSize()) + losses * 2.0f);
            }
            if ((fleet = PatrolFleetManager.createPatrolFleet(type = (FleetFactory.PatrolType)((Object)picker.pick()), this.market, null, null, losses)) == null) {
                return;
            }
            SectorEntityToken entity = this.market.getPrimaryEntity();
            entity.getContainingLocation().addEntity(fleet);
            fleet.setLocation(entity.getLocation().x, entity.getLocation().y);
            PatrolFleetData data = new PatrolFleetData(fleet, type);
            data.startingFleetPoints = fleet.getFleetPoints();
            data.sourceMarket = this.market;
            this.activePatrols.add(data);
            PatrolAssignmentAI ai = new PatrolAssignmentAI(fleet, data);
            fleet.addScript(ai);
            log.info((Object)("Spawned patrol fleet [" + fleet.getNameWithFaction() + "] from market " + this.market.getName()));
        } else {
            log.debug((Object)("Maximum number of " + this.maxPatrols + " patrols already in play for market [" + this.market.getName() + "]"));
        }
    }

    public static CampaignFleetAPI createPatrolFleet(FleetFactory.PatrolType type, MarketAPI market, String factionId, Vector2f locInHyper, float losses) {
        FleetParamsV3 params;
        CampaignFleetAPI fleet;
        float combat = 0.0f;
        float tanker = 0.0f;
        float freighter = 0.0f;
        String fleetType = "patrolSmall";
        switch (type) {
            case FAST: {
                fleetType = "patrolSmall";
                combat = Math.round(3.0f + (float)Math.random() * 2.0f);
                combat += Math.min(5.0f, losses * 2.0f);
                break;
            }
            case COMBAT: {
                fleetType = "patrolMedium";
                combat = Math.round(6.0f + (float)Math.random() * 3.0f);
                combat += Math.min(25.0f, losses * 8.0f);
                tanker = Math.round((float)Math.random());
                break;
            }
            case HEAVY: {
                fleetType = "patrolLarge";
                combat = Math.round(10.0f + (float)Math.random() * 5.0f);
                combat += Math.min(40.0f, losses * 12.0f);
                tanker = 2.0f;
                freighter = 2.0f;
            }
        }
        combat = market != null ? (combat *= 1.0f + market.getStabilityValue() / 20.0f) : (combat *= 1.25f);
        combat *= 4.0f;
        tanker *= 4.0f;
        freighter *= 4.0f;
        if (market != null && factionId == null) {
            factionId = market.getFactionId();
        }
        if ((fleet = FleetFactoryV3.createFleet(params = new FleetParamsV3(market, locInHyper, factionId, null, fleetType, combat, freighter, tanker, 0.0f, 0.0f, 0.0f, 0.0f))) == null) {
            return null;
        }
        fleet.getMemoryWithoutUpdate().set("$isPatrol", true);
        if (type == FleetFactory.PatrolType.FAST || type == FleetFactory.PatrolType.COMBAT) {
            fleet.getMemoryWithoutUpdate().set("$isCustomsInspector", true);
        }
        fleet.getCommander().setPostId(Ranks.POST_PATROL_COMMANDER);
        switch (type) {
            case FAST: {
                fleet.getCommander().setRankId(Ranks.SPACE_LIEUTENANT);
                break;
            }
            case COMBAT: {
                fleet.getCommander().setRankId(Ranks.SPACE_COMMANDER);
                break;
            }
            case HEAVY: {
                fleet.getCommander().setRankId(Ranks.SPACE_CAPTAIN);
            }
        }
        return fleet;
    }

    private int getCount(FleetFactory.PatrolType ... types) {
        int count = 0;
        FleetFactory.PatrolType[] patrolTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            FleetFactory.PatrolType type = patrolTypeArray[n2];
            for (PatrolFleetData data : this.activePatrols) {
                if (data.type != type) continue;
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public void reportFleetDespawned(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        super.reportFleetDespawned(fleet, reason, param);
        for (PatrolFleetData data : this.activePatrols) {
            if (data.fleet != fleet) continue;
            this.activePatrols.remove(data);
            break;
        }
    }

    public void reportBattleOccurred(CampaignFleetAPI primaryWinner, BattleAPI battle) {
        super.reportBattleOccurred(primaryWinner, battle);
        boolean playerWon = battle.isPlayerSide(battle.getSideFor(primaryWinner));
        boolean playerLost = battle.isPlayerSide(battle.getOtherSideFor(primaryWinner));
        if (primaryWinner.isInOrNearSystem(this.market.getStarSystem())) {
            if (primaryWinner.getFaction().getId().equals("pirates")) {
                return;
            }
            if (primaryWinner.getFaction().getId().equals("luddic_path")) {
                return;
            }
            for (CampaignFleetAPI loser : battle.getOtherSideSnapshotFor(primaryWinner)) {
                if (loser.getFaction() == this.market.getFaction()) {
                    if (!playerWon) continue;
                    this.patrolBattlesLost.add(1.0f);
                    continue;
                }
                if (primaryWinner.getFaction() != this.market.getFaction()) continue;
                if (loser.getFaction().getId().equals("pirates")) {
                    return;
                }
                if (loser.getFaction().getId().equals("luddic_path")) {
                    return;
                }
                if (!playerLost) continue;
                this.patrolBattlesLost.sub(1.0f);
            }
        }
    }

    public static class PatrolFleetData {
        public float startingFleetPoints = 0.0f;
        public CampaignFleetAPI fleet;
        public FleetFactory.PatrolType type;
        public MarketAPI sourceMarket;

        public PatrolFleetData(CampaignFleetAPI fleet, FleetFactory.PatrolType type) {
            this.fleet = fleet;
            this.type = type;
        }
    }
}

