/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.PilgrimageFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RouteFleetAssignmentAI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.List;

public class PilgrimageFleetAssignmentAI
extends RouteFleetAssignmentAI {
    private String origFaction;
    private IntervalUtil factionChangeTracker = new IntervalUtil(0.1f, 0.3f);

    public PilgrimageFleetAssignmentAI(CampaignFleetAPI fleet, RouteManager.RouteData route) {
        super(fleet, route);
        this.origFaction = route.getFactionId();
        if (!this.getData().smuggling) {
            this.origFaction = null;
            this.factionChangeTracker = null;
        } else {
            this.factionChangeTracker.forceIntervalElapsed();
            this.doSmugglingFactionChangeCheck(0.1f);
        }
    }

    protected String getStartingActionText(RouteManager.RouteSegment segment) {
        return "preparing for pilgrimage to shrine on " + this.getData().to.getName();
    }

    protected String getEndingActionText(RouteManager.RouteSegment segment) {
        return "disembarking pilgrims at " + this.getData().from.getName();
    }

    protected String getTravelActionText(RouteManager.RouteSegment segment) {
        Integer id = segment.getId();
        if (id == PilgrimageFleetRouteManager.ROUTE_TRAVEL_DST) {
            return "taking pilgrims to shrine on " + this.getData().to.getName();
        }
        if (id == PilgrimageFleetRouteManager.ROUTE_TRAVEL_SRC) {
            return "returning pilgrims to " + this.getData().from.getName();
        }
        return super.getTravelActionText(segment);
    }

    protected String getInSystemActionText(RouteManager.RouteSegment segment) {
        Integer id = segment.getId();
        if (id == PilgrimageFleetRouteManager.ROUTE_DST_UNLOAD) {
            return "disembarking pilgrims at shrine on " + this.getData().to.getName();
        }
        if (id == PilgrimageFleetRouteManager.ROUTE_DST_LOAD) {
            return "embarking pilgrims for return voyage to " + this.getData().from.getName();
        }
        return super.getInSystemActionText(segment);
    }

    protected PilgrimageRouteData getData() {
        PilgrimageRouteData data = (PilgrimageRouteData)this.route.getCustom();
        return data;
    }

    public void advance(float amount) {
        super.advance(amount);
        this.doSmugglingFactionChangeCheck(amount);
    }

    public void doSmugglingFactionChangeCheck(float amount) {
        PilgrimageRouteData data = this.getData();
        if (!data.smuggling) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.factionChangeTracker.advance(days);
        if (this.factionChangeTracker.intervalElapsed() && this.fleet.getAI() != null) {
            String targetFac;
            List<MarketAPI> markets = Misc.getMarketsInLocation(this.fleet.getContainingLocation());
            MarketAPI align = null;
            int max = 0;
            for (MarketAPI market : markets) {
                int size;
                if (!market.getFaction().isHostileTo(data.factionId) || (size = market.getSize()) <= max) continue;
                max = size;
                align = market;
            }
            if (align == null || this.fleet.isInHyperspace() || this.fleet.getContainingLocation() == data.from.getContainingLocation()) {
                align = data.from;
            }
            if (align != null) {
                targetFac = this.origFaction;
                boolean hostile = align.getFaction().isHostileTo(targetFac);
                if (hostile) {
                    targetFac = "independent";
                    hostile = align.getFaction().isHostileTo(targetFac);
                }
                if (hostile) {
                    targetFac = align.getFactionId();
                }
                if (!this.fleet.getFaction().getId().equals(targetFac)) {
                    this.fleet.setFaction(targetFac, true);
                }
            } else {
                targetFac = this.origFaction;
                if (this.fleet.isInHyperspace()) {
                    targetFac = "independent";
                }
                if (!this.fleet.getFaction().getId().equals(targetFac)) {
                    this.fleet.setFaction(targetFac, true);
                }
            }
        }
    }

    public static class PilgrimageRouteData {
        public boolean smuggling = false;
        public MarketAPI from;
        public SectorEntityToken to;
        public float size;
        public String factionId;
    }
}

