/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.impl.campaign.fleets.BaseLimitedFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.DisposableFleetManager;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.Iterator;

public abstract class PlayerVisibleFleetManager
extends BaseLimitedFleetManager {
    protected IntervalUtil despawnTracker = new IntervalUtil(0.75f, 1.25f);

    protected Object readResolve() {
        super.readResolve();
        if (this.despawnTracker == null) {
            this.despawnTracker = new IntervalUtil(0.75f, 1.25f);
        }
        return this;
    }

    public void advance(float amount) {
        super.advance(amount);
        boolean reset = false;
        if (reset && this instanceof DisposableFleetManager) {
            DisposableFleetManager dfm = (DisposableFleetManager)this;
            dfm.recentSpawns.clear();
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.despawnTracker.advance(days);
        if (this.despawnTracker.intervalElapsed()) {
            Iterator iter = this.active.iterator();
            while (iter.hasNext()) {
                BaseLimitedFleetManager.ManagedFleetData curr = (BaseLimitedFleetManager.ManagedFleetData)iter.next();
                if (!reset && (this.isVisibleToPlayer(curr.fleet) || !this.isOkToDespawnAssumingNotPlayerVisible(curr.fleet)) || curr.fleet.getBattle() != null) continue;
                curr.fleet.despawn(CampaignEventListener.FleetDespawnReason.PLAYER_FAR_AWAY, null);
                iter.remove();
            }
        }
    }

    protected abstract boolean isOkToDespawnAssumingNotPlayerVisible(CampaignFleetAPI var1);

    protected boolean isVisibleToPlayer(CampaignFleetAPI fleet) {
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return false;
        }
        if (player.getContainingLocation() != fleet.getContainingLocation()) {
            float dist = Misc.getDistance(player.getLocationInHyperspace(), fleet.getLocationInHyperspace());
            return dist < this.getHyperspaceCullRange();
        }
        float cullRange = player.getMaxSensorRangeToDetect(fleet) + this.getInSystemCullRange();
        float dist = Misc.getDistance(player.getLocation(), fleet.getLocation());
        return dist < cullRange;
    }

    protected float getHyperspaceCullRange() {
        return 1500.0f;
    }

    protected float getInSystemCullRange() {
        return 500.0f;
    }
}

