/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.abilities.InterdictionPulseAbility;
import com.fs.starfarer.api.impl.campaign.ghosts.GBGoAwayFrom;
import com.fs.starfarer.api.impl.campaign.ghosts.GBStayInPlace;
import com.fs.starfarer.api.impl.campaign.ghosts.GhostBehavior;
import com.fs.starfarer.api.impl.campaign.ghosts.GhostBehaviorInterrupt;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.ghosts.SpeedReduction;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.SmoothMovementUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSensorGhost
implements SensorGhost {
    protected CustomCampaignEntityAPI entity;
    protected float despawnRange = 100.0f;
    protected boolean despawnOutsideSector = true;
    protected boolean fleeing = false;
    protected int fleeBurnLevel = 30;
    protected float accelMult = 1.0f;
    protected transient boolean creationFailed = false;
    protected SmoothMovementUtil movement = new SmoothMovementUtil();
    protected List<GhostBehavior> script = new ArrayList<GhostBehavior>();
    protected SensorGhostManager manager;

    public BaseSensorGhost(SensorGhostManager manager, int fleeBurnLevel) {
        this.manager = manager;
        this.fleeBurnLevel = fleeBurnLevel;
    }

    protected Object readResolve() {
        if (this.movement == null) {
            this.movement = new SmoothMovementUtil();
        }
        return this;
    }

    @Override
    public void addBehavior(GhostBehavior b) {
        this.script.add(b);
    }

    public void addInterrupt(GhostBehaviorInterrupt interrupt) {
        if (this.script.isEmpty()) {
            return;
        }
        this.script.get(this.script.size() - 1).addInterrupt(interrupt);
    }

    @Override
    public float getDespawnRange() {
        return this.despawnRange;
    }

    @Override
    public void setDespawnRange(float despawnRange) {
        this.despawnRange = despawnRange;
    }

    public Random getRandom() {
        Random random = Misc.random;
        if (this.manager != null) {
            random = this.manager.getRandom();
        }
        return random;
    }

    public float genSmallSensorProfile() {
        return 700.0f + this.getRandom().nextFloat() * 300.0f;
    }

    public float genMediumSensorProfile() {
        return 1000.0f + this.getRandom().nextFloat() * 500.0f;
    }

    public float genLargeSensorProfile() {
        return 1500.0f + this.getRandom().nextFloat() * 500.0f;
    }

    public float genHugeSensorProfile() {
        return 2500.0f + this.getRandom().nextFloat() * 1000.0f;
    }

    public float genTinyRadius() {
        return 10.0f + this.getRandom().nextFloat() * 5.0f;
    }

    public float genVerySmallRadius() {
        return 20.0f + this.getRandom().nextFloat() * 10.0f;
    }

    public float genSmallRadius() {
        return 22.0f + this.getRandom().nextFloat() * 28.0f;
    }

    public float genMediumRadius() {
        return 50.0f + this.getRandom().nextFloat() * 25.0f;
    }

    public float genLargeRadius() {
        return 75.0f + this.getRandom().nextFloat() * 25.0f;
    }

    public float genFloat(float min, float max) {
        return min + (max - min) * this.getRandom().nextFloat();
    }

    public float genInt(int min, int max) {
        return min + this.getRandom().nextInt(max - min + 1);
    }

    public float genDelay(float base) {
        return base * (0.75f + 0.5f * this.getRandom().nextFloat());
    }

    public boolean placeNearPlayer() {
        return this.placeNearPlayer(1400.0f, 2200.0f);
    }

    public boolean placeNearPlayer(float minDist, float maxDist) {
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        Random random = this.getRandom();
        Vector2f loc = new Vector2f();
        int i = 0;
        while (i < 20) {
            float r = minDist + random.nextFloat() * (maxDist - minDist);
            loc = Misc.getPointAtRadius(pf.getLocation(), r, random);
            if (!Misc.isInsideSlipstream(loc, 500.0f, pf.getContainingLocation())) break;
            ++i;
        }
        if (Misc.isInsideSlipstream(loc, 500.0f, pf.getContainingLocation())) {
            return false;
        }
        this.getMovement().getLocation().set((ReadableVector2f)loc);
        this.entity.getLocation().set((ReadableVector2f)this.movement.getLocation());
        this.entity.getVelocity().set((ReadableVector2f)this.movement.getVelocity());
        return true;
    }

    public void placeNearEntity(SectorEntityToken entity, float minDist, float maxDist) {
        Random random = this.getRandom();
        Vector2f loc = new Vector2f();
        float r = minDist + random.nextFloat() * (maxDist - minDist);
        loc = Misc.getPointAtRadius(entity.getLocation(), r, random);
        this.getMovement().getLocation().set((ReadableVector2f)loc);
        entity.getLocation().set((ReadableVector2f)this.movement.getLocation());
        entity.getVelocity().set((ReadableVector2f)this.movement.getVelocity());
    }

    public void setLoc(Vector2f loc) {
        this.getMovement().getLocation().set((ReadableVector2f)loc);
        this.entity.getLocation().set((ReadableVector2f)this.movement.getLocation());
    }

    public void setVel(Vector2f vel) {
        this.getMovement().getVelocity().set((ReadableVector2f)vel);
        this.entity.getVelocity().set((ReadableVector2f)this.movement.getVelocity());
    }

    public void initEntity(float sensorProfile, float radius) {
        float maxFleetRadius = Global.getSettings().getFloat("maxFleetSelectionRadius");
        int extraInds = 0;
        if (radius > maxFleetRadius) {
            extraInds = Math.round((radius - maxFleetRadius) / 20.0f);
        }
        this.initEntity(sensorProfile, radius, extraInds);
    }

    public void initEntity(float sensorProfile, float radius, int extraSensorInds) {
        this.initEntity(sensorProfile, radius, extraSensorInds, Global.getSector().getHyperspace());
    }

    public void initEntity(float sensorProfile, float radius, int extraSensorInds, LocationAPI where) {
        this.entity = where.addCustomEntity(null, null, "sensor_ghost", "neutral");
        this.entity.setDiscoverable(true);
        this.entity.setSensorProfile(Float.valueOf(sensorProfile));
        this.entity.setDiscoveryXP(Float.valueOf(0.0f));
        this.entity.setDetectionRangeDetailsOverrideMult(Float.valueOf(-100.0f));
        this.entity.setRadius(radius);
        this.entity.forceSensorFaderOut();
        this.despawnRange = Math.max(100.0f, sensorProfile * 0.25f);
        this.despawnRange = 100.0f;
        if (extraSensorInds > 0) {
            this.entity.getMemoryWithoutUpdate().set("$extraSensorIndicators", extraSensorInds);
        }
    }

    public void setNumSensorIndicators(int min, int max, Random random) {
        if (random == null) {
            random = Misc.random;
        }
        int num = min + random.nextInt(max - min + 1);
        this.entity.getMemoryWithoutUpdate().set("$sensorIndicatorsOverride", num);
    }

    protected void reportDespawning(DespawnReason reason, Object param) {
    }

    @Override
    public void advance(float amount) {
        if (this.entity == null) {
            return;
        }
        if (!this.entity.hasTag("fading_out_and_expiring")) {
            if (this.script.isEmpty() || this.despawnOutsideSector && Misc.isOutsideSector(this.entity.getLocation())) {
                Misc.fadeAndExpire(this.entity, 1.0f);
                this.reportDespawning(DespawnReason.SCRIPT_ENDED, null);
                this.entity = null;
                return;
            }
            for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
                float dist = Misc.getDistance(this.entity, fleet);
                if (!((dist -= this.entity.getRadius() + fleet.getRadius()) < this.despawnRange)) continue;
                Misc.fadeAndExpire(this.entity, 1.0f);
                this.reportDespawning(DespawnReason.FLEET_IN_RANGE, fleet);
                this.entity = null;
                return;
            }
        }
        if (this.fleeBurnLevel > 0 && !this.fleeing && Global.getSector().getMemoryWithoutUpdate().getBoolean("$interdictionPulseJustUsed") && this.entity.getContainingLocation() != null) {
            for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
                float range = InterdictionPulseAbility.getRange(fleet);
                float dist = Misc.getDistance(fleet.getLocation(), this.entity.getLocation());
                if (dist > range || !fleet.getMemoryWithoutUpdate().getBoolean("$justDidInterdictionPulse")) continue;
                this.fleeing = true;
                this.script.clear();
                this.entity.addScript(new SpeedReduction(this.entity, 0.75f));
                this.addBehavior(new GBStayInPlace(0.1f + 0.2f * Misc.random.nextFloat()));
                this.addBehavior(new GBGoAwayFrom(3.0f + Misc.random.nextFloat() * 2.0f, fleet, this.fleeBurnLevel));
                break;
            }
        }
        if (!this.script.isEmpty()) {
            GhostBehavior curr = this.script.get(0);
            curr.advance(amount, this);
            if (curr.isDone()) {
                this.script.remove(curr);
            }
        }
        this.movement.advance(amount);
        this.entity.getLocation().set((ReadableVector2f)this.movement.getLocation());
        this.entity.getVelocity().set((ReadableVector2f)this.movement.getVelocity());
    }

    public float getAccelMult() {
        return this.accelMult;
    }

    public void setAccelMult(float accelMult) {
        this.accelMult = accelMult;
    }

    @Override
    public void moveTo(Vector2f dest, float maxBurn) {
        this.moveTo(dest, null, maxBurn);
    }

    @Override
    public void moveTo(Vector2f dest, Vector2f destVel, float maxBurn) {
        float speed = Misc.getSpeedForBurnLevel(maxBurn);
        float accelMult = speed / Misc.getSpeedForBurnLevel(20.0f);
        if (accelMult < 0.5f) {
            accelMult = 0.5f;
        }
        if (accelMult > 10.0f) {
            accelMult = 10.0f;
        }
        this.movement.setAcceleration(speed * accelMult * this.accelMult);
        this.movement.setMaxSpeed(speed);
        this.movement.setDest(dest, destVel);
    }

    @Override
    public int getMaxBurn() {
        return (int)Misc.getBurnLevelForSpeed(this.movement.getMaxSpeed());
    }

    @Override
    public int getCurrBurn() {
        return (int)Misc.getBurnLevelForSpeed(this.entity.getVelocity().length());
    }

    @Override
    public float getAcceleration() {
        return this.movement.getAcceleration();
    }

    @Override
    public SmoothMovementUtil getMovement() {
        return this.movement;
    }

    @Override
    public CustomCampaignEntityAPI getEntity() {
        return this.entity;
    }

    @Override
    public boolean isDone() {
        return this.entity == null;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    public boolean isDespawnOutsideSector() {
        return this.despawnOutsideSector;
    }

    public void setDespawnOutsideSector(boolean despawnOutsideSector) {
        this.despawnOutsideSector = despawnOutsideSector;
    }

    @Override
    public boolean isCreationFailed() {
        return this.creationFailed;
    }

    public void setCreationFailed() {
        this.creationFailed = true;
        if (this.entity != null && this.entity.getContainingLocation() != null) {
            this.entity.getContainingLocation().removeEntity(this.entity);
        }
    }

    @Override
    public List<GhostBehavior> getScript() {
        return this.script;
    }

    @Override
    public void clearScript() {
        this.script.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DespawnReason {
        FLEET_IN_RANGE,
        SCRIPT_ENDED;

    }
}

