/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseGhostBehaviorInterrupt;
import com.fs.starfarer.api.impl.campaign.ghosts.GhostBehavior;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class GBIGenerateSlipstream
extends BaseGhostBehaviorInterrupt
implements EveryFrameScript {
    protected boolean addedScript = false;
    protected float minWidth;
    protected float maxWidth;
    protected int burnLevel;
    protected SensorGhost ghost;
    protected GhostBehavior behavior;
    protected float widenRate = 50.0f;
    protected int maxSegments = 20;
    protected float duration;
    protected CampaignTerrainAPI slipstream = null;
    protected SlipstreamTerrainPlugin2 plugin = null;
    protected Vector2f prev = null;

    public GBIGenerateSlipstream(float minWidth, float maxWidth, int burnLevel, float widenRate, int maxSegments, float duration) {
        super(0.0f);
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.burnLevel = burnLevel;
        this.widenRate = widenRate;
        this.maxSegments = maxSegments;
        this.duration = duration;
    }

    public boolean shouldInterruptBehavior(SensorGhost ghost, GhostBehavior behavior) {
        return false;
    }

    public void advance(float amount, SensorGhost ghost, GhostBehavior behavior) {
        this.behavior = behavior;
        if (!this.addedScript) {
            if (ghost != null && ghost.getEntity() != null && ghost.getEntity().getContainingLocation() != null) {
                this.ghost = ghost;
                ghost.getEntity().addScript(this);
                ghost.getEntity().addTag("unaffected_by_slipstream");
            }
            this.addedScript = true;
        }
    }

    public boolean isDone() {
        return this.duration <= 0.0f;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.duration -= days;
        if (this.ghost.getEntity() == null || this.ghost.getEntity().getContainingLocation() == null || this.duration <= 0.0f) {
            if (!this.plugin.isDespawning()) {
                this.plugin.despawn(0.0f, 1.0f + Misc.random.nextFloat(), Misc.random);
            }
            return;
        }
        Vector2f loc = this.ghost.getEntity().getLocation();
        boolean forceAdd = false;
        if (this.slipstream == null) {
            SlipstreamTerrainPlugin2.SlipstreamParams2 params = new SlipstreamTerrainPlugin2.SlipstreamParams2();
            params.burnLevel = this.burnLevel;
            params.widthForMaxSpeed = this.minWidth + this.widenRate * 5.0f;
            params.minSpeed = Misc.getSpeedForBurnLevel(params.burnLevel - 5);
            params.maxSpeed = Misc.getSpeedForBurnLevel(params.burnLevel + 5);
            params.lineLengthFractionOfSpeed = 0.25f * Math.max(0.25f, Math.min(1.0f, 30.0f / (float)params.burnLevel));
            this.slipstream = (CampaignTerrainAPI)this.ghost.getEntity().getContainingLocation().addTerrain("slipstream", params);
            this.slipstream.setLocation(loc.x, loc.y);
            this.plugin = (SlipstreamTerrainPlugin2)this.slipstream.getPlugin();
            this.plugin.setDynamic(true);
            this.prev = new Vector2f((ReadableVector2f)loc);
            forceAdd = true;
            if (this.behavior instanceof GhostBehaviorWithSlipstream) {
                GhostBehaviorWithSlipstream b = (GhostBehaviorWithSlipstream)((Object)this.behavior);
                b.setSlipstream(this.plugin);
            }
        }
        float distPerSegment = 300.0f;
        float dist = Misc.getDistance(loc, this.prev);
        if (dist >= distPerSegment || forceAdd) {
            float width = this.minWidth + (this.maxWidth - this.minWidth) * Misc.random.nextFloat();
            this.plugin.addSegment(loc, width);
            this.prev = new Vector2f((ReadableVector2f)loc);
            List<SlipstreamTerrainPlugin2.SlipstreamSegment> segments = this.plugin.getSegments();
            if (segments.size() == 1) {
                segments.get((int)0).bMult = 0.0f;
                segments.get((int)0).fader.forceOut();
            } else {
                segments.get((int)(segments.size() - 1)).fader.forceOut();
            }
            ArrayList<SlipstreamTerrainPlugin2.SlipstreamSegment> remove = new ArrayList<SlipstreamTerrainPlugin2.SlipstreamSegment>();
            int i = 0;
            while (i < segments.size() - this.maxSegments - 1) {
                SlipstreamTerrainPlugin2.SlipstreamSegment curr = segments.get(i);
                SlipstreamTerrainPlugin2.SlipstreamSegment next = segments.get(i + 1);
                curr.fader.setDurationOut(3.0f);
                curr.fader.fadeOut();
                if (curr.fader.isFadedOut() && next.fader.isFadedOut()) {
                    remove.add(curr);
                }
                ++i;
            }
            this.plugin.recompute();
        }
        List<SlipstreamTerrainPlugin2.SlipstreamSegment> segments = this.plugin.getSegments();
        float fadeInDist = Math.min(this.minWidth * 4.0f, distPerSegment * (float)this.maxSegments / 4.0f);
        int i = Math.max(0, segments.size() - this.maxSegments);
        while (i < segments.size() - 1) {
            SlipstreamTerrainPlugin2.SlipstreamSegment curr = segments.get(i);
            SlipstreamTerrainPlugin2.SlipstreamSegment next = segments.get(i + 1);
            if (!curr.fader.isFadedOut()) {
                dist = Misc.getDistance(this.ghost.getEntity().getLocation(), curr.loc);
                float b = dist / fadeInDist;
                if (b < 0.0f) {
                    b = 0.0f;
                }
                if (b > 1.0f) {
                    b = 1.0f;
                }
                curr.bMult = b;
            }
            if (next.fader.getBrightness() == 0.0f && !next.fader.isFadingOut()) {
                float durIn = distPerSegment / Math.max(this.ghost.getEntity().getVelocity().length(), 1.0f);
                if (durIn > 2.0f) {
                    durIn = 2.0f;
                }
                curr.fader.setDurationIn(durIn *= 2.0f);
                curr.fader.fadeIn();
            }
            curr.width += this.widenRate * amount;
            ++i;
        }
    }

    public static interface GhostBehaviorWithSlipstream {
        public void setSlipstream(SlipstreamTerrainPlugin2 var1);
    }
}

