/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.impl.campaign.abilities.EmergencyBurnAbility;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIPlaySound;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIntercept;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.loading.AbilitySpecAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;

public class ChargerGhost
extends BaseSensorGhost {
    public ChargerGhost(SensorGhostManager manager, CampaignFleetAPI fleet) {
        super(manager, 0);
        float speed;
        float accelMult;
        int maxBurn;
        Random random = manager.getRandom();
        float r = random.nextFloat();
        if (r < 0.25f) {
            this.initEntity(this.genMediumSensorProfile(), this.genSmallRadius());
            maxBurn = 9 + random.nextInt(3);
        } else if (r < 0.6f) {
            this.initEntity(this.genLargeSensorProfile(), this.genMediumRadius());
            maxBurn = 8 + random.nextInt(3);
        } else {
            this.initEntity(this.genLargeSensorProfile(), this.genLargeRadius());
            maxBurn = 7 + random.nextInt(3);
        }
        if (!this.placeNearPlayer()) {
            this.setCreationFailed();
            return;
        }
        this.setDespawnRange(0.0f);
        String soundId = null;
        AbilitySpecAPI spec = Global.getSettings().getAbilitySpec("emergency_burn");
        if (spec != null) {
            soundId = spec.getWorldOn();
        }
        if ((accelMult = (speed = Misc.getSpeedForBurnLevel(maxBurn)) / Misc.getSpeedForBurnLevel(20.0f)) < 0.1f) {
            accelMult = 0.1f;
        }
        this.setAccelMult(1.0f / accelMult);
        float eBurnRange = 800.0f + random.nextFloat() * 200.0f;
        this.addBehavior(new GBIntercept(fleet, 5.0f + random.nextFloat() * 2.0f, maxBurn, eBurnRange, true));
        this.addBehavior(new GBIntercept(fleet, 3.0f + random.nextFloat() * 2.0f, maxBurn + Math.round(EmergencyBurnAbility.MAX_BURN_MOD), 0.0f, true));
        if (soundId != null) {
            this.addInterrupt(new GBIPlaySound(0.0f, soundId, 1.0f, 1.0f));
        }
    }
}

