/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.enc.BaseEPEncounterCreator;
import com.fs.starfarer.api.impl.campaign.fleets.AutoDespawnScript;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.GhostFrequencies;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.ghosts.types.EncounterTricksterGhost;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncounterTricksterGhostCreator
extends BaseSensorGhostCreator {
    @Override
    public List<SensorGhost> createGhost(SensorGhostManager manager) {
        if (!Global.getSector().getCurrentLocation().isHyperspace()) {
            return null;
        }
        Random random = manager.getRandom();
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        LocationAPI hyper = Global.getSector().getCurrentLocation();
        Vector2f loc = EncounterTricksterGhostCreator.findHyperspaceArea(pf.getLocation(), 3000.0f, 4000.0f, 1000.0f, random, true, 3000.0f);
        if (loc == null) {
            return null;
        }
        CampaignFleetAPI other = this.createOtherFleet(manager, pf.getLocation());
        if (other == null) {
            return null;
        }
        hyper.addEntity(other);
        other.setLocation(loc.x, loc.y);
        other.addScript(new AutoDespawnScript(other));
        boolean guideToTarget = manager.getRandom().nextBoolean();
        ArrayList<SensorGhost> result = new ArrayList<SensorGhost>();
        EncounterTricksterGhost g = new EncounterTricksterGhost(manager, other, guideToTarget);
        if (g.isCreationFailed()) {
            hyper.removeEntity(other);
            return null;
        }
        result.add(g);
        return result;
    }

    @Override
    public float getFrequency(SensorGhostManager manager) {
        return GhostFrequencies.getEncounterTricksterFrequency(manager);
    }

    public CampaignFleetAPI createOtherFleet(SensorGhostManager manager, Vector2f locInHyper) {
        Random random = manager.getRandom();
        PirateBaseIntel intel = BaseEPEncounterCreator.getClosestPirateBase(locInHyper);
        float f1 = BaseEPEncounterCreator.getPirateBaseProximityFactor(intel, locInHyper);
        LuddicPathBaseIntel intel2 = BaseEPEncounterCreator.getClosestLuddicPathBase(locInHyper);
        float f2 = BaseEPEncounterCreator.getLuddicPathBaseProximityFactor(intel2, locInHyper);
        float result = Math.max(f1, f2);
        StarSystemAPI ruins = BaseEPEncounterCreator.getClosestSystemWithRuins(locInHyper);
        float f3 = BaseEPEncounterCreator.getRuinsProximityFactor(ruins, locInHyper);
        result = Math.max(result, f3 *= 0.25f);
        WeightedRandomPicker<OtherFleetType> picker = new WeightedRandomPicker<OtherFleetType>(random);
        picker.add(OtherFleetType.PIRATE, f1 + 0.1f);
        picker.add(OtherFleetType.LUDDIC_PATH, f2 + 0.05f);
        picker.add(OtherFleetType.MERCENARY, (f1 + f2) * 0.25f + 0.01f);
        picker.add(OtherFleetType.NOTHING, 1.0f);
        OtherFleetType type = (OtherFleetType)((Object)picker.pick());
        if (type == null) {
            return null;
        }
        SectorEntityToken fleet = null;
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        if (type == OtherFleetType.PIRATE) {
            String factionId = "pirates";
            if (intel != null && intel.getMarket() != null) {
                factionId = intel.getMarket().getFactionId();
            }
            int difficulty = 0;
            if (intel != null) {
                difficulty += Math.round(f1 * 2.0f);
                if (intel != null) {
                    switch (intel.getTier()) {
                        case TIER_1_1MODULE: {
                            difficulty += 2;
                            break;
                        }
                        case TIER_2_1MODULE: {
                            difficulty += 2;
                            break;
                        }
                        case TIER_3_2MODULE: {
                            difficulty += 3;
                            break;
                        }
                        case TIER_4_3MODULE: {
                            difficulty += 4;
                            break;
                        }
                        case TIER_5_3MODULE: {
                            difficulty += 5;
                        }
                    }
                }
                difficulty += random.nextInt(4);
            } else {
                difficulty += 4;
                difficulty += random.nextInt(7);
            }
            Vector2f loc = locInHyper;
            m.createStandardFleet(difficulty, factionId, loc);
            m.triggerSetStandardAggroPirateFlags();
            m.triggerFleetAllowLongPursuit();
            if (intel != null && intel.getMarket() != null) {
                m.triggerSetFleetMemoryValue("$sourceMarket", intel.getMarket().getId());
            }
            fleet = m.createFleet();
        } else if (type == OtherFleetType.LUDDIC_PATH) {
            int difficulty = 0;
            if (intel2 != null) {
                difficulty += Math.round(f2 * 2.0f);
                difficulty = intel2.isLarge() ? (difficulty += 5) : (difficulty += 3);
                difficulty += random.nextInt(4);
            } else {
                difficulty += 4;
                difficulty += random.nextInt(7);
            }
            Vector2f loc = locInHyper;
            m.createStandardFleet(difficulty, "luddic_path", loc);
            m.triggerSetStandardAggroPirateFlags();
            m.triggerFleetAllowLongPursuit();
            if (intel2 != null && intel2.getMarket() != null) {
                m.triggerSetFleetMemoryValue("$sourceMarket", intel2.getMarket().getId());
            }
            fleet = m.createFleet();
        } else if (type == OtherFleetType.MERCENARY) {
            int difficulty = 3;
            float f = Math.max(f1, f2);
            difficulty += Math.round(f * 3.0f);
            Vector2f loc = locInHyper;
            m.createQualityFleet(difficulty += random.nextInt(5), "mercenary", loc);
            m.triggerFleetAllowLongPursuit();
            m.triggerSetFleetFaction("independent");
            m.triggerMakeNoRepImpact();
            m.triggerFleetSetAllWeapons();
            fleet = m.createFleet();
        } else if (type == OtherFleetType.NOTHING) {
            return null;
        }
        if (fleet == null) {
            return null;
        }
        fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
        fleet.addScript(new MissionFleetAutoDespawn(null, (CampaignFleetAPI)fleet));
        return fleet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OtherFleetType {
        PIRATE,
        LUDDIC_PATH,
        MERCENARY,
        NOTHING;

    }
}

