/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.GBFollowStream;
import com.fs.starfarer.api.impl.campaign.ghosts.GBGoInDirection;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class RacerGhost
extends BaseSensorGhost {
    public RacerGhost(SensorGhostManager manager, SlipstreamTerrainPlugin2.SlipstreamSegment segment, SlipstreamTerrainPlugin2 plugin) {
        super(manager, 20);
        this.initEntity(this.genLargeSensorProfile(), this.genSmallRadius());
        this.setDespawnRange(-this.entity.getRadius() * 0.5f);
        Random random = manager.getRandom();
        float offset = (random.nextBoolean() ? 1.0f : -1.0f) * random.nextFloat() * 0.5f;
        Vector2f loc = plugin.getPointAt(segment.totalLength, offset);
        if (loc == null) {
            this.setCreationFailed();
            return;
        }
        this.setLoc(loc);
        float intensity = plugin.getIntensity(offset);
        float wMult = plugin.getWidthBasedSpeedMult(segment.totalLength);
        float b = plugin.getFaderBrightness(segment.totalLength);
        float speedMult = intensity * wMult * b;
        float speed = Misc.getSpeedForBurnLevel(plugin.getParams().burnLevel);
        Vector2f vel = new Vector2f((ReadableVector2f)segment.dir);
        vel.scale(speed * speedMult);
        this.setVel(vel);
        int burn = 17 + random.nextInt(15);
        float dur = 5.0f + 3.0f * random.nextFloat();
        this.addBehavior(new GBFollowStream(dur, burn, plugin));
        this.addBehavior(new GBGoInDirection(dur * 0.5f, random.nextFloat() * 360.0f, burn));
    }
}

