/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.GhostFrequencies;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.ghosts.types.RacerGhost;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RacerGhostCreator
extends BaseSensorGhostCreator {
    @Override
    public List<SensorGhost> createGhost(SensorGhostManager manager) {
        if (!Global.getSector().getCurrentLocation().isHyperspace()) {
            return null;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        Vector2f loc = pf.getLocation();
        float radius = 1000.0f;
        SlipstreamTerrainPlugin2 plugin = RacerGhostCreator.pickNearbySlipstream(radius, manager.getRandom());
        if (plugin == null) {
            return null;
        }
        float[] coords = plugin.getLengthAndWidthFractionWithinStream(loc, 0.0f, false, radius);
        if (coords == null) {
            return null;
        }
        SlipstreamTerrainPlugin2.SlipstreamSegment start = plugin.getSegmentForDist(coords[0]);
        if (start == null) {
            return null;
        }
        List<SlipstreamTerrainPlugin2.SlipstreamSegment> segments = plugin.getSegments();
        ArrayList<SensorGhost> result = new ArrayList<SensorGhost>();
        int num = 1 + manager.getRandom().nextInt(5);
        float distBehind = 1000.0f;
        float currDist = 0.0f;
        int i = start.index - 1;
        while ((float)i >= 0.0f && num > 0) {
            SlipstreamTerrainPlugin2.SlipstreamSegment curr = segments.get(i);
            currDist += curr.lengthToNext;
            float b = plugin.getFaderBrightness(coords[0]);
            if (currDist > distBehind && b > 0.0f) {
                --num;
                RacerGhost g = new RacerGhost(manager, curr, plugin);
                if (!g.isCreationFailed()) {
                    result.add(g);
                    distBehind += 500.0f * manager.getRandom().nextFloat();
                }
            }
            --i;
        }
        return result;
    }

    @Override
    public float getFrequency(SensorGhostManager manager) {
        return GhostFrequencies.getRacerFrequency(manager);
    }

    @Override
    public boolean canSpawnWhilePlayerInOrNearSlipstream() {
        return true;
    }
}

