/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEventManager
implements EveryFrameScript {
    protected List<EveryFrameScript> active = new ArrayList<EveryFrameScript>();
    protected IntervalUtil tracker;
    protected IntervalUtil trackerMax;
    protected int currMax = 0;
    protected Random randomBase = new Random();

    public BaseEventManager() {
        float interval = this.getBaseInterval();
        this.tracker = new IntervalUtil(interval * 0.75f, interval * 1.25f);
        interval = this.getUpdateMaxInterval();
        this.trackerMax = new IntervalUtil(interval * 0.75f, interval * 1.25f);
        this.updateMax();
        this.readResolve();
    }

    protected void updateMax() {
        int min = this.getMinConcurrent();
        int max = this.getMaxConcurrent();
        this.currMax = min + this.randomBase.nextInt(max - min + 1);
    }

    protected Object readResolve() {
        if (this.randomBase == null) {
            this.randomBase = new Random();
        }
        return this;
    }

    protected abstract int getMinConcurrent();

    protected abstract int getMaxConcurrent();

    protected abstract EveryFrameScript createEvent();

    protected float getUpdateMaxInterval() {
        return 10.0f;
    }

    protected float getBaseInterval() {
        return 1.0f;
    }

    protected float getIntervalRateMult() {
        return 1.0f;
    }

    protected int getHardLimit() {
        return Global.getSector().getEconomy().getNumMarkets() * 2;
    }

    @Override
    public void advance(float amount) {
        int count;
        int count2;
        float days = Global.getSector().getClock().convertToDays(amount);
        this.trackerMax.advance(days);
        if (this.trackerMax.intervalElapsed() && ((count2 = this.getActiveCount()) <= this.currMax || count2 == 0)) {
            if (this.randomBase.nextFloat() < 0.05f) {
                this.updateMax();
            } else {
                this.currMax = this.randomBase.nextFloat() < 0.5f ? --this.currMax : ++this.currMax;
                int min = this.getMinConcurrent();
                int max = this.getMaxConcurrent();
                if (this.currMax < min) {
                    this.currMax = min;
                }
                if (this.currMax > max) {
                    this.currMax = max;
                }
            }
            int limit = this.getHardLimit();
            if (this.currMax > limit) {
                this.currMax = limit;
            }
        }
        ArrayList<EveryFrameScript> remove = new ArrayList<EveryFrameScript>();
        for (EveryFrameScript event : this.active) {
            event.advance(amount);
            if (!event.isDone()) continue;
            remove.add(event);
        }
        this.active.removeAll(remove);
        if (Global.getSettings().isDevMode() && (count = this.getActiveCount()) <= 0) {
            days *= 1000.0f;
        }
        this.tracker.advance(days * this.getIntervalRateMult());
        if (this instanceof PirateBaseManager && DebugFlags.RAID_DEBUG) {
            this.tracker.advance(days * 1000000.0f);
        }
        if (this instanceof LuddicPathBaseManager && DebugFlags.PATHER_BASE_DEBUG) {
            this.tracker.advance(days * 1000000.0f);
        }
        if (!this.tracker.intervalElapsed()) {
            return;
        }
        count = this.getActiveCount();
        if (count < this.currMax) {
            EveryFrameScript event = this.createEvent();
            this.addActive(event);
        }
    }

    public int getActiveCount() {
        int count = 0;
        for (EveryFrameScript s : this.active) {
            BaseIntelPlugin intel;
            if (s instanceof BaseIntelPlugin && (intel = (BaseIntelPlugin)s).isEnding()) continue;
            ++count;
        }
        return count;
    }

    public int getOngoing() {
        return this.active.size();
    }

    public int getCurrMax() {
        return this.currMax;
    }

    public boolean belowMax() {
        return this.getCurrMax() > this.getOngoing();
    }

    public void addActive(EveryFrameScript event) {
        if (event != null) {
            this.active.add(event);
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    public List<EveryFrameScript> getActive() {
        return this.active;
    }

    public IntervalUtil getTracker() {
        return this.tracker;
    }
}

