/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.ImportantPeopleAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.BaseMissionIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeDataForSubmarket;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcurementMissionIntel
extends BaseMissionIntel {
    public static final String PERSON_CHECKOUT_REASON = "MPM_mission_contact";
    public static String BUTTON_COMMODITY_INFO = "Show commodity info";
    public static Logger log = Global.getLogger(ProcurementMissionIntel.class);
    protected MarketAPI market;
    protected PersonAPI contact;
    protected float quantity;
    protected float pricePerUnit;
    protected boolean contactWillInitiateComms = false;
    protected CommodityOnMarketAPI commodity;
    protected float baseReward;

    public ProcurementMissionIntel() {
        float basePerUnit;
        String commodityId = this.pickCommodity();
        if (commodityId == null) {
            this.endMission();
            this.endImmediately();
            return;
        }
        this.quantity = this.getQuantity(commodityId);
        float illegalMult = 0.2f;
        float min = 10.0f;
        this.market = this.pickMarket(commodityId, this.quantity, illegalMult, min);
        if (this.market == null) {
            this.endMission();
            this.endImmediately();
            return;
        }
        this.commodity = this.market.getCommodityData(commodityId);
        this.quantity = (int)this.getQuantityAdjustedForMarket(commodityId, this.quantity, illegalMult, min, this.market);
        if (this.quantity <= 0.0f) {
            this.endMission();
            this.endImmediately();
            return;
        }
        WeightedRandomPicker<Float> durationPicker = new WeightedRandomPicker<Float>();
        durationPicker.add(Float.valueOf(20.0f));
        durationPicker.add(Float.valueOf(30.0f));
        durationPicker.add(Float.valueOf(40.0f));
        durationPicker.add(Float.valueOf(60.0f));
        this.setDuration((Float)durationPicker.pick());
        this.baseReward = this.market.getDemandPrice(commodityId, this.quantity, false);
        float minReward = 7500.0f + (float)Math.random() * 5000.0f;
        if (this.baseReward < minReward) {
            this.quantity *= minReward / this.baseReward;
            if (this.quantity > 5000.0f) {
                this.quantity = 5000.0f;
            }
            this.quantity = (int)this.quantity / 10 * 10;
            if (this.quantity <= 0.0f) {
                this.endMission();
                this.endImmediately();
                return;
            }
            this.baseReward = this.market.getDemandPrice(commodityId, this.quantity, false);
        }
        if (this.baseReward < (basePerUnit = this.market.getCommodityData(commodityId).getCommodity().getBasePrice()) * this.quantity) {
            this.baseReward = basePerUnit * this.quantity;
        }
        float maxQuantity = 10000.0f;
        float maxDuration = 60.0f;
        float durationBonus = Math.min(this.baseReward / this.quantity * (0.5f * (2.0f - Math.min(1.0f, this.duration.floatValue() / maxDuration))), 300.0f);
        float quantityBonus = Math.min(this.baseReward / this.quantity * (0.5f * (2.0f - Math.min(1.0f, this.quantity / maxQuantity))), 300.0f);
        if (durationBonus < 10.0f) {
            durationBonus = 10.0f;
        }
        if (quantityBonus < 10.0f) {
            quantityBonus = 10.0f;
        }
        this.contact = this.pickContact(this.market, this.market.getCommodityData(commodityId));
        Global.getSector().getImportantPeople().checkOutPerson(this.contact, PERSON_CHECKOUT_REASON);
        boolean illegal = this.contact.getFaction().isHostileTo(this.market.getFaction());
        this.baseReward = illegal ? (this.baseReward *= 3.0f) : (this.baseReward *= 2.0f);
        this.pricePerUnit = (int)(this.baseReward / this.quantity);
        if (this.pricePerUnit < 10.0f) {
            this.pricePerUnit = 10.0f;
        }
        log.info((Object)("Created ProcurementMissionIntel: " + commodityId + " to " + this.market.getName()));
        this.initRandomCancel();
        this.setPostingLocation(this.market.getPrimaryEntity());
        Global.getSector().getIntelManager().queueIntel(this);
    }

    @Override
    public void missionAccepted() {
        this.market.getCommDirectory().addPerson(this.contact);
        this.contact.getMemoryWithoutUpdate().set("$mpm_isPlayerContact", true, this.duration.floatValue());
        this.contact.getMemoryWithoutUpdate().set("$mpm_eventRef", this, this.duration.floatValue());
        this.contact.getMemoryWithoutUpdate().set("$mpm_commodityName", this.commodity.getCommodity().getName().toLowerCase(), this.duration.floatValue());
        this.contact.getMemoryWithoutUpdate().set("$mpm_quantity", Misc.getWithDGS((int)this.quantity), this.duration.floatValue());
        Misc.setFlagWithReason(this.contact.getMemoryWithoutUpdate(), "$requiresDiscretionToDeal", "mpm_" + this.commodity.getId(), true, this.duration.floatValue());
        Misc.setFlagWithReason(this.contact.getMemoryWithoutUpdate(), "$missionImportant", "mpm", true, this.duration.floatValue());
        this.contactWillInitiateComms = (float)Math.random() > 0.5f;
        boolean illegal = this.contact.getFaction().isHostileTo(this.market.getFaction());
        if (illegal) {
            this.contactWillInitiateComms = false;
        }
        if (this.contactWillInitiateComms) {
            this.contact.incrWantsToContactReasons();
        }
    }

    protected PersonAPI pickContact(MarketAPI market, CommodityOnMarketAPI com) {
        Global.getSettings().profilerBegin(String.valueOf(this.getClass().getSimpleName()) + ".pickContact()");
        PersonAPI contact = null;
        ImportantPeopleAPI ip = Global.getSector().getImportantPeople();
        String comId = com.getId();
        if (market.getFaction().isPlayerFaction()) {
            contact = ProcurementMissionIntel.getCriminal(market, PERSON_CHECKOUT_REASON, "pirates").getPerson();
        }
        if (contact == null && com.getCommodity().hasTag("military")) {
            contact = (float)Math.random() > 0.1f ? ip.getPerson(market.getFaction(), market, PERSON_CHECKOUT_REASON, Ranks.GROUND_LIEUTENANT, Ranks.POST_SUPPLY_OFFICER, Ranks.POST_BASE_COMMANDER, Ranks.POST_OUTPOST_COMMANDER, Ranks.POST_PORTMASTER).getPerson() : ProcurementMissionIntel.getCriminal(market, PERSON_CHECKOUT_REASON, "pirates").getPerson();
        }
        if (contact == null && com.getCommodity().hasTag("medical")) {
            contact = (float)Math.random() > 0.25f ? ip.getPerson((float)Math.random() > 0.5f ? "independent" : market.getFactionId(), market, PERSON_CHECKOUT_REASON, Ranks.CITIZEN, Ranks.POST_MEDICAL_SUPPLIER).getPerson() : ProcurementMissionIntel.getCriminal(market, PERSON_CHECKOUT_REASON, "pirates").getPerson();
        }
        if (contact == null && com.getCommodity().hasTag("luxury")) {
            contact = (float)Math.random() > 0.1f && !market.isIllegal(comId) ? ProcurementMissionIntel.getLegitTrader(market, PERSON_CHECKOUT_REASON, market.getFactionId()).getPerson() : ProcurementMissionIntel.getCriminal(market, PERSON_CHECKOUT_REASON, "pirates").getPerson();
        }
        if (contact == null) {
            contact = (float)Math.random() > 0.05f && !market.isIllegal(comId) ? ProcurementMissionIntel.getLegitTrader(market, PERSON_CHECKOUT_REASON, market.getFactionId()).getPerson() : ProcurementMissionIntel.getCriminal(market, PERSON_CHECKOUT_REASON, "pirates").getPerson();
        }
        if (contact == null) {
            contact = market.getFaction().createRandomPerson();
            contact.setPostId(Ranks.POST_CITIZEN);
            contact.setRankId(null);
            market.addPerson(contact);
            ip.addPerson(contact);
            ip.getData(contact).getLocation().setMarket(market);
        }
        Global.getSettings().profilerEnd();
        return contact;
    }

    public static ImportantPeopleAPI.PersonDataAPI getLegitTrader(MarketAPI market, String checkoutReason, String factionId) {
        ImportantPeopleAPI ip = Global.getSector().getImportantPeople();
        return ip.getPerson(factionId, market, checkoutReason, Ranks.CITIZEN, Ranks.POST_MERCHANT, Ranks.POST_COMMODITIES_AGENT, Ranks.POST_INVESTOR, Ranks.POST_TRADER);
    }

    public static ImportantPeopleAPI.PersonDataAPI getCriminal(MarketAPI market, String checkoutReason, String factionId) {
        ImportantPeopleAPI ip = Global.getSector().getImportantPeople();
        return ip.getPerson(factionId, market, checkoutReason, Ranks.CITIZEN, Ranks.POST_GANGSTER, Ranks.POST_SMUGGLER, Ranks.POST_FENCE);
    }

    protected String pickCommodity() {
        Global.getSettings().profilerBegin(String.valueOf(this.getClass().getSimpleName()) + ".pickCommodity()");
        EconomyAPI economy = Global.getSector().getEconomy();
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>();
        for (String curr : economy.getAllCommodityIds()) {
            CommoditySpecAPI spec = economy.getCommoditySpec(curr);
            if (spec.isMeta() || spec.hasTag("crew") || spec.hasTag("marines") || spec.hasTag("nonecon")) continue;
            float weight = 1.0f;
            picker.add(curr, weight);
        }
        Global.getSettings().profilerEnd();
        return (String)picker.pick();
    }

    protected int getQuantity(String commodityId) {
        CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(commodityId);
        float cargoCapacity = 30.0f;
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player != null) {
            if ("fuel".equals(commodityId)) {
                float f = cargoCapacity;
                cargoCapacity = player.getCargo().getMaxFuel();
                cargoCapacity = Math.max(f, cargoCapacity);
            } else {
                cargoCapacity = Math.max(cargoCapacity, player.getCargo().getMaxCapacity());
            }
        }
        CommoditySpecAPI fuel = Global.getSettings().getCommoditySpec("fuel");
        float targetValue = cargoCapacity * Math.max(5.0f, fuel.getBasePrice());
        float units = targetValue / Math.max(5.0f, spec.getBasePrice());
        return (int)(units *= 0.5f + (float)Math.random()) / 10 * 10;
    }

    protected float getQuantityAdjustedForMarket(String commodityId, float quantity, float illegalMult, float min, MarketAPI market) {
        boolean illegal;
        if (market.getSize() <= 4) {
            quantity = Math.min(quantity, 200.0f);
        } else if (market.getSize() == 5) {
            quantity = Math.min(quantity, 500.0f);
        } else if (market.getSize() == 6) {
            quantity = Math.min(quantity, 1000.0f);
        } else if (market.getSize() == 7) {
            quantity = Math.min(quantity, 2000.0f);
        } else if (market.getSize() >= 8) {
            quantity = Math.min(quantity, 10000.0f);
        }
        CommodityOnMarketAPI com = market.getCommodityData(commodityId);
        if (com.getUtilityOnMarket() > 0.0f) {
            quantity /= com.getUtilityOnMarket();
        }
        if ((illegal = market.isIllegal(commodityId)) && (quantity *= illegalMult) < min) {
            quantity = min;
        }
        return (int)quantity;
    }

    protected MarketAPI pickMarket(String commodityId, float quantity, float illegalMult, float min) {
        Global.getSettings().profilerBegin(String.valueOf(this.getClass().getSimpleName()) + ".pickMarket()");
        EconomyAPI economy = Global.getSector().getEconomy();
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>();
        for (MarketAPI market : economy.getMarketsCopy()) {
            if (market.isHidden() || market.isPlayerOwned()) continue;
            boolean illegal = market.isIllegal(commodityId);
            float test = this.getQuantityAdjustedForMarket(commodityId, quantity, illegalMult, min, market);
            if (illegal && (test *= illegalMult) < min) {
                test = min;
            }
            if (this.doNearbyMarketsHave(market, commodityId, test * 0.5f)) continue;
            float weight = market.getSize();
            if (market.getFaction().isPlayerFaction()) {
                weight *= 0.1f;
            }
            picker.add(market, weight);
        }
        Global.getSettings().profilerEnd();
        return (MarketAPI)picker.pick();
    }

    protected boolean doNearbyMarketsHave(MarketAPI from, String commodityId, float minQty) {
        if (from.getContainingLocation() == null) {
            return false;
        }
        for (MarketAPI curr : Misc.getMarketsInLocation(from.getContainingLocation())) {
            CommodityOnMarketAPI com;
            int a;
            float dist;
            if (curr.getPrimaryEntity() != null && from.getPrimaryEntity() != null && (dist = Misc.getDistance(curr.getPrimaryEntity().getLocation(), from.getPrimaryEntity().getLocation())) > 10000.0f || (a = (com = curr.getCommodityData(commodityId)).getAvailable()) <= 0) continue;
            float limit = BaseIndustry.getSizeMult(a);
            if ((limit *= com.getCommodity().getEconUnit()) * 0.5f >= minQty) {
                return true;
            }
            for (SubmarketAPI submarket : curr.getSubmarketsCopy()) {
                CargoAPI cargo;
                if (!submarket.getPlugin().isParticipatesInEconomy() || (cargo = submarket.getCargoNullOk()) == null || !(cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, commodityId) >= minQty * 0.5f)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void advanceMission(float amount) {
        if (!this.market.isInEconomy()) {
            this.setMissionResult(new BaseMissionIntel.MissionResult(0, null, null));
            this.setMissionState(BaseMissionIntel.MissionState.FAILED);
            this.endMission();
        }
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        String commodityId = this.commodity.getId();
        if (action.equals("performDelivery")) {
            cargo.removeItems(CargoAPI.CargoItemType.RESOURCES, commodityId, this.quantity);
            int reward = (int)this.baseReward;
            cargo.getCredits().add(reward);
            AddRemoveCommodity.addCommodityLossText(commodityId, (int)this.quantity, dialog.getTextPanel());
            AddRemoveCommodity.addCreditsGainText(reward, dialog.getTextPanel());
            this.applyTradeValueImpact(reward);
            float repAmount = 0.01f * this.baseReward / 100000.0f;
            if (repAmount < 0.01f) {
                repAmount = 0.01f;
            }
            if (repAmount > 0.05f) {
                repAmount = 0.05f;
            }
            CoreReputationPlugin.MissionCompletionRep completionRep = new CoreReputationPlugin.MissionCompletionRep(repAmount, RepLevel.WELCOMING, -repAmount, RepLevel.INHOSPITABLE);
            ReputationActionResponsePlugin.ReputationAdjustmentResult repF = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_SUCCESS, (Object)completionRep, null, dialog.getTextPanel(), true, true), this.contact.getFaction().getId());
            ReputationActionResponsePlugin.ReputationAdjustmentResult repC = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_SUCCESS, (Object)completionRep, null, dialog.getTextPanel(), true, true), this.contact);
            this.setMissionResult(new BaseMissionIntel.MissionResult(reward, repF, repC));
            this.setMissionState(BaseMissionIntel.MissionState.COMPLETED);
        } else {
            if (action.equals("hasEnough")) {
                return cargo.getCommodityQuantity(commodityId) >= this.quantity;
            }
            if (action.equals("endEvent")) {
                this.endMission();
            } else if (action.equals("hasBonus")) {
                return this.hasBonus();
            }
        }
        return true;
    }

    protected boolean hasBonus() {
        return false;
    }

    protected void applyTradeValueImpact(float totalReward) {
        boolean illegal = this.contact.getFaction().isHostileTo(this.market.getFaction());
        SubmarketAPI submarket = null;
        for (SubmarketAPI curr : this.market.getSubmarketsCopy()) {
            if (!curr.getPlugin().isParticipatesInEconomy() || this.contact.getFaction() != curr.getFaction()) continue;
            submarket = curr;
            break;
        }
        if (submarket == null) {
            for (SubmarketAPI curr : this.market.getSubmarketsCopy()) {
                if (!curr.getPlugin().isParticipatesInEconomy()) continue;
                if (illegal && curr.getPlugin().isBlackMarket()) {
                    submarket = curr;
                    break;
                }
                if (illegal || !curr.getPlugin().isOpenMarket()) continue;
                submarket = curr;
                break;
            }
        }
        if (submarket == null) {
            return;
        }
        PlayerTradeDataForSubmarket tradeData = SharedData.getData().getPlayerActivityTracker().getPlayerTradeData(submarket);
        CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.RESOURCES, this.commodity.getId(), null);
        stack.setSize(this.quantity);
        tradeData.addToTrackedPlayerSold(stack, totalReward);
        Misc.affectAvailabilityWithinReason(this.commodity, (int)this.quantity);
    }

    @Override
    public void endMission() {
        if (this.contact != null) {
            this.contact.getMemoryWithoutUpdate().unset("$mpm_isPlayerContact");
            this.contact.getMemoryWithoutUpdate().unset("$mpm_eventRef");
            this.contact.getMemoryWithoutUpdate().unset("$mpm_commodityName");
            this.contact.getMemoryWithoutUpdate().unset("$mpm_quantity");
            Misc.setFlagWithReason(this.contact.getMemoryWithoutUpdate(), "$requiresDiscretionToDeal", "mpm_" + this.commodity.getId(), false, 0.0f);
            Misc.setFlagWithReason(this.contact.getMemoryWithoutUpdate(), "$missionImportant", "mpm", false, 0.0f);
            if (this.contactWillInitiateComms) {
                this.contact.decrWantsToContactReasons();
            }
            Global.getSector().getImportantPeople().returnPerson(this.contact, PERSON_CHECKOUT_REASON);
            if (!Global.getSector().getImportantPeople().isCheckedOutForAnything(this.contact)) {
                this.market.getCommDirectory().removePerson(this.contact);
            }
        }
        this.endAfterDelay();
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (isUpdate) {
            if (this.isFailed() || this.isCancelled()) {
                return;
            }
            if (this.isCompleted()) {
                if (this.missionResult.payment > 0) {
                    info.addPara("%s received", initPad, tc, h, Misc.getDGSCredits(this.missionResult.payment));
                }
                CoreReputationPlugin.addAdjustmentMessage(this.missionResult.rep1.delta, this.contact.getFaction(), null, null, null, info, tc, isUpdate, 0.0f);
                CoreReputationPlugin.addAdjustmentMessage(this.missionResult.rep2.delta, null, this.contact, null, null, info, tc, isUpdate, 0.0f);
            }
        } else if (this.missionResult != null) {
            if (this.missionResult.payment > 0) {
                info.addPara("%s received", initPad, tc, h, Misc.getDGSCredits(this.missionResult.payment));
                initPad = 0.0f;
            }
            if (this.missionResult.rep1 != null) {
                CoreReputationPlugin.addAdjustmentMessage(this.missionResult.rep1.delta, this.contact.getFaction(), null, null, null, info, tc, isUpdate, initPad);
                initPad = 0.0f;
            }
            if (this.missionResult.rep2 != null) {
                CoreReputationPlugin.addAdjustmentMessage(this.missionResult.rep2.delta, null, this.contact, null, null, info, tc, isUpdate, initPad);
                initPad = 0.0f;
            }
        } else {
            if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
                FactionAPI faction = this.contact.getFaction();
                info.addPara("Faction: " + faction.getDisplayName(), initPad, tc, faction.getBaseUIColor(), faction.getDisplayName());
                initPad = 0.0f;
            }
            LabelAPI label = info.addPara("%s units required at " + this.market.getName(), initPad, tc, h, "" + (int)this.quantity);
            label.setHighlight("" + (int)this.quantity, this.market.getName());
            label.setHighlightColors(h, this.market.getFaction().getBaseUIColor());
            info.addPara("%s reward", 0.0f, tc, h, Misc.getDGSCredits(this.baseReward));
            this.addDays(info, "to complete", this.duration.floatValue() - this.elapsedDays, tc, 0.0f);
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSortString() {
        return "Procurement";
    }

    @Override
    public String getName() {
        if (this.isAccepted() || this.isPosted()) {
            return "Procurement - " + this.commodity.getCommodity().getName();
        }
        return "Procurement Contract" + this.getPostfixForState();
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.contact.getFaction();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        String desc;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        FactionAPI faction = this.contact.getFaction();
        boolean illegal = this.contact.getFaction().isHostileTo(this.market.getFaction());
        info.addImages(width, 80.0f, opad, opad * 2.0f, this.commodity.getCommodity().getIconName(), this.contact.getPortraitSprite());
        String prefix = faction.getPersonNamePrefix();
        if ("pirates".equals(faction.getId())) {
            prefix = String.valueOf(prefix) + "-affiliated";
        }
        if ((desc = this.contact.getPost()) == null) {
            desc = this.contact.getRank();
        }
        if (desc == null) {
            desc = "supplier";
        }
        desc = desc.toLowerCase();
        info.addPara(String.valueOf(Misc.ucFirst(faction.getPersonNamePrefixAOrAn())) + " " + prefix + " " + desc + " at " + this.market.getName() + " " + "has posted a procurement contract for a quantity of " + this.commodity.getCommodity().getLowerCaseName() + ".", opad, tc, faction.getBaseUIColor(), prefix);
        if (this.isPosted() || this.isAccepted()) {
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
            info.addPara("Contact " + this.contact.getNameString() + " at " + this.market.getName() + " to complete the delivery.", opad);
            if (illegal) {
                info.addPara(String.valueOf(this.contact.getNameString()) + " is affiliated with the local underworld and will require clandestine delivery, " + "which may attract the interest of local authorities.", opad);
            } else if (this.market.getFaction().isHostileTo("player")) {
                info.addPara(String.valueOf(this.contact.getNameString()) + " is " + "operating with the knowledge of the local authorities. " + "However, " + faction.getDisplayNameWithArticle() + " is hostile towards you, and you'll need " + "to sneak into port without attracting notice in order to complete the delivery.", opad);
            } else {
                info.addPara(String.valueOf(this.contact.getNameString()) + " is " + "operating with the knowledge of the local authorities and the delivery may be made openly.", opad);
            }
            this.addGenericMissionState(info);
            this.addAcceptOrAbandonButton(info, width);
            ButtonAPI button = info.addButton("View commodity info", BUTTON_COMMODITY_INFO, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 3.0f);
            if (!Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay()) {
                button.setEnabled(false);
                info.addPara("Seeing remote price data requires being within range of a functional comm relay.", g, opad);
            }
        } else {
            if (this.isFailed() && !this.market.isInEconomy()) {
                info.addPara("You have failed this contract because " + this.market.getName() + " no longer exists as a functional polity.", opad);
            } else {
                this.addGenericMissionState(info);
            }
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        }
    }

    @Override
    public String getIcon() {
        return this.commodity.getCommodity().getIconName();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Trade");
        tags.add(this.contact.getFaction().getId());
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.market.getPrimaryEntity();
    }

    @Override
    protected String getMissionTypeNoun() {
        return "contract";
    }

    @Override
    protected BaseMissionIntel.MissionResult createAbandonedResult(boolean withPenalty) {
        if (withPenalty) {
            float repAmount = 0.01f * this.baseReward / 100000.0f;
            if (repAmount < 0.01f) {
                repAmount = 0.01f;
            }
            if (repAmount > 0.05f) {
                repAmount = 0.05f;
            }
            CoreReputationPlugin.MissionCompletionRep completionRep = new CoreReputationPlugin.MissionCompletionRep(repAmount, RepLevel.WELCOMING, -repAmount, RepLevel.INHOSPITABLE);
            ReputationActionResponsePlugin.ReputationAdjustmentResult repF = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_FAILURE, (Object)completionRep, null, null, true, false), this.contact.getFaction().getId());
            ReputationActionResponsePlugin.ReputationAdjustmentResult repC = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_FAILURE, (Object)completionRep, null, null, true, false), this.contact);
            return new BaseMissionIntel.MissionResult(0, repF, repC);
        }
        return new BaseMissionIntel.MissionResult();
    }

    @Override
    protected BaseMissionIntel.MissionResult createTimeRanOutFailedResult() {
        return this.createAbandonedResult(true);
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_COMMODITY_INFO) {
            return;
        }
        super.buttonPressConfirmed(buttonId, ui);
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        if (buttonId != BUTTON_COMMODITY_INFO) {
            super.createConfirmationPrompt(buttonId, prompt);
            return;
        }
        prompt.setParaFontDefault();
        prompt.addPara("This procurement contract offers a price of %s per unit of " + this.commodity.getCommodity().getName() + ".", 0.0f, Misc.getHighlightColor(), Misc.getDGSCredits(this.pricePerUnit));
        Global.getSettings().addCommodityInfoToTooltip(prompt, 10.0f, this.commodity.getCommodity(), 10, true, false, true);
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        if (buttonId == BUTTON_COMMODITY_INFO) {
            return true;
        }
        return super.doesButtonHaveConfirmDialog(buttonId);
    }

    @Override
    public float getConfirmationPromptWidth(Object buttonId) {
        if (buttonId == BUTTON_COMMODITY_INFO) {
            return 717.0f;
        }
        return super.getConfirmationPromptWidth(buttonId);
    }

    @Override
    public String getConfirmText(Object buttonId) {
        if (buttonId == BUTTON_COMMODITY_INFO) {
            return "Dismiss";
        }
        return super.getConfirmText(buttonId);
    }

    @Override
    public String getCancelText(Object buttonId) {
        if (buttonId == BUTTON_COMMODITY_INFO) {
            return null;
        }
        return super.getCancelText(buttonId);
    }
}

