/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarEvent;
import com.fs.starfarer.api.impl.campaign.rulecmd.DumpMemory;
import com.fs.starfarer.api.impl.campaign.rulecmd.missions.BarCMD;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarEventDialogPlugin
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected InteractionDialogPlugin originalPlugin;
    protected Map<String, MemoryAPI> memoryMap;
    protected PortsideBarEvent event;
    protected BarCMD cmd;

    public BarEventDialogPlugin(BarCMD cmd, InteractionDialogPlugin originalPlugin, PortsideBarEvent event, Map<String, MemoryAPI> memoryMap) {
        this.cmd = cmd;
        this.originalPlugin = originalPlugin;
        this.event = event;
        this.memoryMap = memoryMap;
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.event.init(dialog, this.memoryMap);
        if (this.event.isDialogFinished()) {
            this.endEvent();
        } else if (Global.getSettings().isDevMode()) {
            DevMenuOptions.addOptions(dialog);
        }
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        if (optionText != null) {
            this.dialog.addOptionSelectedText(optionData);
        }
        if (optionData == "DumpMemory.option_dump_memory") {
            new DumpMemory().execute(null, this.dialog, null, this.getMemoryMap());
            return;
        }
        if (DevMenuOptions.isDevOption(optionData)) {
            DevMenuOptions.execute(this.dialog, (String)optionData);
            return;
        }
        this.event.optionSelected(optionText, optionData);
        if (this.event.isDialogFinished()) {
            this.endEvent();
        } else if (Global.getSettings().isDevMode()) {
            DevMenuOptions.addOptions(this.dialog);
        }
    }

    public void endEvent() {
        this.dialog.setPlugin(this.originalPlugin);
        this.cmd.returningFromEvent(this.event);
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public void backFromEngagement(EngagementResultAPI battleResult) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return this.memoryMap;
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }
}

