/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.fleets.AutoDespawnScript;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.DeliveryMissionIntel;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class DeliveryFailureConsequences
implements EveryFrameScript,
FleetEventListener {
    public static float RADIUS_FROM_CORE = 30000.0f;
    public static float DAYS_IN_SYSTEM = 7.0f;
    protected float delayDays;
    protected boolean sentFleet;
    protected String name;
    protected String commodity;
    protected FullName.Gender gender;
    protected float reward;
    protected long seed;
    protected StarSystemAPI systemPlayerIsIn = null;
    protected float daysInSystem = 0.0f;

    public DeliveryFailureConsequences(DeliveryMissionIntel intel) {
        this.name = intel.getEvent().getPerson().getNameString();
        this.gender = intel.getEvent().getPerson().getGender();
        this.commodity = Global.getSettings().getCommoditySpec(intel.getEvent().getCommodityId()).getLowerCaseName();
        this.reward = intel.getEvent().getReward();
        this.seed = Misc.genRandomSeed();
        this.delayDays = 100.0f + (float)Math.random() * 200.0f;
        if (DebugFlags.BAR_DEBUG) {
            this.delayDays = 0.0f;
        }
    }

    public void advance(float amount) {
        if (this.sentFleet) {
            return;
        }
        float days = Misc.getDays(amount);
        this.delayDays -= days;
        if (this.delayDays > 0.0f) {
            return;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        float distFromCore = playerFleet.getLocationInHyperspace().length();
        if (distFromCore > RADIUS_FROM_CORE) {
            this.daysInSystem = 0.0f;
            this.systemPlayerIsIn = null;
            return;
        }
        if (!(playerFleet.getContainingLocation() instanceof StarSystemAPI)) {
            float dist;
            if ((this.daysInSystem > DAYS_IN_SYSTEM || DebugFlags.BAR_DEBUG) && this.systemPlayerIsIn != null && (dist = Misc.getDistance(this.systemPlayerIsIn.getLocation(), playerFleet.getLocationInHyperspace())) < 3000.0f) {
                this.sendFleet();
            }
            this.daysInSystem = 0.0f;
            this.systemPlayerIsIn = null;
            return;
        }
        this.systemPlayerIsIn = (StarSystemAPI)playerFleet.getContainingLocation();
        this.daysInSystem += days;
    }

    protected void sendFleet() {
        if (this.sentFleet) {
            return;
        }
        this.sentFleet = true;
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CampaignFleetAPI hunter = this.createBountyHunter();
        if (hunter != null) {
            Global.getSector().getHyperspace().addEntity(hunter);
            Vector2f hunterLoc = Misc.getPointAtRadius(playerFleet.getLocationInHyperspace(), 500.0f);
            hunter.setLocation(hunterLoc.x, hunterLoc.y);
            hunter.getAI().addAssignmentAtStart(FleetAssignment.INTERCEPT, playerFleet, 1000.0f, null);
            Misc.giveStandardReturnToSourceAssignments(hunter, false);
        }
    }

    protected CampaignFleetAPI createBountyHunter() {
        CampaignFleetAIAPI.EncounterOption option;
        Random random = new Random(this.seed);
        String faction = "independent";
        float pts = this.reward / 400.0f;
        if ((pts *= 0.8f + 0.4f * random.nextFloat()) < 30.0f) {
            pts = 30.0f;
        }
        if (pts > 150.0f) {
            pts = 150.0f;
        }
        float qMod = this.reward / 100000.0f;
        String hunter = "bounty hunter";
        if (random.nextFloat() < 0.5f) {
            faction = "pirates";
            pts *= 1.5f;
            hunter = "pirate";
        }
        FleetParamsV3 params = new FleetParamsV3(null, Global.getSector().getPlayerFleet().getLocationInHyperspace(), faction, null, "mercBountyHunter", pts, 0.0f, pts * 0.1f, 0.0f, 0.0f, 0.0f, qMod);
        params.random = random;
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet(params);
        if (fleet.isEmpty()) {
            fleet = null;
        }
        if ((option = fleet.getAI().pickEncounterOption(null, Global.getSector().getPlayerFleet())) == CampaignFleetAIAPI.EncounterOption.DISENGAGE) {
            fleet = null;
        }
        if (fleet != null) {
            AbilityPlugin eb;
            Misc.makeLowRepImpact(fleet, "dmi");
            fleet.addScript(new AutoDespawnScript(fleet));
            fleet.addEventListener(this);
            MemoryAPI memory = fleet.getMemoryWithoutUpdate();
            memory.set("$cfai_makeHostile", true);
            memory.set("$cfai_makeAggressive", true);
            memory.set("$cfai_longPursuit", true);
            String hisOrHer = "his";
            String himOrHer = "him";
            if (this.gender == FullName.Gender.FEMALE) {
                hisOrHer = "her";
                himOrHer = "her";
            }
            memory.set("$dmi_bountyHunter", true);
            memory.set("$dmi_hisOrHer", hisOrHer);
            memory.set("$dmi_himOrHer", himOrHer);
            memory.set("$dmi_name", this.name);
            memory.set("$dmi_commodity", this.commodity);
            memory.set("$dmi_hunter", hunter);
            if (this.reward >= 50000.0f && (eb = fleet.getAbility("emergency_burn")) != null) {
                eb.activate();
            }
        }
        return fleet;
    }

    public boolean isDone() {
        return this.sentFleet;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        MemoryAPI memory = fleet.getMemoryWithoutUpdate();
        memory.unset("$cfai_makeAggressive");
    }

    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }
}

