/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarData;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseBarEventWithPerson;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCellsIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuddicPathBaseBarEvent
extends BaseBarEventWithPerson {
    public static int COST = 10000;
    protected LuddicPathBaseIntel intel;

    @Override
    public boolean isAlwaysShow() {
        return true;
    }

    public LuddicPathBaseBarEvent(LuddicPathBaseIntel intel) {
        this.intel = intel;
    }

    @Override
    public boolean shouldShowAtMarket(MarketAPI market) {
        for (LuddicPathCellsIntel cell : LuddicPathCellsIntel.getCellsForBase(this.intel, true)) {
            if (cell.isSleeper() || cell.getSleeperTimeout() > 0.0f || cell.getMarket() != market) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRemoveEvent() {
        return this.intel.isEnding() || this.intel.isEnded() || this.intel.isPlayerVisible();
    }

    @Override
    protected void regen(MarketAPI market) {
        if (this.market == market) {
            return;
        }
        super.regen(market);
    }

    @Override
    protected PersonAPI createPerson() {
        FactionAPI faction = Global.getSector().getFaction("luddic_path");
        int level = 1;
        PersonAPI person = OfficerManagerEvent.createOfficer(faction, level, OfficerManagerEvent.SkillPickPreference.NO_ENERGY_YES_BALLISTIC_YES_MISSILE_YES_DEFENSE, true, null, true, false, 0, this.random);
        return person;
    }

    @Override
    public void addPromptAndOption(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.addPromptAndOption(dialog, memoryMap);
        this.regen(dialog.getInteractionTarget().getMarket());
        TextPanelAPI text = dialog.getTextPanel();
        text.addPara("A " + this.getManOrWoman() + " with Pather tattoos is staring at you from across the bar " + "with a desperate gleam in " + this.getHisOrHer() + " eyes.");
        dialog.getOptionPanel().addOption("Make eye contact with the Pather and walk out into the back alley", this, null);
    }

    @Override
    public void init(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.init(dialog, memoryMap);
        this.done = false;
        dialog.getVisualPanel().showPersonInfo(this.person, true);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        if (!(optionData instanceof OptionId)) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        OptionPanelAPI options = this.dialog.getOptionPanel();
        TextPanelAPI text = this.dialog.getTextPanel();
        options.clearOptions();
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        int credits = (int)cargo.getCredits().get();
        Color h = Misc.getHighlightColor();
        Color n = Misc.getNegativeHighlightColor();
        switch (option) {
            case INIT: {
                text.addPara("After a minute or two of waiting in the alley, the door opens and the Pather walks out.");
                text.addPara("\"I know who you are\", " + this.getHeOrShe() + " says. \"I need your help. If they find " + "out what I've done... well, let's just say my future with the Path is likely to be a short one. " + "So, how about this: you arrange a new identity for me, and I tell you where " + "the base supplying the Pather cells at this colony is located.\"");
                boolean canAccept = COST <= credits;
                LabelAPI label = text.addPara("You estimate that doing as " + this.getHeOrShe() + " asks will run you about %s. You have %s available.", h, Misc.getDGSCredits(COST), Misc.getDGSCredits(credits));
                label.setHighlightColors(canAccept ? h : n, h);
                label.setHighlight(Misc.getDGSCredits(COST), Misc.getDGSCredits(credits));
                options.addOption("Agree to " + this.getHisOrHer() + " terms", (Object)OptionId.AGREE);
                if (!canAccept) {
                    options.setEnabled((Object)OptionId.AGREE, false);
                    options.setTooltip((Object)OptionId.AGREE, "Not enough credits.");
                }
                this.addStoryOption();
                options.addOption("Suggest that " + this.getHeOrShe() + " handle " + this.getHisOrHer() + " own problems", (Object)OptionId.REJECT);
                break;
            }
            case AGREE: {
                text.addPara("You agree to the " + this.getManOrWoman() + "'s terms and make the necessary arrangements.");
                cargo.getCredits().subtract(COST);
                AddRemoveCommodity.addCreditsLossText(COST, this.dialog.getTextPanel());
                this.done = true;
                this.intel.makeKnown();
                this.intel.sendUpdate(PirateBaseIntel.DISCOVERED_PARAM, text);
                PortsideBarData.getInstance().removeEvent(this);
                options.addOption("Continue", (Object)OptionId.LEAVE);
                break;
            }
            case REJECT: {
                text.addPara("You leave the back alley and return to the bar.");
                options.addOption("Continue", (Object)OptionId.LEAVE);
                break;
            }
            case LEAVE: {
                this.noContinue = true;
                this.done = true;
            }
        }
    }

    protected void addStoryOption() {
        String id = "join_id";
        this.options.addOption("Offer for " + this.getHimOrHer() + " to join your fleet instead", id);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        int num = Misc.getNumNonMercOfficers(playerFleet);
        int max = Misc.getMaxOfficers(playerFleet);
        if (num >= max) {
            this.options.setEnabled(id, false);
            this.options.setTooltip(id, "Maximum number of officers reached.");
        }
        SetStoryOption.StoryOptionParams params = new SetStoryOption.StoryOptionParams(id, 1, "patherJoinFleet", Sounds.STORY_POINT_SPEND_LEADERSHIP, "Allowed " + this.person.getNameString() + ", a Luddic Path defector, to join your fleet");
        SetStoryOption.set(this.dialog, params, new SetStoryOption.BaseOptionStoryPointActionDelegate(this.dialog, params){

            public void confirm() {
                super.confirm();
                LuddicPathBaseBarEvent.this.text.addPara(String.valueOf(Misc.ucFirst(LuddicPathBaseBarEvent.this.getHeOrShe())) + " is mistrustful at first, but that turns to surprise and " + "gratitude when " + LuddicPathBaseBarEvent.this.getHeOrShe() + " realizes you're serious.");
                CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                playerFleet.getFleetData().addOfficer(LuddicPathBaseBarEvent.this.getPerson());
                LuddicPathBaseBarEvent.this.getPerson().setPostId(Ranks.POST_OFFICER);
                AddRemoveCommodity.addOfficerGainText(LuddicPathBaseBarEvent.this.getPerson(), this.dialog.getTextPanel());
                LuddicPathBaseBarEvent.this.done = true;
                LuddicPathBaseBarEvent.this.intel.makeKnown();
                LuddicPathBaseBarEvent.this.intel.sendUpdate(PirateBaseIntel.DISCOVERED_PARAM, LuddicPathBaseBarEvent.this.text);
                PortsideBarData.getInstance().removeEvent(LuddicPathBaseBarEvent.this);
                LuddicPathBaseBarEvent.this.options.addOption("Continue", (Object)OptionId.LEAVE);
                OptionPanelAPI options = this.dialog.getOptionPanel();
                options.clearOptions();
                options.addOption("Continue", (Object)OptionId.LEAVE);
            }

            public String getTitle() {
                return "Taking in Luddic Path defector";
            }

            public void createDescription(TooltipMakerAPI info) {
                float opad = 10.0f;
                info.addSpacer(-opad);
                MutableCharacterStatsAPI stats = LuddicPathBaseBarEvent.this.person.getStats();
                TooltipMakerAPI text = info;
                Color hl = Misc.getHighlightColor();
                Color red = Misc.getNegativeHighlightColor();
                text.addPara("You consider letting the Luddic Path defector, " + LuddicPathBaseBarEvent.this.person.getNameString() + ", join your fleet.", opad);
                text.addPara("Level: %s", opad, hl, "" + stats.getLevel());
                for (String skillId : Global.getSettings().getSortedSkillIds()) {
                    int level = (int)stats.getSkillLevel(skillId);
                    if (level <= 0) continue;
                    SkillSpecAPI spec = Global.getSettings().getSkillSpec(skillId);
                    String skillName = spec.getName();
                    if (spec.isAptitudeEffect()) {
                        skillName = String.valueOf(skillName) + " Aptitude";
                    }
                    if (level <= 1) {
                        text.addPara(skillName, opad);
                        continue;
                    }
                    text.addPara(String.valueOf(skillName) + " (Elite)", opad);
                }
                String personality = Misc.lcFirst(LuddicPathBaseBarEvent.this.person.getPersonalityAPI().getDisplayName());
                text.addPara("Personality: %s", opad, Misc.getHighlightColor(), personality);
                text.addPara(LuddicPathBaseBarEvent.this.person.getPersonalityAPI().getDescription(), opad);
                info.addSpacer(opad * 2.0f);
                this.addActionCostSection(info);
            }
        });
    }

    @Override
    protected String getPersonFaction() {
        return "luddic_path";
    }

    @Override
    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    @Override
    protected String getPersonPost() {
        return Ranks.CITIZEN;
    }

    @Override
    protected String getPersonPortrait() {
        return null;
    }

    @Override
    protected FullName.Gender getPersonGender() {
        return FullName.Gender.ANY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        INIT,
        AGREE,
        HIRE,
        HIRE_CONTINUE,
        REJECT,
        LEAVE;

    }
}

