/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseGetCommodityBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;

public class QuartermasterCargoSwapBarEvent
extends BaseGetCommodityBarEvent {
    protected int playerGiveQuantity = 0;
    protected String playerGiveCommodity = null;

    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        this.regen(market);
        if (this.commodity == null) {
            return false;
        }
        if (!market.getFactionId().equals("hegemony")) {
            return false;
        }
        boolean hasMilitaryBase = false;
        for (Industry ind : market.getIndustries()) {
            if (!ind.getSpec().hasTag("military")) continue;
            hasMilitaryBase = true;
            break;
        }
        return hasMilitaryBase;
    }

    protected String getCommodityId() {
        String[] possible = new String[]{"hand_weapons", "heavy_machinery", "supplies", "fuel", "rare_metals", "metals"};
        ArrayList<String> playerHas = new ArrayList<String>();
        ArrayList<String> playerNotHas = new ArrayList<String>();
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        float value = this.getValue();
        String[] stringArray = possible;
        int n = possible.length;
        int n2 = 0;
        while (n2 < n) {
            CommoditySpecAPI spec;
            int num;
            String c = stringArray[n2];
            int q = (int)cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, c);
            if (q >= (num = (int)(value / (spec = Global.getSettings().getCommoditySpec(c)).getBasePrice()))) {
                playerHas.add(c);
            } else if (q < num) {
                playerNotHas.add(c);
            }
            ++n2;
        }
        if (playerHas.isEmpty() || playerNotHas.isEmpty()) {
            return null;
        }
        WeightedRandomPicker<String> take = new WeightedRandomPicker<String>(this.random);
        take.addAll(playerNotHas);
        WeightedRandomPicker<String> give = new WeightedRandomPicker<String>(this.random);
        give.addAll(playerHas);
        String pick = (String)take.pick();
        this.playerGiveCommodity = (String)give.pick();
        CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(this.playerGiveCommodity);
        int num = (int)(value / spec.getBasePrice());
        this.playerGiveQuantity = (int)((float)num * 0.33f);
        if (this.playerGiveQuantity <= 0) {
            return null;
        }
        return pick;
    }

    protected PersonAPI createPerson() {
        PersonAPI person2;
        for (PersonAPI person2 : this.market.getPeopleCopy()) {
            if (!Ranks.POST_SUPPLY_OFFICER.equals(person2.getPostId())) continue;
            this.adjustPerson(person2);
            return person2;
        }
        person2 = Global.getSector().getFaction(this.getPersonFaction()).createRandomPerson(this.random);
        person2.setRankId(this.getPersonRank());
        person2.setPostId(this.getPersonRank());
        this.adjustPerson(person2);
        return person2;
    }

    protected void adjustPerson(PersonAPI person) {
        super.adjustPerson(person);
        person.setImportanceAndVoice(PersonImportance.MEDIUM, this.random);
        person.addTag("military");
    }

    protected String getPersonFaction() {
        return "hegemony";
    }

    protected String getPersonRank() {
        return Ranks.SPACE_COMMANDER;
    }

    protected String getPersonPost() {
        return Ranks.POST_SUPPLY_OFFICER;
    }

    protected float getValue() {
        float value = (float)(1000 + 100 * this.random.nextInt(6)) * BaseIndustry.getSizeMult(this.market.getSize());
        return value;
    }

    protected int computeQuantity() {
        String c = this.commodity;
        CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(c);
        int num = (int)(this.getValue() / spec.getBasePrice());
        return num;
    }

    protected float getPriceMult() {
        return 0.0f;
    }

    protected String getPrompt() {
        return "None other than the station's quartermaster, who looks rather sullen, is sitting at the bar.";
    }

    protected String getOptionText() {
        return "Approach the quartermaster and offer to buy " + this.getHimOrHer() + " a drink";
    }

    protected String getMainText() {
        CommoditySpecAPI take = Global.getSettings().getCommoditySpec(this.commodity);
        CommoditySpecAPI give = Global.getSettings().getCommoditySpec(this.playerGiveCommodity);
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        int qty = (int)cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, give.getId());
        String units = "units";
        if (qty == 1) {
            units = "unit";
        }
        return "In venerated tradition going back thousands of cycles, the quartermaster vents to you about how " + this.getHisOrHer() + " provision request got mixed up and " + this.getHeOrShe() + " was shipped %s units of " + take.getLowerCaseName() + " instead of %s units of " + give.getLowerCaseName() + ". \"A mining drone with half its Ludd-damned " + "computer fried on rads would do a better job than the idiots in Fleet Supply\" " + this.getHeOrShe() + " growls, knocking back the rest of " + this.getHisOrHer() + " drink and " + "slamming the glass down.\n\n" + "You have %s " + units + " of " + give.getLowerCaseName() + " on board.";
    }

    protected String[] getMainTextTokens() {
        CommoditySpecAPI give = Global.getSettings().getCommoditySpec(this.playerGiveCommodity);
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        int qty = (int)cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, give.getId());
        return new String[]{Misc.getWithDGS(this.quantity), Misc.getWithDGS(this.playerGiveQuantity), Misc.getWithDGS(qty)};
    }

    protected Color[] getMainTextColors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected String getConfirmText() {
        CommoditySpecAPI take = Global.getSettings().getCommoditySpec(this.commodity);
        CommoditySpecAPI give = Global.getSettings().getCommoditySpec(this.playerGiveCommodity);
        return "Offer to swap " + this.playerGiveQuantity + " " + give.getLowerCaseName() + " " + "for " + this.quantity + " " + take.getLowerCaseName() + ", as a favor from you to " + this.getHimOrHer();
    }

    protected String getCancelText() {
        return "Do nothing but commiserate with the quartermaster as you finish your drink.";
    }

    protected String getAcceptText() {
        CommoditySpecAPI take = Global.getSettings().getCommoditySpec(this.commodity);
        CommoditySpecAPI give = Global.getSettings().getCommoditySpec(this.playerGiveCommodity);
        return "You exchange comms with the quartermaster and the very next day " + this.getHeOrShe() + " smoothes things along with the port authorities and arranges for the quickest cargo " + "transfer you've ever seen, trading your %s " + give.getLowerCaseName() + " for " + "%s " + take.getLowerCaseName() + ". Afterward, the quartermaster " + "sends you a personal thank-you note.";
    }

    protected String[] getAcceptTextTokens() {
        return new String[]{Misc.getWithDGS(this.playerGiveQuantity), Misc.getWithDGS(this.quantity)};
    }

    protected Color[] getAcceptTextColors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected void doExtraConfirmActions() {
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        cargo.removeCommodity(this.playerGiveCommodity, this.playerGiveQuantity);
        TextPanelAPI text = this.dialog.getTextPanel();
        AddRemoveCommodity.addCommodityLossText(this.playerGiveCommodity, this.playerGiveQuantity, text);
        CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = 0.1f;
        Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, text, true, true), this.person);
        impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = 0.03f;
        Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, text, true, true), this.person.getFaction().getId());
        ContactIntel.addPotentialContact(this.person, this.market, text);
    }

    protected String getDeclineText() {
        return "You drink to the bureaucrats in Fleet Supply \"mistaking the airlock for the head-hatch\", empty your glass, and make your exit.";
    }
}

