/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.RuleBasedDialog;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BarEventManager;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachLoanBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachLoanBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachLoanIncentiveScript;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachMajorLoanBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriTachLoanIntel
extends BaseIntelPlugin {
    public static final String NUM_REPAID_LOANS = "$ttli_numRepaidLoans";
    protected TriTachLoanBarEvent event;
    protected MarketAPI market;
    protected ReputationActionResponsePlugin.ReputationAdjustmentResult repResult;
    protected float daysRemaining = 0.0f;
    protected boolean wasExtended = false;
    protected boolean sentReminder = false;
    protected boolean loanRepaid = false;
    protected boolean majorLoan = false;

    public TriTachLoanIntel(TriTachLoanBarEvent event, MarketAPI market) {
        this.event = event;
        this.market = market;
        this.daysRemaining = event.getRepaymentDays();
        Global.getSector().addScript(this);
        PersonAPI person = this.getPerson();
        market.getCommDirectory().addPerson(person);
        market.addPerson(person);
        person.getMemoryWithoutUpdate().set("$ttli_isPlayerContact", true);
        person.getMemoryWithoutUpdate().set("$ttli_eventRef", this);
        Misc.setFlagWithReason(person.getMemoryWithoutUpdate(), "$missionImportant", "ttli", true, -1.0f);
    }

    public TriTachLoanBarEvent getEvent() {
        return this.event;
    }

    public boolean isMajorLoan() {
        return this.majorLoan;
    }

    public void setMajorLoan(boolean majorLoan) {
        this.majorLoan = majorLoan;
        if (majorLoan) {
            this.getPerson().getMemoryWithoutUpdate().set("$ttli_isMajorLoan", true);
        }
    }

    public PersonAPI getPerson() {
        return this.event.getPerson();
    }

    protected float getExtensionDays() {
        return this.event.getRepaymentDays();
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        MemoryAPI memory = this.getPerson().getMemoryWithoutUpdate();
        if (action.equals("putValuesInMemory")) {
            memory.set("$ttli_repaymentAmount", Misc.getDGSCredits(this.event.getRepaymentAmount()), 0.0f);
            memory.set("$ttli_loanWasExtended", this.wasExtended, 0.0f);
            memory.set("$ttli_daysRemaining", Float.valueOf(this.daysRemaining), 0.0f);
            if (this.wasExtended) {
                memory.set("$ttli_extensionDays", "" + (int)this.getExtensionDays(), 0.0f);
            }
        } else {
            if (action.equals("canPay")) {
                return cargo.getCredits().get() >= (float)this.event.getRepaymentAmount();
            }
            if (action.equals("payLoan")) {
                this.endWithPayment(dialog);
            } else if (action.equals("extendLoan")) {
                this.extendLoan(dialog);
            } else if (action.equals("applyExtendLoanRepLoss")) {
                this.applyExtendLoanRepLoss(dialog);
            } else if (action.equals("notPaying")) {
                this.endNoPayment(dialog);
            } else if (action.equals("noPaymentMessage")) {
                this.noPaymentMessage(dialog);
            } else if (action.equals("isMajorLoan")) {
                return this.isMajorLoan();
            }
        }
        return true;
    }

    protected void noPaymentMessage(InteractionDialogAPI dialog) {
        dialog.getInteractionTarget().setActivePerson(this.getPerson());
        ((RuleBasedDialog)((Object)dialog.getPlugin())).notifyActivePersonChanged();
        dialog.getVisualPanel().showPersonInfo(this.getPerson(), true);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        PersonAPI person = this.getPerson();
        this.market.getCommDirectory().removePerson(person);
        this.market.removePerson(person);
        person.getMemoryWithoutUpdate().unset("$ttli_isPlayerContact");
        person.getMemoryWithoutUpdate().unset("$ttli_eventRef");
        Misc.setFlagWithReason(person.getMemoryWithoutUpdate(), "$missionImportant", "ttli", false, -1.0f);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
    }

    protected void extendLoan(InteractionDialogAPI dialog) {
        this.wasExtended = true;
        float extension = this.event.getRepaymentDays();
        this.daysRemaining += extension;
        this.event.setRepaymentAmount((int)((float)this.event.getLoanAmount() * 2.0f));
        BarEventManager.GenericBarEventCreator creator = null;
        for (BarEventManager.GenericBarEventCreator c : BarEventManager.getInstance().getCreators()) {
            if (this.isMajorLoan() && c instanceof TriTachMajorLoanBarEventCreator) {
                creator = c;
                break;
            }
            if (this.isMajorLoan() || !(c instanceof TriTachLoanBarEventCreator)) continue;
            creator = c;
            break;
        }
        if (creator != null) {
            BarEventManager.getInstance().getTimeout().add(creator, extension);
        }
    }

    protected void applyExtendLoanRepLoss(InteractionDialogAPI dialog) {
        CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = -0.05f;
        if (this.isMajorLoan()) {
            impact.delta = -0.1f;
        }
        impact.limit = RepLevel.SUSPICIOUS;
        this.repResult = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, dialog != null ? dialog.getTextPanel() : null, true, true), this.event.getPerson());
        impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = -0.02f;
        if (this.isMajorLoan()) {
            impact.delta = -0.05f;
        }
        impact.limit = RepLevel.SUSPICIOUS;
        this.repResult = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, dialog != null ? dialog.getTextPanel() : null, true, true), this.event.getPerson().getFaction().getId());
    }

    protected void endWithPayment(InteractionDialogAPI dialog) {
        this.endAfterDelay();
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        cargo.getCredits().subtract(this.event.getRepaymentAmount());
        if (dialog != null) {
            TextPanelAPI text = dialog.getTextPanel();
            AddRemoveCommodity.addCreditsLossText(this.event.getRepaymentAmount(), text);
        }
        CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = 0.05f;
        if (this.isMajorLoan()) {
            impact.delta = 0.1f;
        }
        this.repResult = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, dialog != null ? dialog.getTextPanel() : null, true, true), this.event.getPerson());
        impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = 0.02f;
        if (this.isMajorLoan()) {
            impact.delta = 0.05f;
        }
        this.repResult = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, dialog != null ? dialog.getTextPanel() : null, true, true), this.event.getPerson().getFaction().getId());
        float repaid = Global.getSector().getMemoryWithoutUpdate().getFloat(NUM_REPAID_LOANS);
        Global.getSector().getMemoryWithoutUpdate().set(NUM_REPAID_LOANS, Float.valueOf(repaid += 1.0f));
        this.loanRepaid = true;
        ContactIntel.addPotentialContact(this.event.getPerson(), this.market, dialog.getTextPanel());
    }

    protected void endNoPayment(InteractionDialogAPI dialog) {
        this.endAfterDelay();
        CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = -0.0f;
        impact.ensureAtBest = RepLevel.HOSTILE;
        if (this.isMajorLoan()) {
            impact.ensureAtBest = RepLevel.VENGEFUL;
        }
        this.repResult = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, dialog != null ? dialog.getTextPanel() : null, dialog != null, dialog != null), this.event.getPerson().getFaction().getId());
        if (dialog == null) {
            Global.getSector().getMemoryWithoutUpdate().set("$ttli_unpaidEventRef", this, 60.0f);
        }
        if (this.majorLoan) {
            Global.getSector().addScript(new TriTachLoanIncentiveScript(this));
        }
    }

    @Override
    protected void advanceImpl(float amount) {
        float dist;
        float soonDays;
        super.advanceImpl(amount);
        float days = Misc.getDays(amount);
        this.daysRemaining -= days;
        if (this.daysRemaining <= 0.0f) {
            this.endNoPayment(null);
            this.sendUpdateIfPlayerHasIntel(new Object(), false);
            return;
        }
        if (!this.sentReminder && (soonDays = (dist = Misc.getDistance(Global.getSector().getPlayerFleet().getLocationInHyperspace(), this.market.getLocationInHyperspace())) / 1500.0f + 10.0f) > this.daysRemaining) {
            this.sentReminder = true;
            this.sendUpdateIfPlayerHasIntel(new Object(), false);
            return;
        }
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (!this.loanRepaid && this.daysRemaining > 0.0f) {
            if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
                info.addPara("%s original loan amount", initPad, tc, h, Misc.getDGSCredits(this.event.getLoanAmount()));
                initPad = 0.0f;
            }
            info.addPara("%s owed", initPad, tc, h, Misc.getDGSCredits(this.event.getRepaymentAmount()));
            initPad = 0.0f;
            this.addDays(info, "left to repay", this.daysRemaining, tc);
        }
        if (this.repResult != null) {
            CoreReputationPlugin.addAdjustmentMessage(this.repResult.delta, this.event.getPerson().getFaction(), null, null, null, info, tc, isUpdate, initPad);
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSortString() {
        return "Loan";
    }

    @Override
    public String getName() {
        if (this.loanRepaid) {
            return "Loan Repaid";
        }
        if (this.daysRemaining <= 0.0f) {
            return "Loan Repayment - Failed";
        }
        if (this.sentReminder) {
            return "Loan Repayment - Due Soon";
        }
        return "Loan Repayment";
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.event.getPerson().getFaction();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        PersonAPI p = this.event.getPerson();
        FactionAPI faction = this.getFactionForUIColors();
        info.addImages(width, 128.0f, opad, opad, p.getPortraitSprite(), faction.getCrest());
        if (this.loanRepaid) {
            info.addPara("You've repaid the loan from " + p.getNameString() + " on time.", opad);
        } else if (this.daysRemaining > 0.0f) {
            info.addPara("You've accepted a loan from " + p.getNameString() + " and must repay it on time, " + "or your reputation with " + faction.getDisplayNameWithArticle() + " will be ruined.", opad, faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
        } else {
            info.addPara("You've failed to repay the loan from " + p.getNameString() + " on time.", opad);
        }
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        if (this.daysRemaining > 0.0f && !this.loanRepaid) {
            info.addPara("You should be able to find " + p.getNameString() + " at " + this.market.getName() + ".", opad);
        }
    }

    @Override
    public String getIcon() {
        return this.event.getPerson().getPortraitSprite();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Accepted");
        tags.add(this.getFactionForUIColors().getId());
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.market.getPrimaryEntity();
    }
}

