/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachLoanBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachLoanIntel;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class TriTachMajorLoanBarEvent
extends TriTachLoanBarEvent {
    public static int REPAYMENT_DAYS_MAJOR = 500;

    protected void regen(MarketAPI market) {
        if (this.market == market) {
            return;
        }
        super.regen(market);
        this.loanAmount = 1000000 + this.random.nextInt(6) * 100000;
        this.repaymentAmount = (int)((float)this.loanAmount * 1.5f);
        this.repaymentDays = REPAYMENT_DAYS_MAJOR;
    }

    protected void adjustPerson(PersonAPI person) {
        person.setImportanceAndVoice(PersonImportance.VERY_HIGH, this.random);
        person.addTag("trade");
        person.addTag("military");
    }

    protected String getPersonPost() {
        return Ranks.POST_SENIOR_EXECUTIVE;
    }

    protected void createIntel() {
        TriTachLoanIntel intel = new TriTachLoanIntel(this, this.market);
        intel.setMajorLoan(true);
        Global.getSector().getIntelManager().addIntel(intel, false, this.dialog.getTextPanel());
    }

    protected String getPrompt() {
        return "A Tri-Tachyon executive sits in a private booth, scrolling through " + this.getHisOrHer() + " TriPad. An untouched drink sits on the immaculate table.";
    }

    protected String getOptionText() {
        return "Throw some credits around like a big spender, to see if you can attract the executive's attention";
    }

    protected String getMainText() {
        return "An impeccable Tri-Tachyon factioneer of completely indeterminate age has you invited to " + this.getHisOrHer() + " booth. " + Misc.ucFirst(this.getHeOrShe()) + " appraises you coolly as " + this.getHeOrShe() + " fills a glass from a bottle that looks to cost more than many starships.";
    }

    protected String getMainText2() {
        return "\"The vintage predates the Collapse, you know,\" " + this.getHeOrShe() + " says. " + "\"I enjoy the idea of owning a small part of history.\" " + Misc.ucFirst(this.getHeOrShe()) + " smiles, \"So let's talk about you.\" As " + this.getHeOrShe() + " lists detailed specifications " + "and statistical trends regarding your career in the Persean Sector you make a mental " + "note to have a discussion with your senior officers on the subject of " + "information security. \"So,\" " + this.getHeOrShe() + " concludes, \"I'd like to see " + "what you could accomplish with a short-term capital infusion of let us say %s. " + "To incentivize the ruthless enterprise I so admire, let us say you would repay %s " + "within %s days.\n\n" + "You take this in as you sip your drink. " + "It's a lot of money. You also consider that this Tri-Tach suit paid too much for the bottle.";
    }

    protected String[] getMainText2Tokens() {
        return new String[]{Misc.getDGSCredits(this.loanAmount), Misc.getDGSCredits(this.repaymentAmount), "" + this.repaymentDays};
    }

    protected Color[] getMainText2Colors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    protected String getConfirmText() {
        return "Accept the deal and toast your joint venture";
    }

    protected String getCancelText() {
        return "Decline the deal, explaining that you're \"just here to network\"";
    }

    protected String getNegotiatedText() {
        return "As the negotiations conclude, the Tri-Tachyon " + this.getManOrWoman() + " leans back, rolling the stem of " + this.getHisOrHer() + " glass between " + this.getHisOrHer() + " fingertips. " + "\"You didn't accept my initial offer\", " + this.getHeOrShe() + " says. \"I find that reassuring.\"";
    }

    protected String getAcceptText() {
        return "You leave the lounge rich in credits, having exchanged secure comm keys with the Tri-Tachyon shark and receiving the transfer immediately. Your head spins with plans for how to leverage your new assets - and a bit from the drink, you admit to yourself.";
    }
}

