/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOfferWithLocation;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;

public class FighterBlueprintOffer
extends BaseHistorianOfferWithLocation {
    protected String data;

    public FighterBlueprintOffer(SectorEntityToken entity, String data) {
        super(entity);
        this.data = data;
    }

    public void addPromptAndOption(InteractionDialogAPI dialog) {
        FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(this.data);
        dialog.getOptionPanel().addOption("... the possible location of a blueprint (" + spec.getVariant().getFullDesignationWithHullName() + ")", this);
        SetStoryOption.set(dialog, 1, this, "historianBP", Sounds.STORY_POINT_SPEND_TECHNOLOGY, "Learned location of " + spec.getVariant().getFullDesignationWithHullName() + " blueprint");
    }

    public String getSortString() {
        return "Weapon Blueprint";
    }

    public String getName() {
        FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(this.data);
        if (this.isEnding()) {
            return String.valueOf(spec.getWingName()) + " Blueprint - Recovered";
        }
        return String.valueOf(spec.getWingName()) + " Blueprint Location";
    }

    protected void addItemToCargo(CargoAPI loot) {
        loot.addSpecial(new SpecialItemData("fighter_bp", this.data), 1.0f);
    }

    public String getData() {
        return this.data;
    }
}

