/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BarEventManager;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianBackstory;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianData;
import com.fs.starfarer.api.impl.campaign.plog.PLIntel;
import com.fs.starfarer.api.impl.campaign.plog.PlaythroughLog;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistorianBarEvent
extends BaseBarEvent {
    public static int MIN_SNAPSHOTS_TO_SHOW_PLOG = 60;
    public static float PROB_TO_SHOW = 0.5f;
    protected long seed = Misc.random.nextLong();
    protected MarketAPI market = null;
    protected transient Random random;
    protected transient List<HistorianData.HistorianOffer> offers = null;
    protected transient HistorianBackstory.HistorianBackstoryInfo backstory = null;
    protected transient HistorianData.HistorianOffer currentOffer = null;

    @Override
    public boolean shouldShowAtMarket(MarketAPI market) {
        this.regen(market);
        if (this.random.nextFloat() > PROB_TO_SHOW) {
            return false;
        }
        return super.shouldShowAtMarket(market);
    }

    protected void regen(MarketAPI market) {
        this.market = market;
        this.done = false;
        this.random = new Random(this.seed + (long)market.getId().hashCode());
    }

    @Override
    public void addPromptAndOption(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.addPromptAndOption(dialog, memoryMap);
        this.regen(dialog.getInteractionTarget().getMarket());
        TextPanelAPI text = dialog.getTextPanel();
        text.addPara(this.getPrompt());
        dialog.getOptionPanel().addOption(this.getOptionText(), this);
    }

    protected String getOptionText() {
        HistorianData hd = HistorianData.getInstance();
        return "Go over to the " + hd.getManOrWoman() + " with the paper book and see what " + hd.getHeOrShe() + " wants";
    }

    protected String getPrompt() {
        HistorianData hd = HistorianData.getInstance();
        return "An old " + hd.getManOrWoman() + " sits alone at a table, " + "leafing through what looks like a genuine hardcopy paper book. As you walk by, " + hd.getHeOrShe() + " looks up and offers the seat across from " + hd.getHimOrHer() + ".";
    }

    @Override
    public void init(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.init(dialog, memoryMap);
        HistorianData hd = HistorianData.getInstance();
        dialog.getVisualPanel().showPersonInfo(hd.getPerson(), true, true);
        if (!hd.isIntroduced()) {
            this.optionSelected(null, (Object)OptionId.GREETING);
        } else {
            boolean shouldShow;
            boolean hasLog = Global.getSector().getIntelManager().hasIntelOfClass(PLIntel.class);
            boolean bl = shouldShow = PlaythroughLog.getInstance().getData().size() >= MIN_SNAPSHOTS_TO_SHOW_PLOG;
            if (!hasLog && shouldShow) {
                this.optionSelected(null, (Object)OptionId.GREETNG_PLOG);
            } else {
                this.optionSelected(null, (Object)OptionId.GREETNG_ALREADY_INTRODUCED);
            }
        }
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        HistorianData hd = HistorianData.getInstance();
        if (optionData == OptionId.GREETNG_PLOG) {
            this.text.addPara("\"Welcome! I've got something here that I think you'll find very interesting. Your actions over the past several cycles have caused quite a stir in certain corners, and I took it upon myself to look into your history, as it were. Here, let me transfer the synopsis.\"");
            this.text.addPara("Your TriPad chimes softly; a new program is ready to be installed.");
            PLIntel intel = new PLIntel();
            Global.getSector().getIntelManager().addIntel(intel, false, this.dialog.getTextPanel());
            this.options.clearOptions();
            this.options.addOption("\"Thank you! This is fascinating and not at all alarming. Now, what do you have for me?\"", (Object)OptionId.WHAT_DO_YOU_HAVE);
            return;
        }
        if (optionData == OptionId.GREETING) {
            this.text.addPara("\"Welcome, welcome, please have a seat! I'm sure you're wondering why I called you over.\" " + hd.getHeOrShe() + " leans in as if conspiring, \"" + "I think we can help each other, you and I. See, I have the information,\" " + hd.getHeOrShe() + " taps the book, " + "\"And you have the means.\"");
            this.text.addPara("\"I am what you might call a historian-adventurer; a rogue archaelogist uncovering the history of the Sector despite the danger of this exceptional era. In the course of my studies I often chance upon hints about where certain pieces of technology might be found. Retrieving those artifacts is, naturally, your role in our arrangement. ... Only if you're interested, of course - but I've done my research on your exploits and I'm sure that you will be interested.\"\n\nSpeech complete, " + hd.getHeOrShe() + " leans back, looking pleased.");
            this.options.clearOptions();
            this.options.addOption("\"I expect you'll be wanting to get paid for this information?\"", (Object)OptionId.GREETNG_CONTINUE_1);
            return;
        }
        if (optionData == OptionId.GREETNG_CONTINUE_1) {
            this.text.addPara("A weary expression passes over the " + hd.getManOrWoman() + "'s face for just a moment before resuming " + hd.getHisOrHer() + " energetic demeanor.");
            this.text.addPara("\"I understand why you would assume that. This is indeed a mercenary age; but no, nothing quite so transactional. History is an uncertain trade, and such an approach would lead to expectations, disappointment, and recrimination. All of which I'm eager to avoid, especially the last of those.\" An additional wrinkle forms on " + hd.getHisOrHer() + " face at this.");
            this.text.addPara("\"However, if you did find my information valuable, I would gladly accept... donations. Think of it as, as patronage to fuel my research, which in turn would produce valuable leads. Or it might help to think of it as an investment, but with no obligations incurred by either party. Consider it- you could enrich your own enterprises while contributing to the sum of human knowledge!\"");
            hd.setIntroduced(true);
            hd.setRecentlyDonated();
            this.options.clearOptions();
            this.options.addOption("\"Do you have anything for me now?\"", (Object)OptionId.WHAT_DO_YOU_HAVE);
            return;
        }
        if (optionData == OptionId.GREETNG_ALREADY_INTRODUCED) {
            this.text.addPara("\"So good to see you again, " + Global.getSector().getPlayerPerson().getNameString() + "!\"");
            this.text.addPara("You spend a couple minutes sharing drinks and conversing about recent goings-on in the Sector. Before long you get down to business.");
            this.optionSelected(null, (Object)OptionId.WHAT_DO_YOU_HAVE);
            return;
        }
        if (optionData == OptionId.WHAT_DO_YOU_HAVE) {
            this.text.addPara("The historian tells you about...");
            if (this.offers == null) {
                if (this.random == null) {
                    this.random = new Random(this.seed + (long)this.market.getId().hashCode());
                }
                this.offers = HistorianData.getInstance().getOffers(this.random, this.dialog);
            }
            if (this.backstory == null) {
                this.backstory = HistorianData.getInstance().pickBackstoryBit(this.random);
            }
            this.options.clearOptions();
            if (this.offers != null) {
                for (HistorianData.HistorianOffer offer : this.offers) {
                    offer.addPromptAndOption(this.dialog);
                }
            }
            this.options.addOption("... something interesting, but not of immediate import", (Object)OptionId.BACKSTORY_BIT);
            return;
        }
        boolean forceEnd = false;
        if (optionData == OptionId.BACKSTORY_BIT) {
            if (this.backstory == null) {
                forceEnd = true;
            } else {
                Random currRandom = Misc.getRandom(this.seed, 11);
                Global.getSector().getRules().setRandomForNextRulePick(currRandom);
                if (!FireBest.fire(null, this.dialog, this.memoryMap, "HistorianBackstoryBit")) {
                    HistorianData.getInstance().getShownBackstory().add(this.backstory.getId());
                    this.text.addPara(this.backstory.getText());
                }
                this.options.clearOptions();
                this.options.addOption("End the conversation", (Object)OptionId.END_CONVERSATION);
            }
        }
        if (optionData == OptionId.END_CONVERSATION || forceEnd) {
            this.text.addPara("You thank " + hd.getHimOrHer() + " for " + hd.getHisOrHer() + " the information and get up to leave.");
            this.text.addPara("\"See you again soon, somewhere!\" " + hd.getHeOrShe() + " says. \"In my line of work, even I don't " + "know for sure where I'll end up in a couple of months.\"");
            this.done = true;
            return;
        }
        boolean initedOffer = false;
        if (optionData instanceof HistorianData.HistorianOffer) {
            this.currentOffer = (HistorianData.HistorianOffer)optionData;
            this.currentOffer.init(this.dialog);
            initedOffer = true;
        }
        if (this.currentOffer != null) {
            if (!initedOffer) {
                this.currentOffer.optionSelected(optionText, optionData);
            }
            if (this.currentOffer.isInteractionFinished()) {
                if (this.currentOffer.shouldRemoveOffer()) {
                    this.offers.remove(this.currentOffer);
                    BarEventManager.getInstance().notifyWasInteractedWith(this);
                }
                this.currentOffer.notifyAccepted();
                if (this.currentOffer.shouldEndConversationOnReturning()) {
                    this.currentOffer = null;
                    this.optionSelected(null, (Object)OptionId.END_CONVERSATION);
                } else {
                    this.currentOffer = null;
                    this.optionSelected(null, (Object)OptionId.WHAT_DO_YOU_HAVE);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        GREETING,
        GREETNG_CONTINUE_1,
        GREETNG_ALREADY_INTRODUCED,
        GREETNG_PLOG,
        WHAT_DO_YOU_HAVE,
        BACKSTORY_BIT,
        END_CONVERSATION;

    }
}

