/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOfferWithLocation;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;

public class ShipBlueprintOffer
extends BaseHistorianOfferWithLocation {
    protected String data;

    public ShipBlueprintOffer(SectorEntityToken entity, String data) {
        super(entity);
        this.data = data;
    }

    public void addPromptAndOption(InteractionDialogAPI dialog) {
        ShipHullSpecAPI spec = Global.getSettings().getHullSpec(this.data);
        dialog.getOptionPanel().addOption("... the possible location of a blueprint (" + spec.getHullNameWithDashClass() + " " + spec.getDesignation() + ")", this);
        SetStoryOption.set(dialog, 1, this, "historianBP", Sounds.STORY_POINT_SPEND_TECHNOLOGY, "Learned location of " + spec.getHullNameWithDashClass() + " " + spec.getDesignation() + " blueprint");
    }

    public String getSortString() {
        return "Ship Blueprint";
    }

    public String getName() {
        ShipHullSpecAPI spec = Global.getSettings().getHullSpec(this.data);
        if (this.isEnding()) {
            return String.valueOf(spec.getHullName()) + " Blueprint - Recovered";
        }
        return String.valueOf(spec.getHullName()) + " Blueprint Location";
    }

    protected void addItemToCargo(CargoAPI loot) {
        loot.addSpecial(new SpecialItemData("ship_bp", this.data), 1.0f);
    }

    public String getData() {
        return this.data;
    }
}

